/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import java.util.ArrayList;
import java.util.List;
import rossi.fstools.fs.File;
import rossi.fstools.fs.reiserfs.DirectItem;
import rossi.fstools.fs.reiserfs.IndirectItem;
import rossi.fstools.io.BlockPointer;
import rossi.fstools.io.BlockPointerInputStream;
import rossi.fstools.io.BlockReader;

public class ReiserFile
implements File {
    protected List blkPointerList = new ArrayList();
    protected List slackList = new ArrayList();
    protected long size;
    protected long sizeRemaining;
    protected BlockReader reader;

    public ReiserFile(long fileSize, BlockReader reader) {
        this.size = fileSize;
        this.reader = reader;
        this.sizeRemaining = this.size;
    }

    public void add(IndirectItem ind) {
        BlockPointer lastBp = null;
        int lastend = 0;
        int lastendoffset = 0;
        int[] entries = ind.getEntries();
        int blksize = ind.getBlock().getSuperBlock().getBlockSize();
        for (int i = 0; i < entries.length; ++i) {
            BlockPointer bp;
            int curSize;
            int n = curSize = this.sizeRemaining < (long)blksize ? (int)this.sizeRemaining : blksize;
            if (this.blkPointerList.size() != 0) {
                lastBp = (BlockPointer)this.blkPointerList.get(this.blkPointerList.size() - 1);
                lastend = lastBp.getBlockNum() + (lastBp.getOffset() + lastBp.getLength()) / blksize;
                lastendoffset = (lastBp.getOffset() + lastBp.getLength()) % blksize;
            }
            if (lastBp != null && lastend == entries[i] && lastendoffset == 0) {
                lastBp.setLength(lastBp.getLength() + curSize);
            } else {
                bp = new BlockPointer();
                bp.setBlockNum(entries[i]);
                bp.setOffset(0);
                bp.setLength(curSize);
                bp.setBlockSize(blksize);
                this.blkPointerList.add(bp);
            }
            if (curSize != blksize) {
                bp = new BlockPointer();
                bp.setBlockNum(entries[i]);
                bp.setOffset(curSize);
                bp.setLength(blksize - curSize);
                bp.setBlockSize(blksize);
                this.slackList.add(bp);
            }
            this.sizeRemaining -= (long)curSize;
        }
    }

    public void add(DirectItem itm) {
        BlockPointer bpi = itm.getBlockPointer();
        int blksize = bpi.getLength();
        int curSize = this.sizeRemaining < (long)blksize ? (int)this.sizeRemaining : blksize;
        BlockPointer bp = new BlockPointer();
        bp.setBlockNum(bpi.getBlockNum());
        bp.setOffset(bpi.getOffset());
        bp.setLength(curSize);
        bp.setBlockSize(bpi.getBlockSize());
        this.blkPointerList.add(bp);
        if (curSize != blksize) {
            bp = new BlockPointer();
            bp.setBlockNum(bpi.getBlockNum());
            bp.setOffset(bpi.getOffset() + curSize);
            bp.setLength(blksize - curSize);
            bp.setBlockSize(bpi.getBlockSize());
            this.slackList.add(bp);
        }
        this.sizeRemaining -= (long)curSize;
    }

    public BlockPointerInputStream getData() {
        return new BlockPointerInputStream(this.reader, this.blkPointerList);
    }

    public BlockPointerInputStream getSlack() {
        return new BlockPointerInputStream(this.reader, this.slackList);
    }
}

