/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import java.io.IOException;
import rossi.fstools.fs.Device;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.File;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsObject;
import rossi.fstools.fs.Inode;
import rossi.fstools.fs.InodePtr;
import rossi.fstools.fs.SuperBlock;
import rossi.fstools.fs.SymLink;
import rossi.fstools.fs.reiserfs.DirectItem;
import rossi.fstools.fs.reiserfs.DirectoryItem;
import rossi.fstools.fs.reiserfs.DiskChild;
import rossi.fstools.fs.reiserfs.FBlock;
import rossi.fstools.fs.reiserfs.IndirectItem;
import rossi.fstools.fs.reiserfs.InternalNode;
import rossi.fstools.fs.reiserfs.Item;
import rossi.fstools.fs.reiserfs.Key;
import rossi.fstools.fs.reiserfs.KeyV2;
import rossi.fstools.fs.reiserfs.LeafNode;
import rossi.fstools.fs.reiserfs.ReiserDevice;
import rossi.fstools.fs.reiserfs.ReiserDirectory;
import rossi.fstools.fs.reiserfs.ReiserFifo;
import rossi.fstools.fs.reiserfs.ReiserFile;
import rossi.fstools.fs.reiserfs.ReiserSocket;
import rossi.fstools.fs.reiserfs.ReiserSuperBlock;
import rossi.fstools.fs.reiserfs.ReiserSymLink;
import rossi.fstools.fs.reiserfs.StatDataItem;
import rossi.fstools.io.BlockCache;
import rossi.fstools.io.BlockReader;

public class ReiserFileSystem
implements FileSystem {
    private BlockReader blockReader;
    private ReiserSuperBlock sb;
    private BlockCache cache;

    public SuperBlock open(BlockReader br) throws FsException, IOException {
        this.blockReader = br;
        this.cache = new BlockCache(20);
        br.setBlockSize(4096);
        this.sb = new ReiserSuperBlock();
        this.sb.loadFromBuffer(br.getBlock(16), 0);
        br.setBlockSize(this.sb.getBlockSize());
        return this.sb;
    }

    public void close() throws IOException {
        this.blockReader.close();
    }

    public InodePtr getRootDir() {
        KeyV2 key = new KeyV2();
        key.setParentDirId(1L);
        key.setObjectId(2L);
        key.setOffset(0L);
        key.setType(0);
        return key;
    }

    protected FBlock getNode(int blkno) throws IOException, FsException {
        FBlock nodeBlock = (FBlock)this.cache.getBlockFromCache(blkno);
        if (nodeBlock == null) {
            byte[] buffer = this.blockReader.getBlock(blkno);
            nodeBlock = FBlock.createFromBuffer(this.sb, blkno, buffer, 0);
            this.cache.addBlockToCache(blkno, nodeBlock);
        }
        if (nodeBlock.getBlockNum() != blkno) {
            throw new FsException("Cache error");
        }
        return nodeBlock;
    }

    public Inode getInode(InodePtr ptr) throws IOException, FsException {
        Key key = (Key)ptr;
        StatDataItem sd = (StatDataItem)this.findNextItem(key);
        return sd;
    }

    public LeafNode findLeaf(Key key) throws FsException, IOException {
        FBlock currentBlock = this.getNode((int)this.sb.getRootBlock());
        while (currentBlock instanceof InternalNode) {
            InternalNode intnode = (InternalNode)currentBlock;
            DiskChild child = intnode.getPointerForKey(key);
            int blkno = (int)child.getBlockNumber();
            FBlock nextBlock = this.getNode(blkno);
            nextBlock.setParent(currentBlock);
            currentBlock = nextBlock;
        }
        return (LeafNode)currentBlock;
    }

    public LeafNode findLeftMostLeaf(FBlock parent, int startblock) throws FsException, IOException {
        FBlock currentBlock = this.getNode(startblock);
        currentBlock.setParent(parent);
        while (currentBlock instanceof InternalNode) {
            InternalNode intnode = (InternalNode)currentBlock;
            DiskChild child = intnode.getPtrs()[0];
            int blkno = (int)child.getBlockNumber();
            FBlock nextBlock = this.getNode(blkno);
            nextBlock.setParent(currentBlock);
            currentBlock = nextBlock;
        }
        return (LeafNode)currentBlock;
    }

    public LeafNode nextLeaf(LeafNode current) throws FsException, IOException {
        DiskChild[] ptrs;
        int rightblock;
        int blockno = current.getBlockNum();
        InternalNode intnode = (InternalNode)current.getParent();
        while (blockno == (rightblock = (int)(ptrs = intnode.getPtrs())[ptrs.length - 1].getBlockNumber())) {
            blockno = intnode.getBlockNum();
            intnode = (InternalNode)intnode.getParent();
        }
        for (int i = 0; i < ptrs.length; ++i) {
            int bn = (int)ptrs[i].getBlockNumber();
            if (bn != blockno) continue;
            return this.findLeftMostLeaf(intnode, (int)ptrs[i + 1].getBlockNumber());
        }
        throw new FsException("Error finding next leaf");
    }

    public Item findNextItem(Key key) throws FsException, IOException {
        byte[] buffer;
        LeafNode leaf = this.findLeaf(key);
        Item itm = leaf.getItem(buffer = this.blockReader.getBlock(leaf.getBlockNum()), 0, key);
        if (itm == null) {
            leaf = this.nextLeaf(leaf);
            buffer = this.blockReader.getBlock(leaf.getBlockNum());
            itm = leaf.getItem(buffer, 0, key);
        }
        return itm;
    }

    public SymLink createReiserSymLink(StatDataItem sdItem) throws FsException, IOException {
        return new ReiserSymLink((ReiserFile)this.createReiserFile(sdItem));
    }

    public File createReiserFile(StatDataItem sdItem) throws FsException, IOException {
        long bytesLeft;
        KeyV2 searchKey = new KeyV2();
        Key inodeKey = sdItem.getHeader().getKey();
        searchKey.setParentDirId(inodeKey.getParentDirId());
        searchKey.setObjectId(inodeKey.getObjectId());
        searchKey.setOffset(0L);
        searchKey.setType(1);
        long fileSize = bytesLeft = sdItem.getSize();
        ReiserFile file = new ReiserFile(fileSize, this.blockReader);
        while (bytesLeft > 0L) {
            Item item = this.findNextItem(searchKey);
            if (item.getHeader().getKey().getObjectId() != searchKey.getObjectId()) {
                throw new FsException("Unexpected end of file");
            }
            if (item instanceof IndirectItem) {
                int entries = ((IndirectItem)item).numEntries();
                file.add((IndirectItem)item);
                bytesLeft -= (long)(this.sb.getBlockSize() * entries);
            }
            if (item instanceof DirectItem) {
                file.add((DirectItem)item);
                bytesLeft -= (long)item.getHeader().getItemLen();
            }
            searchKey.setOffset(fileSize - bytesLeft);
        }
        return file;
    }

    public Directory createReiserDirectory(StatDataItem sdItem) throws FsException, IOException {
        DirectoryItem dirItem;
        Key searchKey = new KeyV2();
        Key inodeKey = sdItem.getHeader().getKey();
        searchKey.setParentDirId(inodeKey.getParentDirId());
        searchKey.setObjectId(inodeKey.getObjectId());
        searchKey.setOffset(1L);
        searchKey.setType(3);
        ReiserDirectory directory = new ReiserDirectory();
        for (long bytesLeft = sdItem.getSize(); bytesLeft > 0L; bytesLeft -= (long)dirItem.getHeader().getItemLen()) {
            dirItem = (DirectoryItem)this.findNextItem(searchKey);
            directory.add(dirItem);
            try {
                searchKey = (Key)dirItem.getHeader().getKey().clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new FsException("key must be cloneable");
            }
            searchKey.setOffset(searchKey.getOffset() + 1L);
        }
        return directory;
    }

    public Device createReiserDevice(StatDataItem sdItem) throws FsException, IOException {
        return new ReiserDevice(sdItem);
    }

    public FsObject getObject(Inode inode) throws FsException, IOException {
        StatDataItem sdItem = (StatDataItem)inode;
        Key key = sdItem.getHeader().getKey();
        int fileType = inode.getMode() & 0xF000;
        switch (fileType) {
            case 16384: {
                return this.createReiserDirectory(sdItem);
            }
            case 32768: {
                return this.createReiserFile(sdItem);
            }
            case 40960: {
                return this.createReiserSymLink(sdItem);
            }
            case 24576: {
                return this.createReiserDevice(sdItem);
            }
            case 8192: {
                return this.createReiserDevice(sdItem);
            }
            case 49152: {
                return new ReiserSocket();
            }
            case 4096: {
                return new ReiserFifo();
            }
        }
        throw new FsException("Unsupported file type " + fileType);
    }
}

