/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.SymLink;
import rossi.fstools.fs.reiserfs.ReiserFile;

public class ReiserSymLink
implements SymLink {
    private String linkTarget;

    public ReiserSymLink(ReiserFile f) throws IOException, FsException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.copyFile(f.getData(), bout);
        try {
            this.linkTarget = new String(bout.toByteArray(), "ISO-8859-1");
            int zeroidx = this.linkTarget.indexOf(0);
            if (zeroidx > 0) {
                this.linkTarget = this.linkTarget.substring(0, zeroidx);
            }
        }
        catch (Exception ex) {
            FsException fex = new FsException(ex.getMessage());
            fex.initCause(ex);
            throw fex;
        }
    }

    public String getLink() {
        return this.linkTarget;
    }

    private void copyFile(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
            out.write(buffer, 0, bytesRead);
            out.flush();
        }
        in.close();
        out.close();
    }
}

