/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.Inode;
import rossi.fstools.fs.reiserfs.Item;
import rossi.fstools.fs.reiserfs.ItemHead;
import rossi.fstools.fs.reiserfs.LeafNode;
import rossi.fstools.fs.reiserfs.StatDataV1;
import rossi.fstools.fs.reiserfs.StatDataV2;

public abstract class StatDataItem
extends Item
implements Inode {
    public StatDataItem(byte[] buffer, int bufferOffset, LeafNode block, ItemHead header) throws FsException {
        super(buffer, bufferOffset, block, header);
    }

    public abstract int getMode();

    public abstract void setMode(int var1);

    public abstract long getNumLinks();

    public abstract void setNumLinks(long var1);

    public abstract long getUserId();

    public abstract void setUserId(long var1);

    public abstract long getGroupId();

    public abstract void setGroupId(long var1);

    public abstract long getSize();

    public abstract void setSize(long var1);

    public abstract long getAccessTime();

    public abstract void setAccessTime(long var1);

    public abstract long getModifyTime();

    public abstract void setModifyTime(long var1);

    public abstract long getChangedTime();

    public abstract void setChangedTime(long var1);

    public abstract long getBlocks();

    public abstract void setBlocks(long var1);

    public abstract int getRDev();

    public static StatDataItem create(byte[] buffer, int bufferOffset, LeafNode block, ItemHead header) throws FsException {
        int itemSize = header.getItemLen();
        if (itemSize == StatDataV1.getDataSize()) {
            return new StatDataV1(buffer, bufferOffset, block, header);
        }
        if (itemSize == StatDataV2.getDataSize()) {
            return new StatDataV2(buffer, bufferOffset, block, header);
        }
        throw new FsException("Invalid size for Stat item " + itemSize);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Mode=0x" + Integer.toHexString(this.getMode()));
        sb.append(",numlinks=" + this.getNumLinks());
        sb.append(",userid=" + this.getUserId());
        sb.append(",groupid=" + this.getGroupId());
        sb.append(",size=" + this.getSize());
        sb.append(",atime=" + this.getAccessTime());
        sb.append(",mtime=" + this.getModifyTime());
        sb.append(",ctime=" + this.getChangedTime());
        sb.append(",blocks=" + this.getBlocks());
        sb.append("]");
        return sb.toString();
    }
}

