/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.reiserfs.ItemHead;
import rossi.fstools.fs.reiserfs.LeafNode;
import rossi.fstools.fs.reiserfs.StatDataItem;

public class StatDataV1
extends StatDataItem {
    protected int mode;
    protected int numLinks;
    protected int userId;
    protected int groupId;
    protected long size;
    protected long accessTime;
    protected long modifyTime;
    protected long changedTime;
    protected long blocks;
    protected long firstDirect;

    public StatDataV1(byte[] buffer, int bufferOffset, LeafNode block, ItemHead header) throws FsException {
        super(buffer, bufferOffset, block, header);
        this.load();
    }

    public static int getDataSize() {
        return 32;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int aMode) {
        this.mode = aMode;
    }

    public long getNumLinks() {
        return this.numLinks;
    }

    public void setNumLinks(long aNumLinks) {
        this.numLinks = (int)aNumLinks;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long aUserId) {
        this.userId = (int)aUserId;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(long aGroupId) {
        this.groupId = (int)aGroupId;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long aSize) {
        this.size = aSize;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(long aAccessTime) {
        this.accessTime = aAccessTime;
    }

    public long getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(long aModifyTime) {
        this.modifyTime = aModifyTime;
    }

    public long getChangedTime() {
        return this.changedTime;
    }

    public void setChangedTime(long aChangedTime) {
        this.changedTime = aChangedTime;
    }

    public long getBlocks() {
        return this.blocks;
    }

    public void setBlocks(long aBlocks) {
        this.blocks = aBlocks;
    }

    public long getFirstDirect() {
        return this.firstDirect;
    }

    public void setFirstDirect(long aFirstDirect) {
        this.firstDirect = aFirstDirect;
    }

    public int getRDev() {
        return (int)(this.firstDirect & 0xFFFFL);
    }

    public void load() throws FsException {
        int blkoffset = this.bufferOffset + this.header.getItemLocation();
        this.setMode(FsUtils.getU16(this.buffer, blkoffset + 0));
        this.setNumLinks(FsUtils.getU16(this.buffer, blkoffset + 2));
        this.setUserId(FsUtils.getU16(this.buffer, blkoffset + 4));
        this.setGroupId(FsUtils.getU16(this.buffer, blkoffset + 6));
        this.setSize(FsUtils.getU32(this.buffer, blkoffset + 8));
        this.setAccessTime(FsUtils.getU32(this.buffer, blkoffset + 12));
        this.setModifyTime(FsUtils.getU32(this.buffer, blkoffset + 16));
        this.setChangedTime(FsUtils.getU32(this.buffer, blkoffset + 20));
        this.setBlocks(FsUtils.getU32(this.buffer, blkoffset + 24));
        this.setFirstDirect(FsUtils.getU32(this.buffer, blkoffset + 28));
    }
}

