/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.reiserfs.ItemHead;
import rossi.fstools.fs.reiserfs.LeafNode;
import rossi.fstools.fs.reiserfs.StatDataItem;

public class StatDataV2
extends StatDataItem {
    protected int mode;
    protected int attrs;
    protected long numLinks;
    protected long size;
    protected long userId;
    protected long groupId;
    protected long accessTime;
    protected long modifyTime;
    protected long changedTime;
    protected long blocks;
    protected long generation;
    public static final int IMMUTABLE = 16;
    public static final int SYNC = 8;
    public static final int NOATIME = 128;
    public static final int NODUMP = 64;
    public static final int SECRM = 1;
    public static final int UNRM = 2;
    public static final int COMPR = 4;
    public static final int NOTAIL = 32768;

    public StatDataV2(byte[] buffer, int bufferOffset, LeafNode block, ItemHead header) throws FsException {
        super(buffer, bufferOffset, block, header);
        this.load();
    }

    public static int getDataSize() {
        return 44;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int aMode) {
        this.mode = aMode;
    }

    public int getAttrs() {
        return this.attrs;
    }

    public void setAttrs(int aAttrs) {
        this.attrs = aAttrs;
    }

    public long getNumLinks() {
        return this.numLinks;
    }

    public void setNumLinks(long aNumLinks) {
        this.numLinks = aNumLinks;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long aSize) {
        this.size = aSize;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long aUserId) {
        this.userId = aUserId;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(long aGroupId) {
        this.groupId = aGroupId;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(long aAccessTime) {
        this.accessTime = aAccessTime;
    }

    public long getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(long aModifyTime) {
        this.modifyTime = aModifyTime;
    }

    public long getChangedTime() {
        return this.changedTime;
    }

    public void setChangedTime(long aChangedTime) {
        this.changedTime = aChangedTime;
    }

    public long getBlocks() {
        return this.blocks;
    }

    public void setBlocks(long aBlocks) {
        this.blocks = aBlocks;
    }

    public long getGeneration() {
        return this.generation;
    }

    public void setGeneration(long aGeneration) {
        this.generation = aGeneration;
    }

    public int getRDev() {
        return (int)(this.generation & 0xFFFFL);
    }

    public void load() throws FsException {
        int blkoffset = this.bufferOffset + this.header.getItemLocation();
        this.setMode(FsUtils.getU16(this.buffer, blkoffset + 0));
        this.setAttrs(FsUtils.getU16(this.buffer, blkoffset + 2));
        this.setNumLinks(FsUtils.getU32(this.buffer, blkoffset + 4));
        this.setSize(FsUtils.getU64(this.buffer, blkoffset + 8));
        this.setUserId(FsUtils.getU32(this.buffer, blkoffset + 16));
        this.setGroupId(FsUtils.getU32(this.buffer, blkoffset + 20));
        this.setAccessTime(FsUtils.getU32(this.buffer, blkoffset + 24));
        this.setModifyTime(FsUtils.getU32(this.buffer, blkoffset + 28));
        this.setChangedTime(FsUtils.getU32(this.buffer, blkoffset + 32));
        this.setBlocks(FsUtils.getU32(this.buffer, blkoffset + 36));
        this.setGeneration(FsUtils.getU32(this.buffer, blkoffset + 40));
    }
}

