/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.io;

import java.util.ArrayList;
import java.util.Iterator;

public class BlockCache {
    protected ArrayList cache;
    protected int cacheSize = 10;

    public BlockCache(int size) {
        this.cacheSize = size;
        this.clearCache();
    }

    public void clearCache() {
        this.cache = new ArrayList();
    }

    public Object getBlockFromCache(int blkno) {
        BlockHolder result = null;
        Iterator itr = this.cache.iterator();
        while (itr.hasNext()) {
            BlockHolder bh = (BlockHolder)itr.next();
            if (bh.getNum() != blkno) continue;
            itr.remove();
            result = bh;
            break;
        }
        if (result != null) {
            this.cache.add(0, result);
        }
        if (result == null) {
            return null;
        }
        return result.getData();
    }

    public void addBlockToCache(int blkno, Object blk) {
        BlockHolder bh = new BlockHolder(blkno, blk);
        this.cache.add(0, bh);
        if (this.cache.size() > this.cacheSize) {
            this.cache.remove(this.cache.size() - 1);
        }
    }

    class BlockHolder {
        protected int num;
        protected Object data;

        BlockHolder(int num, Object data) {
            this.num = num;
            this.data = data;
        }

        public int getNum() {
            return this.num;
        }

        public void setNum(int aNum) {
            this.num = aNum;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object aData) {
            this.data = aData;
        }

        public boolean equals(Object obj) {
            BlockHolder other = (BlockHolder)obj;
            return other.num == this.num;
        }
    }
}

