/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.partition;

import rossi.fstools.fs.DiskStructure;
import rossi.fstools.fs.FsException;
import rossi.fstools.partition.Partition;

public class PartitionTable
implements DiskStructure {
    protected Partition[] partitions = new Partition[4];

    public Partition[] getPartitions() {
        return this.partitions;
    }

    public void setPartitions(Partition[] aPartitions) {
        this.partitions = aPartitions;
    }

    public int getDataSize() {
        return 256;
    }

    public void loadFromBuffer(byte[] buffer, int offset) throws FsException {
        if ((buffer[510] & 0xFF) != 85 || (buffer[511] & 0xFF) != 170) {
            throw new FsException("Invalid parition table");
        }
        for (int i = 0; i < 4; ++i) {
            this.partitions[i] = new Partition();
            this.partitions[i].loadFromBuffer(buffer, offset + 446 + i * this.partitions[i].getDataSize());
        }
    }
}

