/*
 * $Id: Device.java,v 1.2 2004/04/05 20:38:33 wrossi Exp $
 
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: Device.java,v $
 * Revision 1.2  2004/04/05 20:38:33  wrossi
 * Add javadocs
 *
 * Revision 1.1  2003/12/08 21:32:48  wrossi
 * Added device support
 *
 *
 */

package rossi.fstools.fs;

/**
 *  Representation of a unix device.
 */
public interface Device extends FsObject
{

  /**
   * @return true if this represents a block device
   */
  public boolean isBlockDev();

  /**
   * @return true if this is a character device
   */
  public boolean isCharDev();

  /**
   * Get the major device type.
   * @return the major device number
   */
  public int getMajor();

  /**
   * Get the minor device type.
   * @return the minor device number
   */
  public int getMinor();
}
