/*
 * $Id: Inode.java,v 1.4 2004/04/08 12:33:42 wrossi Exp $
 
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: Inode.java,v $
 * Revision 1.4  2004/04/08 12:33:42  wrossi
 * Adding javadocs
 *
 * Revision 1.3  2004/04/06 20:38:20  wrossi
 * Improving javadocs
 *
 * Revision 1.2  2003/11/18 21:40:25  wrossi
 * Adding dir read support
 *
 * Revision 1.1  2003/11/18 11:01:39  wrossi
 * Added generic fs interface
 *
 *
 */

package rossi.fstools.fs;

/** An inode contains meta-data about a file system object. */
public interface Inode
{
  /** Mask for the portion of mode that determines object type. */
  public final static int FILETYPE_MASK =  0170000;
  public final static int DIRECTORY_MODE = 0040000;
  public final static int CHARDEV_MODE   = 0020000;
  public final static int BLOCKDEV_MODE  = 0060000;
  /** A regular file */
	public final static int FILE_MODE      = 0100000;	/* Regular file.  */
  public final static int FIFO_MODE      = 0010000;
  public final static int SYMLINK_MODE   = 0120000;
  public final static int SOCKET_MODE    = 0140000;

  /**
   * Get the mode of the object.  The least significant 12 bits control
   * the object's access permissions.  The next 4 bits control the type
   * of the object.
   *
   * @return  the mode
   */
  public int getMode();

  /**
   * Set the mode.
   *
   * @see #getMode()
   * @param aMode the mode.
   */
  public void setMode(int aMode);

  /**
   * Get the number of hard links to this file.  A value of zero indicates
   * that the object is deleted.  A hard link is a directory entry pointing
   * directly at this object (not via symlinks).
   *
   * @return the number of links
   */
  public long getNumLinks();
  public void setNumLinks(long aNumLinks);

  /**
   * Get the user id of the object's owner.
   *
   * @return  the user id
   */
  public long getUserId();
  public void setUserId(long aUserId);

  /**
   * Get the group id of the object's owner.
   *
   * @return the group id
   */
  public long getGroupId();
  public void setGroupId(long aGroupId);

  /**
   * Get the size of the data associated with the object.   This is mostly 
   * meaningful with normal files. 
   * @return the size
   */
  public long getSize();
  public void setSize(long aSize);

  /**
   * Get the time the data was last accessed.
   * @return the access time.
   */
  public long getAccessTime();
  public void setAccessTime(long aAccessTime);

  /**
   * Get the time the data was last modified.
   * @return the access time.
   */
  public long getModifyTime();
  public void setModifyTime(long aModifyTime);

  /**
   * Get the time this Inode metadata was last changed.
   * @return long
   */
  public long getChangedTime();
  public void setChangedTime(long aChangedTime);
}
