/*
 * $Id: Ext2Device.java,v 1.2 2004/04/09 21:11:25 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: Ext2Device.java,v $
 * Revision 1.2  2004/04/09 21:11:25  wrossi
 * Adding javadocs
 *
 * Revision 1.1  2004/04/03 19:44:27  wrossi
 * Added devices and symlinks
 *
 *
 *
 */

package rossi.fstools.fs.ext2fs;

import rossi.fstools.fs.Device;
import rossi.fstools.fs.Inode;

/**
 * Represents a device.
 */
public class Ext2Device implements Device
{
  private boolean blockDev = false;
  private boolean charDev = false;
  private int major;
  private int minor;

  /**
   * Create a device from an Inode.
   * @param inode   a Ext2Inode
   */
  public Ext2Device(Ext2Inode inode)
  {
    int dev;

    if ( (inode.getMode() & Inode.FILETYPE_MASK) == Inode.CHARDEV_MODE )
      charDev = true;

    if ( (inode.getMode() & Inode.FILETYPE_MASK) == Inode.BLOCKDEV_MODE )
      blockDev = true;

    dev = (int) inode.getDirectBlock(0);
    if (dev != 0)  // old format
    {
      major = (dev & 0xff00) >> 8;
      minor = (dev & 0xff);
    }
    else          // new format
    {
      dev = (int) inode.getDirectBlock(1);

      major = (dev & 0xfff00) >> 8;
      minor = (dev & 0xff) | ((dev >> 12) & 0xfff00);
    }
  }

  public boolean isBlockDev()
  {
    return blockDev;
  }

  public boolean isCharDev()
  {
    return charDev;
  }

  public int getMajor()
  {
    return major;
  }

  public int getMinor()
  {
    return minor;
  }
}
