/*
 * $Id: Ext2SlowSymLink.java,v 1.2 2004/04/09 21:41:05 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: Ext2SlowSymLink.java,v $
 * Revision 1.2  2004/04/09 21:41:05  wrossi
 * Added javadocs.
 *
 * Revision 1.1  2004/04/03 19:44:27  wrossi
 * Added devices and symlinks
 *
 * Revision 1.2  2003/12/17 22:04:12  wrossi
 * Handle null padding on symlinks
 *
 * Revision 1.1  2003/12/02 21:37:52  wrossi
 * started adding symlinks
 *
 * Revision 1.1  2003/11/26 21:39:24  wrossi
 * Working on file extraction
 *
 *
 */

package rossi.fstools.fs.ext2fs;

import rossi.fstools.fs.File;
import rossi.fstools.fs.SymLink;
import rossi.fstools.fs.FsException;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * Implementation of a slow symlink.  Slow symlinks are used when the link data is
 * greater than 60 bytes.  In this case link data is stored in a file.
 */

public class Ext2SlowSymLink implements SymLink
{
  private String linkTarget;

  /**
   * Create a Symlink from the data in the given File.
   * @param f   a File
   * @exception IOException
   * @exception FsException
   */
  public Ext2SlowSymLink(File f) throws IOException, FsException
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();

    copyFile(f.getData(), bout);   

    try
    {
      linkTarget = new String(bout.toByteArray(), "ISO-8859-1");

      /* May be zero padded */
      int zeroidx = linkTarget.indexOf('\u0000');
      if (zeroidx > 0)
        linkTarget = linkTarget.substring(0, zeroidx);
    }
    catch (Exception ex)
    {
      FsException fex = new FsException(ex.getMessage());
      fex.initCause(ex);
      throw fex;
    }
  }

  public String getLink()
  {
    return linkTarget;
  }

  private void copyFile(InputStream in, OutputStream out) throws IOException
  {
    int bytesRead;
    byte[] buffer;
    buffer = new byte[8192];

    while (true)
    {
      bytesRead = in.read(buffer, 0, buffer.length);
      if (bytesRead == -1)
        break;
      out.write(buffer, 0, bytesRead);
      out.flush();
    }

    in.close();
    out.close();
  }
}
