/*
 * $Id: FatRootDirFile.java,v 1.3 2004/04/22 11:40:12 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: FatRootDirFile.java,v $
 * Revision 1.3  2004/04/22 11:40:12  wrossi
 * Can extract a file from the root dir on FAT 12 now.
 *
 * Revision 1.2  2004/04/21 22:05:28  wrossi
 * Return a new InputStream on each call to getInputStream.
 *
 * Revision 1.1  2004/04/21 20:30:50  wrossi
 * Special access for the root directory.
 *
 */

package rossi.fstools.fs.fatfs;

import rossi.fstools.fs.File;
import rossi.fstools.io.BlockPointer;
import rossi.fstools.io.BlockReader;
import rossi.fstools.io.BlockPointerInputStream;

import java.util.List;
import java.util.ArrayList;

/**
 * Special file representing the root directory on FAT12 and FAT16.
 */
public class FatRootDirFile implements File
{
  private List dataList, slackList;
  private BlockReader blockReader;

  public FatRootDirFile(FatSuperBlock sb, BlockReader blockReader)
  {
    BlockPointer bp;
    int rootDirLen;

    this.blockReader = blockReader;

    dataList = new ArrayList();
    slackList = new ArrayList();

    rootDirLen = sb.getRootDirEntries() * (new FatDirEntry().getDataSize());

    bp = new BlockPointer();
    bp.setBlockNum(sb.getReservedSectors() + sb.getNumFATs()*sb.getFatLength());
    bp.setOffset(0);
    bp.setLength(rootDirLen);
    bp.setBlockSize(sb.getSectorSize());

    dataList.add(bp);

  }

  public BlockPointerInputStream getData()
  {
    return new BlockPointerInputStream(blockReader, dataList);
  }

  public BlockPointerInputStream getSlack()
  {
    return new BlockPointerInputStream(blockReader, slackList);
  }
}
