/*
 * $Id: BlockCache.java,v 1.2 2003/11/25 01:33:31 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: BlockCache.java,v $
 * Revision 1.2  2003/11/25 01:33:31  wrossi
 * Caching work
 *
 * Revision 1.1  2003/11/24 21:14:27  wrossi
 * Generalized the cache
 *
 *
 */

package rossi.fstools.io;

import java.util.ArrayList;
import java.util.Iterator;

public class BlockCache 
{
  protected ArrayList cache;
  protected int cacheSize = 10;

  public BlockCache(int size)
  {
    this.cacheSize = size;
    clearCache();
  }

  public void clearCache() 
  { 
    cache = new ArrayList();
  }

  public Object getBlockFromCache(int blkno)
  {
    BlockHolder result = null;

    for (Iterator itr=cache.iterator(); itr.hasNext(); )
    {
      BlockHolder bh = (BlockHolder) itr.next();
      if (bh.getNum() == blkno)
      {
        itr.remove();
        result = bh;
        break; 
      }
    }

    if (result != null)
      cache.add(0, result);

    if (result == null)
      return null;
 
    return result.getData();
  }

  public void addBlockToCache(int blkno, Object blk)
  {
    BlockHolder bh = new BlockHolder(blkno, blk);
    cache.add(0, bh);

    if (cache.size() > cacheSize)
      cache.remove(cache.size() - 1);
  }

  class BlockHolder
  {
    protected int num;
    protected Object data;
 
    BlockHolder(int num, Object data)
    {
      this.num = num;
      this.data = data;
    }

    public int getNum() { return num; }
    public void setNum(int aNum) { num=aNum; }

    public Object getData() { return data; }
    public void setData(Object aData) { data=aData; }

    public boolean equals(Object obj)
    {
      BlockHolder other;
      other = (BlockHolder)obj;
      return (other.num == num);
    }
  }
}
