/*
 * $Id: BlockReader.java,v 1.3 2004/02/28 20:49:16 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: BlockReader.java,v $
 * Revision 1.3  2004/02/28 20:49:16  wrossi
 * Added ability to close a filesystem.
 *
 * Revision 1.2  2003/11/05 17:34:04  wrossi
 * Use int instead of long for block numbers
 *
 * Revision 1.1  2003/11/04 12:10:36  wrossi
 * Block manaipulation routines
 *
 *
 */

package rossi.fstools.io;

import java.io.IOException;

public interface BlockReader
{
  /** Reads a block */
  public byte[] getBlock(int blkno) throws IOException;

  /** Gets the block size */
  public int getBlockSize();

  /** Sets the block size */
  public void setBlockSize(int aBlockSize);

  /** Closes this block reader */
  public void close() throws IOException;
}
