/*
 * $Id: ExtractFileAction.java,v 1.8 2004/02/28 22:13:10 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: ExtractFileAction.java,v $
 * Revision 1.8  2004/02/28 22:13:10  wrossi
 * Removed printouts
 *
 * Revision 1.7  2004/02/25 12:03:22  wrossi
 * Working on extraction
 *
 * Revision 1.6  2004/02/23 21:56:36  wrossi
 * Working on file extraction dialog
 *
 * Revision 1.5  2004/02/20 21:39:38  wrossi
 * Adding extract file dialog
 *
 * Revision 1.4  2004/02/18 21:35:06  wrossi
 * Working on menu actions
 *
 * Revision 1.3  2004/02/17 21:40:26  wrossi
 * Working on extract file menu and supporting APIs
 *
 * Revision 1.2  2004/02/11 21:39:42  wrossi
 * added menubar
 *
 * Revision 1.1  2004/02/11 21:34:04  wrossi
 * Adding menu bar and actions
 *
 * Revision 1.1  2004/02/10 21:40:54  wrossi
 *
 */

package rossi.fstoolsui.actions;

import rossi.fstoolsui.fstree.FsViewFrame;
import rossi.fstoolsui.fstree.FsViewPanel;
import rossi.fstoolsui.fstree.ExtractDialog;

import javax.swing.*;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;

public class ExtractFileAction extends AbstractAction
{
  public ExtractFileAction()
  {
    super("Extract");
  }

  public void actionPerformed(ActionEvent evt)
  {
    FsViewFrame fsViewFrame = (FsViewFrame) getValue("frame");
    FsViewPanel fsView = fsViewFrame.getFsViewPanel();
 
    ExtractDialog exd = new ExtractDialog(fsViewFrame, fsViewFrame.getFileSystem(),
                        fsView.getCurrentFsObject(), fsView.getCurrentFilename());
    exd.pack();

    Rectangle parentBounds = fsViewFrame.getBounds();
    Dimension ourSize = exd.getSize();
    
    exd.setLocation(parentBounds.x+(parentBounds.width-ourSize.width)/2,
                    parentBounds.y+(parentBounds.height-ourSize.height)/2);

    exd.show();
  }
}
