/*
 * $Id: OpenPartitionAction.java,v 1.4 2004/03/05 21:37:35 wrossi Exp $
 *
 * (C) Copyright 2004 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: OpenPartitionAction.java,v $
 * Revision 1.4  2004/03/05 21:37:35  wrossi
 * Added partition types to partition dialog
 *
 * Revision 1.3  2004/03/03 21:30:56  wrossi
 * Working on partition dialog
 *
 * Revision 1.2  2004/03/03 21:12:55  wrossi
 * Working on open partition dialog
 *
 * Revision 1.1  2004/02/28 23:36:43  wrossi
 * Working on opening partitions
 *
 * Revision 1.7  2004/02/25 12:03:22  wrossi
 * Working on extraction
 *
 */

package rossi.fstoolsui.actions;

import rossi.fstoolsui.fstree.FsViewFrame;
import rossi.fstoolsui.fstree.FsViewPanel;
import rossi.fstoolsui.fstree.OpenPartitionDialog;

import javax.swing.*;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;

public class OpenPartitionAction extends AbstractAction
{
  public OpenPartitionAction()
  {
    super("Open Partition");
  }

  public void actionPerformed(ActionEvent evt)
  {
    FsViewFrame fsViewFrame = (FsViewFrame) getValue("frame");
    FsViewPanel fsView = fsViewFrame.getFsViewPanel();
 
    OpenPartitionDialog opd = new OpenPartitionDialog(fsViewFrame);
    opd.setSize(320, 220);

    Rectangle parentBounds = fsViewFrame.getBounds();
    Dimension ourSize = opd.getSize();

    
    opd.setLocation(parentBounds.x+(parentBounds.width-ourSize.width)/2,
                    parentBounds.y+(parentBounds.height-ourSize.height)/2);

    opd.show();
  }
}
