/*
 * $Id: ExtractDialog.java,v 1.8 2004/02/27 13:01:32 wrossi Exp $
 *
 * (C) Copyright 2004 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: ExtractDialog.java,v $
 * Revision 1.8  2004/02/27 13:01:32  wrossi
 * Hooked up recursive checkbox and cancel button
 *
 * Revision 1.7  2004/02/26 21:38:54  wrossi
 * Improving extraction
 *
 * Revision 1.6  2004/02/25 21:41:32  wrossi
 * Extract working
 *
 * Revision 1.5  2004/02/25 12:03:22  wrossi
 * Working on extraction
 *
 * Revision 1.4  2004/02/24 12:34:03  wrossi
 * Working on extract dialog
 *
 * Revision 1.3  2004/02/23 21:56:36  wrossi
 * Working on file extraction dialog
 *
 * Revision 1.2  2004/02/23 12:44:22  wrossi
 * Working on layout
 *
 * Revision 1.1  2004/02/20 21:39:38  wrossi
 * Adding extract file dialog
 *
 *
 */

package rossi.fstoolsui.fstree;

import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.FsObject;
import rossi.fstools.fs.Directory;

import java.awt.Container;
import java.awt.Component;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import javax.swing.border.BevelBorder;

public class ExtractDialog extends JDialog
{
  protected JTextField targetDirTF;
  protected JTextField sourceTF;
  protected JButton fileChooseBTN;
  protected JButton okBTN, cancelBTN;
  protected JLabel statusLabel;
  protected JCheckBox recurseCB;
  protected FsObject sourceFsObj;
  protected FileSystem fs;
  protected String sourceName;
  protected ExtractDialogThread extractThread;

  public ExtractDialog(JFrame parent, FileSystem fs, FsObject sourceFsObj, String sourceName)
  {
    super(parent, "Extract File");
    this.sourceFsObj = sourceFsObj;
    this.sourceName = sourceName;
    this.fs = fs;
    initialize();
    performLayout();
  }

  protected void initialize()
  { 
    targetDirTF = new JTextField(20);
    targetDirTF.setText(System.getProperty("user.home"));
    sourceTF = new JTextField(20);
    sourceTF.setEditable(false);
    sourceTF.setText(sourceName);
    fileChooseBTN = new JButton("...");
    fileChooseBTN.addActionListener(new ActionListener()
       {
         public void actionPerformed(ActionEvent evt)
         {
           JFileChooser chooser = new JFileChooser();
           chooser.setSelectedFile(new java.io.File(targetDirTF.getText()));
           chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
           int returnVal = chooser.showOpenDialog(ExtractDialog.this);
           if(returnVal == JFileChooser.APPROVE_OPTION) 
           {
             targetDirTF.setText(chooser.getSelectedFile().getAbsolutePath());
           }
         }
       });
    statusLabel = new JLabel(" ");
    statusLabel.setBorder(new BevelBorder(BevelBorder.LOWERED));
    recurseCB = new JCheckBox("Recursive");
    recurseCB.setEnabled(sourceFsObj instanceof Directory);

    okBTN = new JButton("Ok");
    okBTN.addActionListener(new ActionListener()
      {
        public void actionPerformed(ActionEvent evt)
        {
          extractThread = new ExtractDialogThread(ExtractDialog.this, fs, sourceFsObj, 
                                   sourceName, new java.io.File(targetDirTF.getText()),
                                   recurseCB.isSelected());
          extractThread.start();
        }
      });


    cancelBTN = new JButton("Cancel");
    cancelBTN.addActionListener(new ActionListener()
      {
        public void actionPerformed(ActionEvent evt)
        {
          if (extractThread != null)
            extractThread.cancel();
          setVisible(false);
          dispose();
        }
      });
  }

  protected void performLayout()
  {
    Container pane = getContentPane();
    JPanel mainPanel;
    JPanel buttonPanel;
    GridBagLayout gridb = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    Component comp;

    mainPanel = new JPanel();
    mainPanel.setLayout(gridb);

    buttonPanel = new JPanel();

    c.gridx = 0; c.gridy = 1;
    c.gridwidth = 2; c.gridheight = 1;
    c.fill = GridBagConstraints.HORIZONTAL;
    c.weightx = 1.0; c.weighty = 0.0;

    comp = new JLabel("Extract file(s) from:");
    gridb.setConstraints(comp, c);
    mainPanel.add(comp);

    c.gridx = 0; c.gridy = 2;
    c.gridwidth = 2; c.gridheight = 1;
    c.fill = GridBagConstraints.HORIZONTAL;
    c.weightx = 1.0; c.weighty = 0.0;

    comp = sourceTF;
    gridb.setConstraints(comp, c);
    mainPanel.add(comp);
 
    c.gridx = 0; c.gridy = 3;
    c.gridwidth = 2; c.gridheight = 1;
    c.fill = GridBagConstraints.HORIZONTAL;
    c.weightx = 1.0; c.weighty = 0.0;

    comp = new JLabel("Extract file(s) to:");
    gridb.setConstraints(comp, c);
    mainPanel.add(comp);

    c.gridx = 0; c.gridy = 4;
    c.gridwidth = 1; c.gridheight = 1;
    comp = targetDirTF;
    gridb.setConstraints(comp, c);
    mainPanel.add(comp);

    c.gridx = 1; c.gridy = 4;
    c.weightx = 0.0; c.weighty = 0.0;
    comp = fileChooseBTN;
    gridb.setConstraints(comp, c);
    mainPanel.add(comp);

    c.gridx = 0; c.gridy = 5;
    c.gridwidth = 1; c.gridheight = 1;
    comp = recurseCB;
    gridb.setConstraints(comp, c);
    mainPanel.add(comp);

    c.gridx = 0; c.gridy = 6;
    c.gridwidth = 2; c.gridheight = 1;
    c.weightx = 2.0; c.weighty = 2.0;
    comp = buttonPanel;
    gridb.setConstraints(comp, c);
    mainPanel.add(comp);

    buttonPanel.setLayout(new FlowLayout());
    buttonPanel.add(okBTN, cancelBTN);  
    buttonPanel.add(cancelBTN, cancelBTN);  

    pane.setLayout(new BorderLayout());
    pane.add(mainPanel, "Center");
    pane.add(statusLabel, "South");
  }
 
  public void setStatusText(String text)
  {
    statusLabel.setText(text);
  }
}
