/*
 * $Id: FsObjectTreeNode.java,v 1.9 2004/04/03 21:13:33 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: FsObjectTreeNode.java,v $
 * Revision 1.9  2004/04/03 21:13:33  wrossi
 * Added EXT2/3 support
 *
 * Revision 1.8  2003/12/31 21:12:23  wrossi
 * Table works somewhat now.
 *
 * Revision 1.7  2003/12/23 21:36:18  wrossi
 * Added colored tree rendering based on file mode (eg dir vs pipe vs device).
 *
 * Revision 1.6  2003/12/19 20:51:22  wrossi
 * Added some accessors
 *
 * Revision 1.5  2003/12/17 22:13:57  wrossi
 * Added support for non-directory items.  Display targets of symlinks
 *
 * Revision 1.4  2003/12/17 14:23:22  wrossi
 * Working demo
 *
 * Revision 1.3  2003/12/17 13:46:15  wrossi
 * WIP
 *
 * Revision 1.2  2003/12/12 13:31:04  wrossi
 * Wip
 *
 * Revision 1.1  2003/12/12 13:25:07  wrossi
 * TreeNode represening a file system
 *
 */

package rossi.fstoolsui.fstree;

import rossi.fstools.fs.FsObject;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.SymLink;
import rossi.fstools.fs.Device;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.Inode;
import rossi.fstools.fs.InodePtr;

import javax.swing.tree.TreeNode;

import java.util.Enumeration;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.Collections;
import java.util.Iterator;

/** simplified a bit to only show directories in the tree */
public class FsObjectTreeNode implements TreeNode
{
  private FsObject fileSystemObj;
  private FileSystem fileSys;
  private TreeNode parentNode;
  private Map inodePtrMap;
  private Map inodeMap;
  private List childList;
  private String name;
  private Inode inode;  // Inode for this object

  public FsObjectTreeNode(FileSystem fs, TreeNode parent, FsObject fsObj, Inode inode, String name)
  {
    fileSys = fs;
    parentNode = parent;
    fileSystemObj = fsObj;
    this.inode = inode;
    this.name = name;       // filename of this directory

    childList = new Vector();

    if (fileSystemObj instanceof Directory == false)
      return;

    inodePtrMap = ((Directory)fileSystemObj).getInodePtrMap();

    try
    {
      List childNameList;

      inodeMap = new HashMap();
      childNameList = new Vector();

      childNameList.addAll(inodePtrMap.keySet());
      Collections.sort(childNameList);

      for (Iterator itr=childNameList.iterator(); itr.hasNext(); )
      {
        Inode childInode;
        String child = (String) itr.next();

        childInode = fs.getInode((InodePtr) inodePtrMap.get(child));

        //if ((inode.getMode() & Inode.FILETYPE_MASK) == Inode.DIRECTORY_MODE)
        {
          inodeMap.put(child, childInode);
          childList.add(child);
        }
      }
    }
    catch (Exception ex)
    {
      ex.printStackTrace();
    }
  }

  protected FsObjectTreeNode createNode(String child)
  {
    FsObject childObj;
 
    try
    {
      Inode childInode = (Inode) inodeMap.get(child);
      childObj = (FsObject) fileSys.getObject(childInode);

      return new FsObjectTreeNode(fileSys, this, childObj, childInode, child);
    }
    catch (Exception ex)
    {
      ex.printStackTrace();
      return null;
    }
  }

  public String toString()
  {
    return getName();
  }

  public Inode getInode()
  {
    return inode;
  }

  public FsObject getFsObject()
  {
    return fileSystemObj;
  }

  public int getMode()
  {
    return inode.getMode();
  }

  protected String getName()
  {
    return name;
  }

  public Enumeration children()
  {
    return new Enumeration() 
      {
        int idx = 0;

        public boolean hasMoreElements()
        {
          return idx < childList.size();
        }

        public Object nextElement()
        {
          return getChildAt(idx++);
        }
      };
  }

  public boolean getAllowsChildren()
  {
    return true;
  }

  public TreeNode getChildAt(int idx)
  {
    return createNode((String) childList.get(idx));
  }

  public int getChildCount()
  {
    return childList.size();
  }

  public int getIndex(TreeNode node)
  {
    String child;

    child = ((FsObjectTreeNode) node).getName();

    for (int i=0; i<childList.size(); i++)
      if (child.equals(childList.get(i)))
        return i;

    return -1;
  }

  public TreeNode getParent()
  {
    return parentNode;
  }

  public boolean isLeaf()
  {
    return (childList.size() == 0);  // every dir has a . and .. entry
  }

  public List getChildList()
  {
    return childList;
  }

  public Map getInodeMap()
  {
    return inodeMap;
  }
}
