/*
 * $Id: FsTreeRenderer.java,v 1.2 2003/12/23 21:36:18 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: FsTreeRenderer.java,v $
 * Revision 1.2  2003/12/23 21:36:18  wrossi
 * Added colored tree rendering based on file mode (eg dir vs pipe vs device).
 *
 * Revision 1.1  2003/12/19 20:52:44  wrossi
 * Tree rendering
 *
 *
 */

package rossi.fstoolsui.fstree;

import rossi.fstools.fs.Inode;
import rossi.fstools.fs.SymLink;

import java.awt.Component;
import java.awt.Color;
import javax.swing.*;
import javax.swing.tree.*;

public class FsTreeRenderer extends DefaultTreeCellRenderer
{
  public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded,
                                                boolean leaf, int row, boolean hasFocus)
  {
    Component renderer = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
 
    if (value instanceof FsObjectTreeNode)
    {
      int mode = ((FsObjectTreeNode) value).getMode();
      JLabel lbl = (JLabel) renderer;
      FsObjectTreeNode node = (FsObjectTreeNode) value;

      /* The default rederer creates a JLabel with the toString() of the node
         as the text */

      if ((mode & Inode.FILETYPE_MASK) == Inode.CHARDEV_MODE)
        lbl.setForeground(Color.red);

      if ((mode & Inode.FILETYPE_MASK) == Inode.BLOCKDEV_MODE)
        lbl.setForeground(Color.red.darker());

      if ((mode & Inode.FILETYPE_MASK) == Inode.FIFO_MODE)
        lbl.setForeground(Color.green);

      if ((mode & Inode.FILETYPE_MASK) == Inode.DIRECTORY_MODE)
        lbl.setForeground(Color.blue);

      if ((mode & Inode.FILETYPE_MASK) == Inode.SOCKET_MODE)
        lbl.setForeground(Color.orange);

      if ((mode & Inode.FILETYPE_MASK) == Inode.SYMLINK_MODE)
      {
        lbl.setText(node.getName()+" -> "+((SymLink)node.getFsObject()).getLink());
        lbl.setForeground(Color.cyan);
      }
    }

    return renderer;
  }
}

