/*
 * $Id: FsViewPanel.java,v 1.14 2004/02/25 12:03:22 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: FsViewPanel.java,v $
 * Revision 1.14  2004/02/25 12:03:22  wrossi
 * Working on extraction
 *
 * Revision 1.13  2004/02/24 21:41:05  wrossi
 * Working on extraction
 *
 * Revision 1.12  2004/02/24 12:34:03  wrossi
 * Working on extract dialog
 *
 * Revision 1.11  2004/02/18 21:35:06  wrossi
 * Working on menu actions
 *
 * Revision 1.10  2004/02/17 21:40:26  wrossi
 * Working on extract file menu and supporting APIs
 *
 * Revision 1.9  2004/02/11 21:34:04  wrossi
 * Adding menu bar and actions
 *
 * Revision 1.8  2004/01/27 11:01:28  wrossi
 * Have hex display sort of working
 *
 * Revision 1.7  2004/01/23 21:39:36  wrossi
 * Adding file viewer
 *
 * Revision 1.6  2004/01/19 23:22:11  wrossi
 * fixed status bar, added renderer for devices.
 *
 * Revision 1.5  2004/01/16 21:41:17  wrossi
 * Working on status bar
 *
 * Revision 1.4  2004/01/14 11:49:11  wrossi
 * Double click on directory in table working
 *
 * Revision 1.3  2003/12/31 21:12:23  wrossi
 * Table works somewhat now.
 *
 * Revision 1.2  2003/12/31 12:22:29  wrossi
 * Hookup tree selection listeners
 *
 * Revision 1.1  2003/12/30 21:33:43  wrossi
 * Connected tree with table in FsViewPanel.
 *
 *
 */

package rossi.fstoolsui.fstree;

import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.FsObject;
import rossi.fstools.fs.File;

import java.awt.Cursor;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.*;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.*;

import java.util.Collections;
import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;

public class FsViewPanel extends JPanel implements TreeSelectionListener
{
  protected FsTree fstree;
  protected InodeTablePanel inodePanel;
  protected FileViewPanel fileViewPanel;
  protected FsObject currentFsObj = null;
  protected String currentFname = null;
  protected JLabel pathLbl;
  protected List listSelectionListeners = new ArrayList();

  public FsViewPanel()
  {
    initialize();
    performLayout();
  }
 
  protected void initialize()
  {
    fstree = new FsTree();
    fstree.addTreeSelectionListener(this);
    inodePanel = new InodeTablePanel();
    fileViewPanel = new FileViewPanel();
    pathLbl = new JLabel("/");

    inodePanel.addActionListener(new ActionListener()
      {
        public void actionPerformed(ActionEvent evt)
        {
          ArrayList list = new ArrayList();
          FsObjectTreeNode node = inodePanel.getFsObjectNode();
          while (true)
          {
            list.add(node);
            if (node.getParent() instanceof FsObjectTreeNode == false)
              break;

            node = (FsObjectTreeNode) node.getParent();

            if (node.toString().equals("/"))  // at root node?
              break;
          }
          Collections.reverse(list);

          StringBuffer sb = new StringBuffer();
          for (Iterator itr=list.iterator(); itr.hasNext(); )
          {
            node = (FsObjectTreeNode) itr.next();
            
            sb.append("/");
            sb.append(node.toString());
          }
          pathLbl.setText(sb.toString());

        }
      });

    inodePanel.getTable().addMouseListener(new MouseAdapter()
      {
        public void mouseClicked(MouseEvent evt)
        {
          if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 1)
          {
            try
            {
              FsObject fsobj = inodePanel.getSelectedFsObject();

              setCurrentFsObj(fsobj, inodePanel.getSelectedFilename());
            }
            catch (Exception ex)
            {
              ex.printStackTrace();
            }
          }
        }
      });
  }

  protected void performLayout()
  {
    JScrollPane sp;
    JSplitPane splitter, fsplitter;
    setLayout(new BorderLayout());

    sp = new JScrollPane(fstree);
    fsplitter = new JSplitPane(JSplitPane.VERTICAL_SPLIT, false, inodePanel, fileViewPanel);
    fsplitter.setDividerLocation(200);

    splitter = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, false, sp, fsplitter);
    splitter.setDividerLocation(100);
    add(splitter, "Center");
    add(pathLbl, "South");
  }

  public void setFileSystem(FileSystem fs) throws Exception
  {
    fstree.setFileSystem(fs);
    inodePanel.setFileSystem(fs);
  }

  public FileSystem getFileSystem()
  {
    return inodePanel.getFileSystem();
  }

  public FsObject getCurrentFsObject()
  {
    return currentFsObj;
  }

  public String getCurrentFilename()
  { 
    return currentFname;
  }

  public void addListSelectionListener(ListSelectionListener listener)
  {
    listSelectionListeners.add(listener);
  }

  public void removeListSelectionListener(ListSelectionListener listener)
  {
    listSelectionListeners.remove(listener);
  }

  protected void fireListSelectionEvent(ListSelectionEvent evt)
  {
    for (Iterator itr=listSelectionListeners.iterator(); itr.hasNext(); )
    {
      ListSelectionListener al = (ListSelectionListener) itr.next();
      al.valueChanged(evt);
    }
  }
 
  protected void setCurrentFsObj(FsObject fsobj, String name)
  {
    /* Set the current object */
    currentFsObj = fsobj;
    currentFname = name;

    if (currentFsObj instanceof File)
    {
      Cursor c = getCursor();
      setCursor(new Cursor(Cursor.WAIT_CURSOR));

      /* This could take some time */
      fileViewPanel.setFile((File) currentFsObj);

      setCursor(c);
    }

    // Fire a bogus selection event. -- the indicies are bogus.
    fireListSelectionEvent(new ListSelectionEvent(this, 0, 0, false));
  }

  public void valueChanged(TreeSelectionEvent evt)
  {
    TreePath path = evt.getPath();

    //System.out.println(path.getLastPathComponent().getClass().getName());

    TreeNode node = (TreeNode) path.getLastPathComponent();

    if (node instanceof FsObjectTreeNode)
    {
      FsObjectTreeNode fnode = (FsObjectTreeNode) node;

      if (fnode.isLeaf() == false)
        inodePanel.setFsObjectNode(fnode);

      setCurrentFsObj(fnode.getFsObject(), fnode.getName());
    }
  }
}

