/*
 * $Id: InodeTableModel.java,v 1.6 2004/03/02 21:17:46 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: InodeTableModel.java,v $
 * Revision 1.6  2004/03/02 21:17:46  wrossi
 * Working on partition dialog
 *
 * Revision 1.9  2004/03/01 12:02:46  wrossi
 * Added menu items and actions
 *
 */

package rossi.fstoolsui.fstree;

import rossi.fstools.fs.Inode;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.FileSystem;
import javax.swing.table.AbstractTableModel;
import javax.swing.event.TableModelListener;
import javax.swing.event.TableModelEvent;
import java.util.List;
import java.util.Map;
import java.util.Date;

import java.text.SimpleDateFormat;
import java.text.DateFormat;

public class InodeTableModel extends AbstractTableModel
{
  protected List nameList;
  protected Map inodeMap;
  protected DateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
  protected FileSystem fs;
  
  /** Constructor.  Takes a list of InodeItem objects */
  public InodeTableModel(List l, Map m)
  {
    nameList = l;
    inodeMap = m;
  }

  public void setFileSystem(FileSystem aFs) 
  {
    fs = aFs;
  }

  public int getRowCount()
  {
    return nameList.size();
  }

  public int getColumnCount()
  {
    return 9;
  }

  public String getColumnName(int col)
  {
    String colnames[] = {"Name", "Mode", "Links", "User", "Group", "Size", "Modified", "Accessed", "Changed"};

    return colnames[col];
  }

  public Class getColumnClass(int col)
  {
    switch (col)
    {
      case 1: 
      case 2:
      case 3: 
      case 4: return Integer.class;
      case 5: return Long.class;
      case 6:
      case 7:
      case 8: return Date.class;
      default: break; 
    }
    return String.class;
  }

  public boolean isCellEditable(int row, int col)
  {
    return false;
  }

  public Object getValueAt(int row, int col)
  {
    String name = (String) nameList.get(row);

    return cellFromName(name, col);
  }

  public Object cellFromName(String name, int col)
  {
    Inode inode;
    inode = (Inode) inodeMap.get(name);

    switch (col)
    {
      case 0: return name;
/*
      case 1: return Integer.toOctalString(inode.getMode());
      case 2: return Integer.toString((int) inode.getNumLinks());
      case 3: return Integer.toString((int) inode.getUserId());
      case 4: return Integer.toString((int) inode.getGroupId());
      case 5: return Long.toString(inode.getSize());
      case 6: return df.format(new Date(inode.getModifyTime() * 1000));
      case 7: return df.format(new Date(inode.getAccessTime() * 1000));
      case 8: return df.format(new Date(inode.getChangedTime() * 1000));
*/
      case 1: return new Integer(inode.getMode());
      case 2: return new Integer((int)inode.getNumLinks());
      case 3: return new Integer((int)inode.getUserId());
      case 4: return new Integer((int)inode.getGroupId());
      case 5: return new Long(inode.getSize());
      case 6: return new Date(inode.getModifyTime() * 1000);
      case 7: return new Date(inode.getAccessTime() * 1000);
      case 8: return new Date(inode.getChangedTime() * 1000);
    }

    return "";
  }

  public void setValueAt(Object obj, int row, int col)
  {
  }

}
