/*
 * $Id: OpenPartitionDialog.java,v 1.10 2004/04/21 22:27:00 wrossi Exp $
 *
 * (C) Copyright 2004 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: OpenPartitionDialog.java,v $
 * Revision 1.10  2004/04/21 22:27:00  wrossi
 * Added fat filesystem
 *
 * Revision 1.9  2004/04/03 21:13:33  wrossi
 * Added EXT2/3 support
 *
 * Revision 1.8  2004/03/05 21:37:35  wrossi
 * Added partition types to partition dialog
 *
 * Revision 1.7  2004/03/05 12:44:15  wrossi
 * Added double click handler on partition table panel
 *
 * Revision 1.6  2004/03/04 23:24:31  wrossi
 * Fixed drive names for windows.
 *
 * Revision 1.5  2004/03/04 21:35:00  wrossi
 * Working partition dialog
 *
 * Revision 1.4  2004/03/04 21:16:58  wrossi
 * Working on partition table dialog
 *
 * Revision 1.3  2004/03/03 21:30:14  wrossi
 * Working on partition dialog
 *
 * Revision 1.2  2004/03/03 21:12:55  wrossi
 * Working on open partition dialog
 *
 * Revision 1.1  2004/03/02 21:17:46  wrossi
 * Working on partition dialog
 *
 * Revision 1.8  2004/02/27 13:01:32  wrossi
 */

package rossi.fstoolsui.fstree;

import rossi.fstools.fs.FileSystem;
import rossi.fstools.io.BlockIO;
import rossi.fstools.partition.Partition;

import java.awt.Container;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JOptionPane;

import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;

import java.io.RandomAccessFile;

public class OpenPartitionDialog extends JDialog
{
  protected JComboBox driveCB;
  protected JComboBox fsCB;
  protected PartitionTablePanel partitionTable;
  protected JButton okBTN, cancelBTN;
  protected FsViewFrame fsViewFrame;

  /** This should probably be externalized in a properties or XML file or something */
  protected final static String[] LINUX_DEVICES = {"/dev/hda", "/dev/hdb", "/dev/hdc", "/dev/hdd"};
  protected final static String[] WINDOWS_DEVICES = {"\\\\.\\PhysicalDrive0", "\\\\.\\PhysicalDrive1", 
                                               "\\\\.\\PhysicalDrive2", "\\\\.\\PhysicalDrive3"};
 
  protected static Map deviceMap;
  protected static Map fsMap;

  static
  {
    deviceMap = new HashMap();
    deviceMap.put("Linux", LINUX_DEVICES);
    deviceMap.put("Windows NT", WINDOWS_DEVICES);
    deviceMap.put("Windows 2000", WINDOWS_DEVICES);
    deviceMap.put("Windows XP", WINDOWS_DEVICES);

    /* This should be loaded from a config file too */
    fsMap = new HashMap();
    fsMap.put("Ext2/3", "rossi.fstools.fs.ext2fs.Ext2FileSystem");
    fsMap.put("FAT 12/16/32", "rossi.fstools.fs.fatfs.FatFileSystem");
    fsMap.put("Reiser", "rossi.fstools.fs.reiserfs.ReiserFileSystem");
  }

  public OpenPartitionDialog(FsViewFrame parent)
  {
    super(parent, "Open disk partition");
    fsViewFrame = parent;
    initialize();
    performLayout();
  }

  protected void initialize()
  { 
    driveCB = new JComboBox( (String []) deviceMap.get(System.getProperty("os.name")) );
    driveCB.setEditable(true);
    driveCB.addActionListener(new ActionListener() 
      {
        public void actionPerformed(ActionEvent evt)
        {
          partitionTable.setDisk((String) driveCB.getSelectedItem());
        }
      });

    String fileSystems[] = (String[]) fsMap.keySet().toArray(new String[0]);
    Arrays.sort(fileSystems);
    fsCB = new JComboBox(fileSystems);

    partitionTable = new PartitionTablePanel();
    partitionTable.setDisk((String) driveCB.getSelectedItem());
    partitionTable.addActionListener(new ActionListener()
      {
        public void actionPerformed(ActionEvent evt)
        {
          openFileSystem();
        }
      });

    /* Setup the buttons */
    okBTN = new JButton("Ok");
    okBTN.addActionListener(new ActionListener()
      {
        public void actionPerformed(ActionEvent evt)
        {
          openFileSystem();
        }
      });


    cancelBTN = new JButton("Cancel");
    cancelBTN.addActionListener(new ActionListener()
      {
        public void actionPerformed(ActionEvent evt)
        {
          setVisible(false);
          dispose();
        }
      });
  }

  protected void openFileSystem()
  {
    Cursor cursor = getCursor();

    try
    {
      RandomAccessFile rafile;
      BlockIO blkio;
      Class fsClass = Class.forName((String)fsMap.get((String)fsCB.getSelectedItem()));
      FileSystem fs = (FileSystem) fsClass.newInstance();
      Partition part;
      int partid;
      long offset;

      setCursor(new Cursor(Cursor.WAIT_CURSOR));

      part = partitionTable.getSelectedPartition();
 
      offset = part.getStartLBA() * 512;  // LBA is in 512 byte sectors

      rafile = new RandomAccessFile((String) driveCB.getSelectedItem(), "r");
      blkio = new BlockIO(rafile, 4096, offset);

      fs.open(blkio);

      partid = partitionTable.getSelectedPartitionOrdinal();
      fsViewFrame.setTitle((String) driveCB.getSelectedItem() + " partition "+partid);
      fsViewFrame.setFileSystem(fs);

      setVisible(false);
      dispose();
    }
    catch (Exception ex)
    {
      JOptionPane.showMessageDialog(this, 
                 ex.getClass().getName()+": "+ex.getMessage(), "Error",
                 JOptionPane.ERROR_MESSAGE);
      ex.printStackTrace();
    }
    finally
    {
      setCursor(cursor);
    }
  }

  protected void performLayout()
  {
    JPanel mainPnl = new JPanel();
    JPanel buttonPnl = new JPanel();
    GridBagLayout gridb = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    Component comp;

    buttonPnl.setLayout(new FlowLayout());
    buttonPnl.add(okBTN);
    buttonPnl.add(cancelBTN);

    mainPnl.setLayout(gridb);

    c.gridx = 0; c.gridy = 0;
    c.gridwidth = 1; c.gridheight = 1;
    c.fill = GridBagConstraints.HORIZONTAL;
    c.insets = new Insets(2,2,2,2);
    c.weightx = 0.0; c.weighty = 0.0;

    comp = new JLabel("Drive:");
    gridb.setConstraints(comp, c);
    mainPnl.add(comp);

    c.gridx = 1; c.gridy = 0;

    comp = driveCB;
    gridb.setConstraints(comp, c);
    mainPnl.add(comp);

    c.gridx = 0; c.gridy = 1;
    comp = new JLabel("File System:");
    gridb.setConstraints(comp, c);
    mainPnl.add(comp);

    c.gridx = 1; c.gridy = 1;
    comp = fsCB;
    gridb.setConstraints(comp, c);
    mainPnl.add(comp);

    c.gridx = 0; c.gridy = 2;
    c.gridwidth = 2; c.gridheight = 1;
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1.0; c.weighty = 1.0;
    
    comp = partitionTable;
    gridb.setConstraints(comp, c);
    mainPnl.add(comp);

    c.gridx = 0; c.gridy = 3;
    c.gridwidth = 2; c.gridheight = 1;
    c.fill = GridBagConstraints.HORIZONTAL;
    c.weightx = 0.0; c.weighty = 0.0;

    comp = buttonPnl;
    gridb.setConstraints(comp, c);
    mainPnl.add(comp);

    getContentPane().setLayout(new BorderLayout());
    getContentPane().add(mainPnl, "Center");
  }
 
}
