/*
* EAX Mode
* (C) 1999-2007 Jack Lloyd
*
* Distributed under the terms of the Botan license
*/

#ifndef BOTAN_EAX_H__
#define BOTAN_EAX_H__

#include <botan/key_filt.h>
#include <botan/block_cipher.h>
#include <botan/stream_cipher.h>
#include <botan/mac.h>

namespace Botan {

/*
* EAX Base Class
*/
class BOTAN_DLL EAX_Base : public Keyed_Filter
   {
   public:
      void set_key(const SymmetricKey&);
      void set_iv(const InitializationVector&);
      void set_header(const byte[], u32bit);
      std::string name() const;

      bool valid_keylength(u32bit) const;

      ~EAX_Base() { delete ctr; delete cmac; }
   protected:
      EAX_Base(BlockCipher*, u32bit);
      void start_msg();

      const u32bit BLOCK_SIZE, TAG_SIZE;
      std::string cipher_name;

      StreamCipher* ctr;
      MessageAuthenticationCode* cmac;

      SecureVector<byte> nonce_mac, header_mac;
      SecureVector<byte> ctr_buf;
   };

/*
* EAX Encryption
*/
class BOTAN_DLL EAX_Encryption : public EAX_Base
   {
   public:
      EAX_Encryption(BlockCipher* ciph, u32bit tag_size = 0) :
         EAX_Base(ciph, tag_size) {}

      EAX_Encryption(BlockCipher* ciph, const SymmetricKey& key,
                     const InitializationVector& iv,
                     u32bit tag_size) : EAX_Base(ciph, tag_size)
         {
         set_key(key);
         set_iv(iv);
         }
   private:
      void write(const byte[], u32bit);
      void end_msg();
   };

/*
* EAX Decryption
*/
class BOTAN_DLL EAX_Decryption : public EAX_Base
   {
   public:
      EAX_Decryption(BlockCipher* ciph, u32bit tag_size = 0);

      EAX_Decryption(BlockCipher* ciph, const SymmetricKey& key,
                     const InitializationVector& iv,
                     u32bit tag_size = 0);
   private:
      void write(const byte[], u32bit);
      void do_write(const byte[], u32bit);
      void end_msg();

      SecureVector<byte> queue;
      u32bit queue_start, queue_end;
   };

}

#endif
