#!/usr/bin/python

# IP Scout
#
# FILENAME : ip_scout.py
# CODER	: Simon Roses Femerling
# DATE	 : 22/2/2004
# ABSTRACT : IP Scout is a program that makes uses of the Web Audit library (WAL) to
#	        gather all the internals IP in a network via the webserver!
#	        This program will help you to enumerate host behind a load balancer!
#
# Usage :
#	       c:\ip_scout.py -x 127.0.0.1 -p 80
#	       Print all the links in the webgape
#
#	       c:\ip_scout.py -x 127.0.0.1 -p 80 -d /mydir
#	       Do the enumeration using /mydir (the / must be in front!).
#
# - Roses Labs Innovations (RL+I)
# Roses Labs
# http://www.roseslabs.com
#
# Copyright (c) 2003-2004 Roses Labs.
#
# You may not distribute, transmit, repost this software for commercial 
# purposes without Roses Labs written permission. 
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, publish,
# distribute the Software, and to permit persons to whom the Software 
# is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

import sys
import getopt
import re
import os

sys.path.append('../lib')

from wal import *	   # Import wal

#########################################################################
# Define
#########################################################################

IPSV = "0.1"

#########################################################################
# Variables
#########################################################################

ireq = http_new_request()
oreq = http_new_response()
config = None

#########################################################################
# Procedures
#########################################################################

# Procedure : def Usage(args)
# Params	: args
# Return	: Nothing
# Abstract  : Print a usage message.
def Usage(args):
	print "IP Scout (" + args[0] + ") Version "  + IPSV  
	print "Roses Labs (http://www.roseslabs.com)\n"
	print "Options:"
	print "-x : Set host"
	print "-p : Set port (Default 80)"
	print "-n : Number of tries. (Default 10)"
	print "-d : Set a directory. (Default IP Scout will try to find a dir)"
	print "[host] : Same as '-x host'; must be the last argument"
	print "\nExample"
	print args[0] + " -x 127.0.0.1 -p 80"
	print "or just: " + args[0] + " 127.0.0.1"
	print "Run IP Scout with the defaults values. (recommended)"
	sys.exit(2)
# EOF: def Usage	

# Procedure : def GetDir(d = {})
# Params	: d
# Return	: Nothing
# Abstract  : Print all the links found in the webpage!
#	         I'm lazy but we could write some more intelligence
#	         to this routine that it will take a dir and use it. Maybe next release...
def GetDir(d = {}):

	h = WalParser()             # Init Wal HTML parser
	h.feed(d['wal']['data'])    # Begin parsing HTML page
	print h.GetLinks()          # Print all links found!
	sys.exit(2)
	
# EOF: def GetDir

# Procedure : def GetIP(ireq, tries)
# Params	: ireq, tries
# Return	: Nothing
# Abstract  : Perform n HTTP request (tries) and search for Location HTTP response.
def GetIP(ireq,tries):

	for i in range(tries):
	    p = re.compile('(.*http:\/\/)(.*)(\/\w+)')
	    res = http_do_request(ireq, oreq)
	    if res == 1:                        # A network error happen, report it!
	        print oreq['wal']['error']
	        sys.exit(2)
	    if oreq['wal']['header_data'].has_key('Location'):
	        str = oreq['wal']['header_data']['Location']
	        r = p.match(str)
	        if r: # Match found!
	            print oreq['wal']['header_data']['Location']   
# EOF: def GetIP	

# Procedure : def Run(args)
# Params	: args
# Return	: Nothing
# Abstract  : Start the scout!
def Run(args):
	try:
		opts,n = getopt.getopt(sys.argv[1:],'x:p:n:d:')
	except getopt.GetoptError:
	    Usage(sys.argv)

	tries = 10
	dir = ""
	host = ""
	port = "80" # Use 80 as the default port

	# Get command line args
	if n: host=n[0] # Set host to the first non-optioned argument if any
	for o, v in opts:
	    if o == "-x":
	        host = v
	    if o == "-p":
	        port = v
	    if o == "-n":
	        tries = v
	    if o == "-d":
	        dir = v

	# Some check error
	if host == "" or port == "":
	    Usage(sys.argv)

	# Lets start :)
	
	http_init(ireq) # Wal HTTP init

	ireq['wal']['version'] = '1.1'      # Set to HTTP 1.0
	ireq['wal']['host'] = host          # Set host
	ireq['wal']['port'] = int(port)     # Set port, convert to int!
	ireq['wal']['save_headers'] = ''    # Save HTTP response headers
	
	res = http_do_request(ireq,oreq)    # Do HTTP request
	if res != 0:                        # Any error ? report it!
	    print oreq['wal']['error']
	    sys.exit(2)

	if dir == "":
	    GetDir(oreq)    

	# put our directory into URI.
	ireq['wal']['uri'] = dir
	
	GetIP(ireq,tries)
	
# EOF: def Run

#########################################################################
# Main Procedure
#########################################################################
if __name__ == '__main__':
	if (len(sys.argv) <= 1):
	    Usage(sys.argv)
	else:
	    Run(sys.argv)        

# SRF E0F
