#!/usr/bin/python

# Pykto - Python based web-vuln scanner, based on the Nikto vuln database
# (http://www.cirt.net/code/nikto.shtml)

# FILENAME : pykto.py
# CODER : Emil Filipov <tie@ankh.morp.org>
# DATE   : 29/10/2004
# ABSTRACT : Pykto is a web-vulnerability scanner, based on the WAL library and using
#            the Nikto vulnerability database (http://www.cirt.net/code/nikto.shtml). It
# 			 can also be installed on a web-server and used as a CGI script. 
#		
# Usage:
#	$./pykto.py localhost			CGI: 	pykto.py?host=localhost
#	$./pykto.py https://localhost		CGI:	pykto.py?https://localhost
#	$./pykto.py http://localhost:80/www/	CGI:	http://localhost:80/www/
#	
# Copyright (c) 2003-2004 Roses Labs.
#
# You may not distribute, transmit, repost this software for commercial
# purposes without Roses Labs written permission.
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, publish,
# distribute the Software, and to permit persons to whom the Software
# is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

"""USAGE: %s [http[s]://]hostname.com[:port_number][/base_directory]
	Example: %s morp.org:80 
		 %s https://morp.org """

import sys		# Import some libs
import cgi		#

sys.path.append('../lib')	# Include path to wal.py
from wal import *          	# Import wal

def vulnfound (warning,url):	# Routine including the actions to be taken
	global vulns		# upon positive vulnerability reply
	global full_host
	vulns.append ( (warning,url) )
	print '--URL: %s\nWARNING: %s ---' % (url,warning)

	
CGI = 0				# Set this to 1 if you want to run the script in CGI mode
db_path ='./db'			# Path to the vuln database , i.e. "./db" 			
delimiter =','			# Delimiter of the db fields, i.e. ","
enclose= '"'			# Enclose character for the fields, i.e.'"'
vulns = []			# List to be filled with the vulnerabilities being found, not currently used

if CGI:
	import cgitb; cgitb.enable()		# Redirect errors to browser
	print 'Content-Type:text/plain\n'	# Ready for browser output

			
#default settings

host = ''
port = 80
cgi_dir = '/cgi-bin/'
directory = ''

ireq = http_new_request()	# WAL initialization code
oreq = http_new_response()	#
http_init(ireq) 		# 

if CGI==1:			# Get the URL value from the 'host' variable in CGI
	form = cgi.FieldStorage()
	if form.has_key('host'):
    		host = form['host'].value.strip()
else:				# Get the URL from the command line otherwise
	if len (sys.argv) > 1:
		host = sys.argv[1].strip()
		
full_host = host + ''		# Copy the original URL for future reference

if host == '':
	print __doc__ % (3*(sys.argv[0],))
	sys.exit(3)

print 'Initiating scan against: ', full_host , '\n'	# Some info output

if host.find('http://') == 0:		# Parse http://
    host = host[7:]
elif host.find('https://') == 0:	# Parse https:// and set to SSL
    host = host[8:]
    ireq['wal']['ssl']=1
	
if len(host.split('/',1)) == 2:		# Get director from localhost.com/directory/
   (host,directory) = host.split('/',1)
   directory = '/' + directory.rstrip('/')

if len(host.split(':',1)) == 2:		# Get port from localhost.com:port
    (host,port) = host.split(':')




ireq['wal']['version'] = '1.1'      # Set to HTTP 1.1
ireq['Host'] = host		    # Set host
ireq['wal']['host'] = host
ireq['wal']['port'] = int(port)     # Set port, convert to int!

# Some more info output
print 'Hostname: ',host
print 'SSL: ',ireq['wal'].has_key('ssl') and ireq['wal']['ssl'] == 1
print 'Base directory: ',directory
print


http_do_request(ireq,oreq)
try:
	res = http_do_request(ireq,oreq)    # Do test HTTP request
	if res != 0:                        # Any error ? report it!
		print oreq['wal']['error']
		sys.exit(2)
except:
	print 'Failed probing ' + full_host
	sys.exit(2)

# Try opening the database
try:
	f = open (db_path + '/scan_database.db','r')
except:
	print "Could not open database at " , db_path + '/scan_database.db'
	sys.exit(3)

line = 'start'	# Pre file teading initialization stuff
numlines = 0	#

while not line == '':		# Mail loop
	line=f.readline()
	if line=='' or line[0] == '#' or line=='\n' or len (line) < 10: continue
	numlines += 1
	
        if numlines % 100 == 0:				# Info output on every 100 checks
          print 'Performed %d checks ' % (numlines)	# Maybe this shouldn't be hardcoded
	  sys.stdout.flush()				# Future complaints will show that :)
 
#	if numlines > 200: break		# Use only the first 200 rules from the database, debug purposes
	
	# Parse the line from the database to the rule[] list
	parse = line.split(delimiter)
	rule = []
	try:
		for el in parse:
			if len(el)>1 and el.strip()[0]==enclose: rule.append (el)
			else: rule[-1] += delimiter + el
	
		(server,uri,reply,method,warn) = rule[:5]
		if len(rule) > 5: data = rule[5]
		else: data =''
	except:
		print 'Unable to parse rule in database: ' , line
	
	# Modify request according to rules	
	uri= directory + uri.replace('@CGIDIRS',cgi_dir)	
	ireq['wal']['uri'] = uri.strip('"')
	ireq['wal']['method'] = method.strip('"')
	ireq['wal']['data'] = data
	
	# Do the actual request
	http_do_request(ireq,oreq)
        
	# Here is the expected output according to the database
        reply = reply.strip('"')       
	
        if reply.isdigit(): 	# if the expected output is all digists, assume that it is the status code
           if reply == oreq['wal']['code']:
               vulnfound ( warn ,full_host + uri.strip('"') )
        elif oreq['wal']['data'].find(reply)>-1:		# otherwise, check inside the body of the response for
		vulnfound ( warn ,full_host + uri.strip('"') )	# the expected pattern

