/*
  File autogenerated by gengetopt version 2.12.2
  generated with the following command:
  gengetopt --unamed-opts=HOST [PORT] --input gsasl.ggo --file-name gsasl_cmd 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "gsasl_cmd.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

struct realm_list
{
  char * realm_arg;
  struct realm_list * next;
};

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->client_given = 0 ;
  args_info->server_given = 0 ;
  args_info->client_mechanisms_given = 0 ;
  args_info->server_mechanisms_given = 0 ;
  args_info->connect_given = 0 ;
  args_info->application_data_given = 0 ;
  args_info->imap_given = 0 ;
  args_info->smtp_given = 0 ;
  args_info->mechanism_given = 0 ;
  args_info->no_client_first_given = 0 ;
  args_info->anonymous_token_given = 0 ;
  args_info->authentication_id_given = 0 ;
  args_info->authorization_id_given = 0 ;
  args_info->password_given = 0 ;
  args_info->realm_given = 0 ;
  args_info->maxbuf_given = 0 ;
  args_info->passcode_given = 0 ;
  args_info->service_given = 0 ;
  args_info->hostname_given = 0 ;
  args_info->service_name_given = 0 ;
  args_info->enable_cram_md5_validate_given = 0 ;
  args_info->disable_cleartext_validate_given = 0 ;
  args_info->quality_of_protection_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->quiet_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->client_flag = 1;
  args_info->server_flag = 0;
  args_info->client_mechanisms_flag = 0;
  args_info->server_mechanisms_flag = 0;
  args_info->connect_arg = NULL;
  args_info->application_data_flag = 1;
  args_info->imap_flag = 1;
  args_info->smtp_flag = 0;
  args_info->mechanism_arg = NULL;
  args_info->no_client_first_flag = 0;
  args_info->anonymous_token_arg = NULL;
  args_info->authentication_id_arg = NULL;
  args_info->authorization_id_arg = NULL;
  args_info->password_arg = NULL;
  args_info->realm_arg = NULL;
  args_info->passcode_arg = NULL;
  args_info->service_arg = NULL;
  args_info->hostname_arg = NULL;
  args_info->service_name_arg = NULL;
  args_info->enable_cram_md5_validate_flag = 0;
  args_info->disable_cleartext_validate_flag = 0;
  args_info->quality_of_protection_arg = NULL;
  args_info->verbose_flag = 0;
  args_info->quiet_flag = 0;
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
"  Authenticate user to a server using Simple Authentication and\n  Security Layer.  Currently IMAP and SMTP servers are supported.  This\n  is a command line interface for the GNU SASL library.\n"
  "\n"
  "Usage: %s [OPTIONS]... [HOST [PORT]]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("%s\n","  -h, --help                    Print help and exit");
  printf("%s\n","  -V, --version                 Print version and exit");
  printf("%s\n","\nCommands:");
  printf("%s\n","  -c, --client                  Act as client.  (default=on)");
  printf("%s\n","  -s, --server                  Act as server.  (default=off)");
  printf("%s\n","      --client-mechanisms       Write name of supported client mechanisms \n                                  separated by space to stdout.  (default=off)");
  printf("%s\n","      --server-mechanisms       Write name of supported server mechanisms \n                                  separated by space to stdout.  (default=off)");
  printf("%s\n","\nNetwork options:");
  printf("%s\n","      --connect=HOST[:PORT]     Connect to TCP server and negotiate on stream \n                                  instead of stdin/stdout. PORT is the protocol \n                                  service, or an integer denoting the port, and \n                                  defaults to 143 (imap) if not specified. Also \n                                  sets the --hostname default.");
  printf("%s\n","\nGeneric options:");
  printf("%s\n","  -d, --application-data        After authentication, read data from stdin and \n                                  run it through the mechanism's security layer \n                                  and print it base64 encoded to stdout. The \n                                  default is to terminate after authentication. \n                                   (default=on)");
  printf("%s\n","      --imap                    Use a IMAP-like logon procedure (client only). \n                                  Also sets the --service default to 'imap'.  \n                                  (default=on)");
  printf("%s\n","      --smtp                    Use a SMTP-like logon procedure (client only). \n                                  Also sets the --service default to 'smtp'.  \n                                  (default=off)");
  printf("%s\n","  -m, --mechanism=STRING        Mechanism to use.");
  printf("%s\n","      --no-client-first         Disallow client to send data first (client \n                                  only).  (default=off)");
  printf("%s\n","\nSASL mechanism options (they are prompted for when required):");
  printf("%s\n","  -n, --anonymous-token=STRING  Token for anonymous authentication, usually \n                                  mail address (ANONYMOUS only).");
  printf("%s\n","  -a, --authentication-id=STRING\n                                Identity of credential owner.");
  printf("%s\n","  -z, --authorization-id=STRING Identity to request service for.");
  printf("%s\n","  -p, --password=STRING         Password for authentication (insecure for \n                                  non-testing purposes).");
  printf("%s\n","  -r, --realm=STRING            Realm (may be given more than once iff server). \n                                  Defaults to hostname.");
  printf("%s\n","  -x, --maxbuf=NUMBER           Indicate maximum buffer size (DIGEST-MD5 only).");
  printf("%s\n","      --passcode=NUMBER         Passcode for authentication (SECURID only).");
  printf("%s\n","      --service=STRING          Set the requested service name (should be a \n                                  registered GSSAPI host based service name).");
  printf("%s\n","      --hostname=STRING         Set the name of the server with the requested \n                                  service.");
  printf("%s\n","      --service-name=STRING     Set the generic server name in case of a \n                                  replicated server (DIGEST-MD5 only).");
  printf("%s\n","      --enable-cram-md5-validate\n                                Validate CRAM-MD5 challenge and response \n                                  interactively.  (default=off)");
  printf("%s\n","      --disable-cleartext-validate\n                                Disable cleartext validate hook, forcing server \n                                  to prompt for password.  (default=off)");
  printf("%s\n","      --quality-of-protection=TYPE\n                                How application payload will be protected. \n                                  'auth' means no protection, 'auth-int' means \n                                  integrity protection, 'auth-conf' means \n                                  integrity and confidentialiy protection.  \n                                  Currently only used by DIGEST-MD5, where the \n                                  default is 'auth-conf'.");
  printf("%s\n","\nOther options:");
  printf("%s\n","      --verbose                 Produce verbose output.  (default=off)");
  printf("%s\n","      --quiet                   Don't produce any diagnostic output.  \n                                  (default=off)");
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  unsigned int i;
  if (args_info->connect_arg)
    {
      free (args_info->connect_arg); /* free previous argument */
      args_info->connect_arg = 0;
    }
  if (args_info->mechanism_arg)
    {
      free (args_info->mechanism_arg); /* free previous argument */
      args_info->mechanism_arg = 0;
    }
  if (args_info->anonymous_token_arg)
    {
      free (args_info->anonymous_token_arg); /* free previous argument */
      args_info->anonymous_token_arg = 0;
    }
  if (args_info->authentication_id_arg)
    {
      free (args_info->authentication_id_arg); /* free previous argument */
      args_info->authentication_id_arg = 0;
    }
  if (args_info->authorization_id_arg)
    {
      free (args_info->authorization_id_arg); /* free previous argument */
      args_info->authorization_id_arg = 0;
    }
  if (args_info->password_arg)
    {
      free (args_info->password_arg); /* free previous argument */
      args_info->password_arg = 0;
    }
  for (i = 0; i < args_info->realm_given; ++i)
    {
      if (args_info->realm_arg [i])
        {
          free (args_info->realm_arg [i]); /* free previous argument */
          args_info->realm_arg [i] = 0;
        }
    }
  if (args_info->realm_arg)
    {
      if (args_info->realm_arg [0])
        free (args_info->realm_arg [0]); /* free default string */
      free (args_info->realm_arg); /* free previous argument */
      args_info->realm_arg = 0;
    }
  if (args_info->passcode_arg)
    {
      free (args_info->passcode_arg); /* free previous argument */
      args_info->passcode_arg = 0;
    }
  if (args_info->service_arg)
    {
      free (args_info->service_arg); /* free previous argument */
      args_info->service_arg = 0;
    }
  if (args_info->hostname_arg)
    {
      free (args_info->hostname_arg); /* free previous argument */
      args_info->hostname_arg = 0;
    }
  if (args_info->service_name_arg)
    {
      free (args_info->service_name_arg); /* free previous argument */
      args_info->service_name_arg = 0;
    }
  if (args_info->quality_of_protection_arg)
    {
      free (args_info->quality_of_protection_arg); /* free previous argument */
      args_info->quality_of_protection_arg = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  char *tok, *ret;
  int len;

  if (!arg)
    return NULL;

  tok = strchr (arg, ',');

  if (tok)
    len = (tok - arg + 1);
  else
    len = strlen (arg) + 1;

  ret = (char *) malloc (len);
  strncpy (ret, arg, len-1);
  ret[len-1] = '\0';

  return ret;
}

static char *
get_multiple_arg_token_next(const char *arg)
{
  char *tok;

  if (!arg)
    return NULL;

  tok = strchr (arg, ',');

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */
  char *multi_token, *multi_next; /* for multiple options */

  int i;        /* Counter */

  struct realm_list * realm_list = NULL,* realm_new = NULL;
  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "client",	0, NULL, 'c' },
        { "server",	0, NULL, 's' },
        { "client-mechanisms",	0, NULL, 0 },
        { "server-mechanisms",	0, NULL, 0 },
        { "connect",	1, NULL, 0 },
        { "application-data",	0, NULL, 'd' },
        { "imap",	0, NULL, 0 },
        { "smtp",	0, NULL, 0 },
        { "mechanism",	1, NULL, 'm' },
        { "no-client-first",	0, NULL, 0 },
        { "anonymous-token",	1, NULL, 'n' },
        { "authentication-id",	1, NULL, 'a' },
        { "authorization-id",	1, NULL, 'z' },
        { "password",	1, NULL, 'p' },
        { "realm",	1, NULL, 'r' },
        { "maxbuf",	1, NULL, 'x' },
        { "passcode",	1, NULL, 0 },
        { "service",	1, NULL, 0 },
        { "hostname",	1, NULL, 0 },
        { "service-name",	1, NULL, 0 },
        { "enable-cram-md5-validate",	0, NULL, 0 },
        { "disable-cleartext-validate",	0, NULL, 0 },
        { "quality-of-protection",	1, NULL, 0 },
        { "verbose",	0, NULL, 0 },
        { "quiet",	0, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVcsdm:n:a:z:p:r:x:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'c':	/* Act as client..  */
          if (local_args_info.client_given)
            {
              fprintf (stderr, "%s: `--client' (`-c') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->client_given && ! override)
            continue;
          local_args_info.client_given = 1;
          args_info->client_given = 1;
          args_info->client_flag = !(args_info->client_flag);
          break;

        case 's':	/* Act as server..  */
          if (local_args_info.server_given)
            {
              fprintf (stderr, "%s: `--server' (`-s') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->server_given && ! override)
            continue;
          local_args_info.server_given = 1;
          args_info->server_given = 1;
          args_info->server_flag = !(args_info->server_flag);
          break;

        case 'd':	/* After authentication, read data from stdin and run it through the mechanism's security layer and print it base64 encoded to stdout. The default is to terminate after authentication..  */
          if (local_args_info.application_data_given)
            {
              fprintf (stderr, "%s: `--application-data' (`-d') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->application_data_given && ! override)
            continue;
          local_args_info.application_data_given = 1;
          args_info->application_data_given = 1;
          args_info->application_data_flag = !(args_info->application_data_flag);
          break;

        case 'm':	/* Mechanism to use..  */
          if (local_args_info.mechanism_given)
            {
              fprintf (stderr, "%s: `--mechanism' (`-m') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->mechanism_given && ! override)
            continue;
          local_args_info.mechanism_given = 1;
          args_info->mechanism_given = 1;
          if (args_info->mechanism_arg)
            free (args_info->mechanism_arg); /* free previous string */
          args_info->mechanism_arg = gengetopt_strdup (optarg);
          break;

        case 'n':	/* Token for anonymous authentication, usually mail address (ANONYMOUS only)..  */
          if (local_args_info.anonymous_token_given)
            {
              fprintf (stderr, "%s: `--anonymous-token' (`-n') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->anonymous_token_given && ! override)
            continue;
          local_args_info.anonymous_token_given = 1;
          args_info->anonymous_token_given = 1;
          if (args_info->anonymous_token_arg)
            free (args_info->anonymous_token_arg); /* free previous string */
          args_info->anonymous_token_arg = gengetopt_strdup (optarg);
          break;

        case 'a':	/* Identity of credential owner..  */
          if (local_args_info.authentication_id_given)
            {
              fprintf (stderr, "%s: `--authentication-id' (`-a') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->authentication_id_given && ! override)
            continue;
          local_args_info.authentication_id_given = 1;
          args_info->authentication_id_given = 1;
          if (args_info->authentication_id_arg)
            free (args_info->authentication_id_arg); /* free previous string */
          args_info->authentication_id_arg = gengetopt_strdup (optarg);
          break;

        case 'z':	/* Identity to request service for..  */
          if (local_args_info.authorization_id_given)
            {
              fprintf (stderr, "%s: `--authorization-id' (`-z') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->authorization_id_given && ! override)
            continue;
          local_args_info.authorization_id_given = 1;
          args_info->authorization_id_given = 1;
          if (args_info->authorization_id_arg)
            free (args_info->authorization_id_arg); /* free previous string */
          args_info->authorization_id_arg = gengetopt_strdup (optarg);
          break;

        case 'p':	/* Password for authentication (insecure for non-testing purposes)..  */
          if (local_args_info.password_given)
            {
              fprintf (stderr, "%s: `--password' (`-p') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->password_given && ! override)
            continue;
          local_args_info.password_given = 1;
          args_info->password_given = 1;
          if (args_info->password_arg)
            free (args_info->password_arg); /* free previous string */
          args_info->password_arg = gengetopt_strdup (optarg);
          break;

        case 'r':	/* Realm (may be given more than once iff server). Defaults to hostname..  */
          local_args_info.realm_given++;
          multi_token = get_multiple_arg_token(optarg);
          multi_next = get_multiple_arg_token_next (optarg);
          
          while (1)
            {
              realm_new = (struct realm_list *) malloc (sizeof (struct realm_list));
              realm_new->next = realm_list;
              realm_list = realm_new;
              realm_new->realm_arg = multi_token;
          
              if (multi_next)
                {
                  multi_token = get_multiple_arg_token(multi_next);
                  multi_next = get_multiple_arg_token_next (multi_next);
                  local_args_info.realm_given++;
                }
              else
                break;
            }
          break;

        case 'x':	/* Indicate maximum buffer size (DIGEST-MD5 only)..  */
          if (local_args_info.maxbuf_given)
            {
              fprintf (stderr, "%s: `--maxbuf' (`-x') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->maxbuf_given && ! override)
            continue;
          local_args_info.maxbuf_given = 1;
          args_info->maxbuf_given = 1;
          args_info->maxbuf_arg = strtol (optarg,&stop_char,0);
          break;


        case 0:	/* Long option with no short option */
          /* Write name of supported client mechanisms separated by space to stdout..  */
          if (strcmp (long_options[option_index].name, "client-mechanisms") == 0)
          {
            if (local_args_info.client_mechanisms_given)
              {
                fprintf (stderr, "%s: `--client-mechanisms' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->client_mechanisms_given && ! override)
              continue;
            local_args_info.client_mechanisms_given = 1;
            args_info->client_mechanisms_given = 1;
            args_info->client_mechanisms_flag = !(args_info->client_mechanisms_flag);
          }
          
          /* Write name of supported server mechanisms separated by space to stdout..  */
          else if (strcmp (long_options[option_index].name, "server-mechanisms") == 0)
          {
            if (local_args_info.server_mechanisms_given)
              {
                fprintf (stderr, "%s: `--server-mechanisms' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->server_mechanisms_given && ! override)
              continue;
            local_args_info.server_mechanisms_given = 1;
            args_info->server_mechanisms_given = 1;
            args_info->server_mechanisms_flag = !(args_info->server_mechanisms_flag);
          }
          
          /* Connect to TCP server and negotiate on stream instead of stdin/stdout. PORT is the protocol service, or an integer denoting the port, and defaults to 143 (imap) if not specified. Also sets the --hostname default..  */
          else if (strcmp (long_options[option_index].name, "connect") == 0)
          {
            if (local_args_info.connect_given)
              {
                fprintf (stderr, "%s: `--connect' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->connect_given && ! override)
              continue;
            local_args_info.connect_given = 1;
            args_info->connect_given = 1;
            if (args_info->connect_arg)
              free (args_info->connect_arg); /* free previous string */
            args_info->connect_arg = gengetopt_strdup (optarg);
          }
          
          /* Use a IMAP-like logon procedure (client only). Also sets the --service default to 'imap'..  */
          else if (strcmp (long_options[option_index].name, "imap") == 0)
          {
            if (local_args_info.imap_given)
              {
                fprintf (stderr, "%s: `--imap' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->imap_given && ! override)
              continue;
            local_args_info.imap_given = 1;
            args_info->imap_given = 1;
            args_info->imap_flag = !(args_info->imap_flag);
          }
          
          /* Use a SMTP-like logon procedure (client only). Also sets the --service default to 'smtp'..  */
          else if (strcmp (long_options[option_index].name, "smtp") == 0)
          {
            if (local_args_info.smtp_given)
              {
                fprintf (stderr, "%s: `--smtp' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->smtp_given && ! override)
              continue;
            local_args_info.smtp_given = 1;
            args_info->smtp_given = 1;
            args_info->smtp_flag = !(args_info->smtp_flag);
          }
          
          /* Disallow client to send data first (client only)..  */
          else if (strcmp (long_options[option_index].name, "no-client-first") == 0)
          {
            if (local_args_info.no_client_first_given)
              {
                fprintf (stderr, "%s: `--no-client-first' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->no_client_first_given && ! override)
              continue;
            local_args_info.no_client_first_given = 1;
            args_info->no_client_first_given = 1;
            args_info->no_client_first_flag = !(args_info->no_client_first_flag);
          }
          
          /* Passcode for authentication (SECURID only)..  */
          else if (strcmp (long_options[option_index].name, "passcode") == 0)
          {
            if (local_args_info.passcode_given)
              {
                fprintf (stderr, "%s: `--passcode' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->passcode_given && ! override)
              continue;
            local_args_info.passcode_given = 1;
            args_info->passcode_given = 1;
            if (args_info->passcode_arg)
              free (args_info->passcode_arg); /* free previous string */
            args_info->passcode_arg = gengetopt_strdup (optarg);
          }
          
          /* Set the requested service name (should be a registered GSSAPI host based service name)..  */
          else if (strcmp (long_options[option_index].name, "service") == 0)
          {
            if (local_args_info.service_given)
              {
                fprintf (stderr, "%s: `--service' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->service_given && ! override)
              continue;
            local_args_info.service_given = 1;
            args_info->service_given = 1;
            if (args_info->service_arg)
              free (args_info->service_arg); /* free previous string */
            args_info->service_arg = gengetopt_strdup (optarg);
          }
          
          /* Set the name of the server with the requested service..  */
          else if (strcmp (long_options[option_index].name, "hostname") == 0)
          {
            if (local_args_info.hostname_given)
              {
                fprintf (stderr, "%s: `--hostname' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->hostname_given && ! override)
              continue;
            local_args_info.hostname_given = 1;
            args_info->hostname_given = 1;
            if (args_info->hostname_arg)
              free (args_info->hostname_arg); /* free previous string */
            args_info->hostname_arg = gengetopt_strdup (optarg);
          }
          
          /* Set the generic server name in case of a replicated server (DIGEST-MD5 only)..  */
          else if (strcmp (long_options[option_index].name, "service-name") == 0)
          {
            if (local_args_info.service_name_given)
              {
                fprintf (stderr, "%s: `--service-name' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->service_name_given && ! override)
              continue;
            local_args_info.service_name_given = 1;
            args_info->service_name_given = 1;
            if (args_info->service_name_arg)
              free (args_info->service_name_arg); /* free previous string */
            args_info->service_name_arg = gengetopt_strdup (optarg);
          }
          
          /* Validate CRAM-MD5 challenge and response interactively..  */
          else if (strcmp (long_options[option_index].name, "enable-cram-md5-validate") == 0)
          {
            if (local_args_info.enable_cram_md5_validate_given)
              {
                fprintf (stderr, "%s: `--enable-cram-md5-validate' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->enable_cram_md5_validate_given && ! override)
              continue;
            local_args_info.enable_cram_md5_validate_given = 1;
            args_info->enable_cram_md5_validate_given = 1;
            args_info->enable_cram_md5_validate_flag = !(args_info->enable_cram_md5_validate_flag);
          }
          
          /* Disable cleartext validate hook, forcing server to prompt for password..  */
          else if (strcmp (long_options[option_index].name, "disable-cleartext-validate") == 0)
          {
            if (local_args_info.disable_cleartext_validate_given)
              {
                fprintf (stderr, "%s: `--disable-cleartext-validate' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->disable_cleartext_validate_given && ! override)
              continue;
            local_args_info.disable_cleartext_validate_given = 1;
            args_info->disable_cleartext_validate_given = 1;
            args_info->disable_cleartext_validate_flag = !(args_info->disable_cleartext_validate_flag);
          }
          
          /* How application payload will be protected. 'auth' means no protection, 'auth-int' means integrity protection, 'auth-conf' means integrity and confidentialiy protection.  Currently only used by DIGEST-MD5, where the default is 'auth-conf'..  */
          else if (strcmp (long_options[option_index].name, "quality-of-protection") == 0)
          {
            if (local_args_info.quality_of_protection_given)
              {
                fprintf (stderr, "%s: `--quality-of-protection' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->quality_of_protection_given && ! override)
              continue;
            local_args_info.quality_of_protection_given = 1;
            args_info->quality_of_protection_given = 1;
            if (args_info->quality_of_protection_arg)
              free (args_info->quality_of_protection_arg); /* free previous string */
            args_info->quality_of_protection_arg = gengetopt_strdup (optarg);
          }
          
          /* Produce verbose output..  */
          else if (strcmp (long_options[option_index].name, "verbose") == 0)
          {
            if (local_args_info.verbose_given)
              {
                fprintf (stderr, "%s: `--verbose' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->verbose_given && ! override)
              continue;
            local_args_info.verbose_given = 1;
            args_info->verbose_given = 1;
            args_info->verbose_flag = !(args_info->verbose_flag);
          }
          
          /* Don't produce any diagnostic output..  */
          else if (strcmp (long_options[option_index].name, "quiet") == 0)
          {
            if (local_args_info.quiet_given)
              {
                fprintf (stderr, "%s: `--quiet' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->quiet_given && ! override)
              continue;
            local_args_info.quiet_given = 1;
            args_info->quiet_given = 1;
            args_info->quiet_flag = !(args_info->quiet_flag);
          }
          

          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  if (local_args_info.realm_given && realm_list)
    {
      struct realm_list *tmp;
      args_info->realm_arg = (char * *) realloc (args_info->realm_arg, (args_info->realm_given + local_args_info.realm_given) * sizeof (char *));
      for (i = (local_args_info.realm_given - 1); i >= 0; --i)
        {
          tmp = realm_list;
          args_info->realm_arg [i + args_info->realm_given] = realm_list->realm_arg;
          realm_list = realm_list->next;
          free (tmp);
        }
    }
  

  args_info->realm_given += local_args_info.realm_given;
  
  if (check_required)
    {
    }

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;
    }

  return 0;

failure:
  return (EXIT_FAILURE);
}
