/*us    Laurent Constantin's network library (lcrzo)
 */
/*fr    Bibliotheque reseau de Laurent Constantin (lcrzo)
 */

#ifndef LCRZO_INCLUDED
#define LCRZO_INCLUDED 1

/*us defines created during library's compilation*/
/*fr defines crees lors de la compilation de la bibliotheque*/
#include "lcrzo_defs.h"

/*us standard types*/
/*fr types standard*/
#include "lcrzo_types.h"

/*---------------------------------------------------------------*/
/*US                     FONCTION FROM EACH MODULE               */
/*FR                     FONCTIONS DE CHAQUE MODULE              */
/*---------------------------------------------------------------*/
/*us fonctions creating and converting addresses*/
/*fr fonctions de creation et de conversion d'adresse*/
#include "lcrzo_address.h"
/*us fonctions dealing with devices*/
/*fr fonctions de gestion des devices*/
#include "lcrzo_device.h"
/*us fonctions dealing with data arrays*/
/*fr fonctions de gestion de tableaux de donnees*/
#include "lcrzo_data.h"
/*us fonctions dealing with strings and regulars expressions*/
/*fr fonctions traitant des chaines de caracteres*/
#include "lcrzo_string.h"
/*us fonctions allowing header creation*/
/*fr fonctions de creation d'entetes*/
#include "lcrzo_header.h"
/*us fonctions creating and decoding/analysing IP options*/
/*fr fonctions de creation d'options IP*/
#include "lcrzo_ipopt.h"
/*us fonctions creating and decoding/analysing TCP options*/
/*fr fonctions de creation d'options TCP*/
#include "lcrzo_tcpopt.h"
/*us fonctions creating and decoding/analysing packets*/
/*fr fonctions de creation et decomposition de paquets*/
#include "lcrzo_packet.h"
/*us fonctions dealing with files and files descriptors*/
/*fr fonctions traitant des fichiers et descripteurs de fichiers*/
#include "lcrzo_file.h"
/*us fonctions printing data and packets*/
/*fr fonctions ecrivant les donnees*/
#include "lcrzo_print.h"
/*us fonctions saving an restoring packets*/
/*fr fonctions de sauvegarde/restitution de paquets*/
#include "lcrzo_record.h"
/*us fonctions dealing with Inter Process Comminucation*/
/*fr fonctions permettant de transferer des donnees entre processus*/
#include "lcrzo_ipc.h"
/*us fonctions dealing with generic lists*/
/*fr fonctions traitant des listes generiques*/
#include "lcrzo_list.h"
/*us fonctions dealing with configuration of the computer*/
/*fr fonctions de gestion de la configuration*/
#include "lcrzo_conf.h"
/*us fonctions sending packets*/
/*fr fonctions d'envoi de paquets*/
#include "lcrzo_spoof.h"
/*us fonctions sniffing packets*/
/*fr fonctions de sniff de paquets*/
#include "lcrzo_sniff.h"
/*us fonctions dealing with real/virtual clients/servers*/
/*fr fonctions client/serveurs reels et virtuels*/
#include "lcrzo_cliser.h"
/*us fonctions measuring time, and waiting*/
/*fr fonctions permettant de mesurer le temps, et d'attendre*/
#include "lcrzo_time.h"
/*us fonctions dealing with global configuration and parameters*/
/*fr fonctions de parametres globaux*/
#include "lcrzo_global.h"
/*us error codes*/
/*fr codes d'erreur*/
#include "lcrzo_error.h"
/*us miscelanous fonctions*/
/*fr fonctions diverses*/
#include "lcrzo_misc.h"

#endif /*ifndef LCRZO_INCLUDED*/

