/*
		                  LCRZO
                             Network library
             Copyright(c) 1999,2000,2001, Laurent Constantin
                                  -----

  Main server    : http://www.laurentconstantin.com/
  Backup servers : http://go.to/laurentconstantin/
                   http://laurentconstantin.est-la.com/
  [my current email address is on the web servers]

                                  -----
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details (http://www.gnu.org).

------------------------------------------------------------------------
*/

/* -- Note about comments and variable names --
   In versions 1.00 up to 2.08, lcrzo was only written in French (my
   mother tongue). Since version 3.00, lcrzo is written in English, but
   most of comments and variable names are still in French.
   In future versions, I'll try to translate everything into English,
   but as you may guess, that's a quite big work...
   So, for the moment, here are some word translation, if you want to
   be able to understand what's going on in the functions :
     afficher - print     ;  ajouter - add         ;  copie - copy
     dernier - last       ;  donnee - data         ;  ecrire - write
     entete - header      ;  envoye - sent         ;  ferme - close
     fichier - file       ;  lire - read           ;  masque - mask 
     nboct - byte number  ;  ouvre, ouvrir - open  ;  paq, paquet - packet
     plage - range        ;  premier - first       ;  recu - received
     reseau - network     ;  retour - return       ;  taille - size
     tunnel - pipe

*/

#include "lcrzo.h"
#ifdef LCRZODEF_SYSTEM_Linux
 #include <stdio.h>
 #include <string.h>
 #include <errno.h>
 #include <netdb.h>
#elif defined LCRZODEF_SYSTEM_FreeBSD
 #include <stdio.h>
 #include <string.h>
 #include <errno.h>
 #include <netdb.h>
#elif defined LCRZODEF_SYSTEM_Solaris
 #include <stdio.h>
 #include <string.h>
 #include <errno.h>
 #include <netdb.h>
#else
 #error "Traiter le cas de LCRZODEF_SYSTEM"
#endif

/*-------------------------------------------------------------*/
int lcrzo_err_fprint(LCRZOFILE *pf, int err)
{ 

  /*parameters verification*/
  if (pf==NULL) return(LCRZO_ERR_PANULLPTR);

  /*affichage des erreurs particulieres*/
  if (err!=LCRZO_ERR_OK) fprintf(pf, "err %d : ", err);
  switch(err)
    {
    /*retours normaux*/
    case LCRZO_ERR_OK :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_OK_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_OK_ustxt);
      break;
    case LCRZO_ERR_OKFINISHLOOP :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_OKFINISHLOOP_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_OKFINISHLOOP_ustxt);
      break;
    case LCRZO_ERR_OKDATAEND :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_OKDATAEND_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_OKDATAEND_ustxt);
      break;
    case LCRZO_ERR_OKTEMPDATAEND :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_OKTEMPDATAEND_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_OKTEMPDATAEND_ustxt);
      break;
    case LCRZO_ERR_OKSEARCHNOTFOUND :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_OKSEARCHNOTFOUND_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_OKSEARCHNOTFOUND_ustxt);
      break;
    case LCRZO_ERR_OKNOTDECODED :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_OKNOTDECODED_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_OKNOTDECODED_ustxt);
      break;
    case LCRZO_ERR_OKUNRESOLVED :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_OKUNRESOLVED_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_OKUNRESOLVED_ustxt);
      break;
    case LCRZO_ERR_OKDATATRUNCATED :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_OKDATATRUNCATED_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_OKDATATRUNCATED_ustxt);
      break;
    case LCRZO_ERR_OKROUTELOCALDEV :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_OKROUTELOCALDEV_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_OKROUTELOCALDEV_ustxt);
      break;
    case LCRZO_ERR_OKROUTEHOSTUNREACH :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_OKROUTEHOSTUNREACH_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_OKROUTEHOSTUNREACH_ustxt);
      break;
    case LCRZO_ERR_OKROUTEGWUNREACH :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_OKROUTEGWUNREACH_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_OKROUTEGWUNREACH_ustxt);
      break;
    case LCRZO_ERR_OKROUTENOTFOUND :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_OKROUTENOTFOUND_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_OKROUTENOTFOUND_ustxt);
      break;

    /*erreurs internes*/
    case LCRZO_ERR_IEUNIMPLEMENTED :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_IEUNIMPLEMENTED_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_IEUNIMPLEMENTED_ustxt);
      break;
    case LCRZO_ERR_IEINTERNALERROR :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_IEINTERNALERROR_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_IEINTERNALERROR_ustxt);
      break;
    case LCRZO_ERR_IEBADENDIAN :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_IEBADENDIAN_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_IEBADENDIAN_ustxt);
      break;
    case LCRZO_ERR_IEBADSIZEOF :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_IEBADSIZEOF_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_IEBADSIZEOF_ustxt);
      break;
    case LCRZO_ERR_IEOKKO :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_IEOKKO_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_IEOKKO_ustxt);
      break;
    case LCRZO_ERR_IEIPCBADELEMSIZE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_IEIPCBADELEMSIZE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_IEIPCBADELEMSIZE_ustxt);
      break;
    case LCRZO_ERR_IETIMEHIGHER :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_IETIMEHIGHER_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_IETIMEHIGHER_ustxt);
      break;
    case LCRZO_ERR_IELISTFULL :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_IELISTFULL_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_IELISTFULL_ustxt);
      break;

    /*erreur des fonctions systeme*/
    case LCRZO_ERR_FUSOCKET :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUSOCKET_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUSOCKET_ustxt);
      break;
    case LCRZO_ERR_FUSENDTO :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUSENDTO_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUSENDTO_ustxt);
      break;
    case LCRZO_ERR_FUPCAPOPEN :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUPCAPOPEN_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUPCAPOPEN_ustxt);
      break;
    case LCRZO_ERR_FUCONNECT :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUCONNECT_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUCONNECT_ustxt);
      break;
    case LCRZO_ERR_FUREAD :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUREAD_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUREAD_ustxt);
      break;
    case LCRZO_ERR_FUWRITE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUWRITE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUWRITE_ustxt);
      break;
    case LCRZO_ERR_FUREGCOMP :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUREGCOMP_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUREGCOMP_ustxt);
      break;
    case LCRZO_ERR_FUCLOSE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUCLOSE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUCLOSE_ustxt);
      break;
    case LCRZO_ERR_FULISTEN :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FULISTEN_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FULISTEN_ustxt);
      break;
    case LCRZO_ERR_FUACCEPT :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUACCEPT_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUACCEPT_ustxt);
      break;
    case LCRZO_ERR_FUPCAPLOOKUPDEV :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUPCAPLOOKUPDEV_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUPCAPLOOKUPDEV_ustxt);
      break;
    case LCRZO_ERR_FUPCAPLOOKUPNET :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUPCAPLOOKUPNET_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUPCAPLOOKUPNET_ustxt);
      break;
    case LCRZO_ERR_FUPCAPCOMPILE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUPCAPCOMPILE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUPCAPCOMPILE_ustxt);
      break;
    case LCRZO_ERR_FUPCAPSETFILTER :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUPCAPSETFILTER_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUPCAPSETFILTER_ustxt);
      break;
    case LCRZO_ERR_FUFOPEN :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFOPEN_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFOPEN_ustxt);
      break;
    case LCRZO_ERR_FUFCLOSE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFCLOSE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFCLOSE_ustxt);
      break;
    case LCRZO_ERR_FUSYSCTL :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUSYSCTL_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUSYSCTL_ustxt);
      break;
    case LCRZO_ERR_FUMALLOC :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUMALLOC_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUMALLOC_ustxt);
      break;
    case LCRZO_ERR_FUTCGETATTR :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUTCGETATTR_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUTCGETATTR_ustxt);
      break;
    case LCRZO_ERR_FUTCSETATTR :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUTCSETATTR_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUTCSETATTR_ustxt);
      break;
    case LCRZO_ERR_FUFSEEK :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFSEEK_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFSEEK_ustxt);
      break;
    case LCRZO_ERR_FUIOCTL :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUIOCTL_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUIOCTL_ustxt);
      break;
    case LCRZO_ERR_FUGETHOSTNAME :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUGETHOSTNAME_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUGETHOSTNAME_ustxt);
      break;
   case LCRZO_ERR_FUKILL :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUKILL_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUKILL_ustxt);
      break;
    case LCRZO_ERR_FUWAITPID :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUWAITPID_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUWAITPID_ustxt);
      break;
    case LCRZO_ERR_FUPIPE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUPIPE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUPIPE_ustxt);
      break;
    case LCRZO_ERR_FUFORK :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFORK_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFORK_ustxt);
      break;
    case LCRZO_ERR_FUFCNTL :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFCNTL_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFCNTL_ustxt);
      break;
    case LCRZO_ERR_FUPUTMSG :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUPUTMSG_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUPUTMSG_ustxt);
      break;
    case LCRZO_ERR_FUGETMSG :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUGETMSG_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUGETMSG_ustxt);
      break;
    case LCRZO_ERR_FULIBNETOPENLINKINT :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETOPENLINKINT_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETOPENLINKINT_ustxt);
      break;
    case LCRZO_ERR_FULIBNETGETHWADDR :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETGETHWADDR_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETGETHWADDR_ustxt);
      break;
    case LCRZO_ERR_FULIBNETCLOSELINKINT :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETCLOSELINKINT_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETCLOSELINKINT_ustxt);
      break;
    case LCRZO_ERR_FULIBNETOPENRAWSOCK :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETOPENRAWSOCK_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETOPENRAWSOCK_ustxt);
      break;
    case LCRZO_ERR_FULIBNETWRITEIP :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETWRITEIP_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETWRITEIP_ustxt);
      break;
    case LCRZO_ERR_FULIBNETCLOSERAWSOCK :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETCLOSERAWSOCK_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETCLOSERAWSOCK_ustxt);
      break;
    case LCRZO_ERR_FULIBNETWRITELL :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETWRITELL_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FULIBNETWRITELL_ustxt);
      break;
    case LCRZO_ERR_FUSETSOCKOPT :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUSETSOCKOPT_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUSETSOCKOPT_ustxt);
      break;
    case LCRZO_ERR_FUBIND :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUBIND_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUBIND_ustxt);
      break;
    case LCRZO_ERR_FUGETSOCKNAME :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUGETSOCKNAME_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUGETSOCKNAME_ustxt);
      break;
    case LCRZO_ERR_FUGETPEERNAME :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUGETPEERNAME_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUGETPEERNAME_ustxt);
      break;
    case LCRZO_ERR_FURECVFROM :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FURECVFROM_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FURECVFROM_ustxt);
      break;
    case LCRZO_ERR_FUGETTIMEOFDAY :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUGETTIMEOFDAY_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUGETTIMEOFDAY_ustxt);
      break;
    case LCRZO_ERR_FUOPEN :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUOPEN_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUOPEN_ustxt);
      break;
    case LCRZO_ERR_FULSTAT :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FULSTAT_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FULSTAT_ustxt);
      break;
    case LCRZO_ERR_FUFSTAT :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFSTAT_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFSTAT_ustxt);
      break;
    case LCRZO_ERR_FUSTAT :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUSTAT_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUSTAT_ustxt);
      break;
    case LCRZO_ERR_FUFTRUNCATE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFTRUNCATE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFTRUNCATE_ustxt);
      break;
    case LCRZO_ERR_FUSETEUID :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUSETEUID_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUSETEUID_ustxt);
      break;
    case LCRZO_ERR_FUSETEGID :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUSETEGID_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUSETEGID_ustxt);
      break;
    case LCRZO_ERR_FUFDOPEN :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFDOPEN_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFDOPEN_ustxt);
      break;
    case LCRZO_ERR_FUREALLOC :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUREALLOC_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUREALLOC_ustxt);
      break;
    case LCRZO_ERR_FUPOPEN :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUPOPEN_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUPOPEN_ustxt);
      break;
    case LCRZO_ERR_FUPCLOSE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUPCLOSE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUPCLOSE_ustxt);
      break;
    case LCRZO_ERR_FUUNLINK :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUUNLINK_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUUNLINK_ustxt);
      break;
    case LCRZO_ERR_FUFFLUSH :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFFLUSH_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFFLUSH_ustxt);
      break;
    case LCRZO_ERR_FULSEEK :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FULSEEK_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FULSEEK_ustxt);
      break;
    case LCRZO_ERR_FUFSYNC :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFSYNC_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFSYNC_ustxt);
      break;
    case LCRZO_ERR_FUFGETS :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFGETS_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFGETS_ustxt);
      break;
    case LCRZO_ERR_FUFCHMOD :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFCHMOD_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFCHMOD_ustxt);
      break;
    case LCRZO_ERR_FUFCHOWN :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUFCHOWN_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUFCHOWN_ustxt);
      break;
    case LCRZO_ERR_FUMKDIR :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUMKDIR_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUMKDIR_ustxt);
      break;
    case LCRZO_ERR_FURENAME :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FURENAME_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FURENAME_ustxt);
      break;
    case LCRZO_ERR_FURMDIR :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FURMDIR_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FURMDIR_ustxt);
      break;
    case LCRZO_ERR_FUOPENDIR :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FUOPENDIR_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FUOPENDIR_ustxt);
      break;


    /*erreur de formatage*/
    case LCRZO_ERR_FMETH :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FMETH_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FMETH_ustxt);
      break;
    case LCRZO_ERR_FMIP :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FMIP_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FMIP_ustxt);
      break;
    case LCRZO_ERR_FMETHRANGE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FMETHRANGE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FMETHRANGE_ustxt);
      break;
    case LCRZO_ERR_FMIPRANGE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FMIPRANGE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FMIPRANGE_ustxt);
      break;
    case LCRZO_ERR_FMPORTRANGE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FMPORTRANGE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FMPORTRANGE_ustxt);
      break;
    case LCRZO_ERR_FMINTFMT :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FMINTFMT_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FMINTFMT_ustxt);
      break;
    case LCRZO_ERR_FMREGEXP :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FMREGEXP_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FMREGEXP_ustxt);
      break;
    case LCRZO_ERR_FMMIXED :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FMMIXED_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FMMIXED_ustxt);
      break;
    case LCRZO_ERR_FMHEXACHAR :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FMHEXACHAR_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FMHEXACHAR_ustxt);
      break;
    case LCRZO_ERR_FMHEXAODD :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FMHEXAODD_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FMHEXAODD_ustxt);
      break;
    case LCRZO_ERR_FMBASE64CHAR :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FMBASE64CHAR_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FMBASE64CHAR_ustxt);
      break;
    case LCRZO_ERR_FMBASE64X4 :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_FMBASE64X4_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_FMBASE64X4_ustxt);
      break;


    /*erreurs de position*/
    case LCRZO_ERR_POTOOLOW :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_POTOOLOW_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_POTOOLOW_ustxt);
      break;
    case LCRZO_ERR_POTOOBIG :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_POTOOBIG_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_POTOOBIG_ustxt);
      break;
    case LCRZO_ERR_PONOZERO :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PONOZERO_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PONOZERO_ustxt);
      break;
    case LCRZO_ERR_POINFTOOLOW :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_POINFTOOLOW_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_POINFTOOLOW_ustxt);
      break;
   case LCRZO_ERR_POINFTOOBIG :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_POINFTOOBIG_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_POINFTOOBIG_ustxt);
      break;
    case LCRZO_ERR_POSUPTOOLOW :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_POSUPTOOLOW_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_POSUPTOOLOW_ustxt);
      break;
    case LCRZO_ERR_POSUPTOOBIG :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_POSUPTOOBIG_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_POSUPTOOBIG_ustxt);
      break;
    case LCRZO_ERR_POINFHIGHERSUP :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_POINFHIGHERSUP_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_POINFHIGHERSUP_ustxt);
      break;

    /*erreurs de parametres*/
    case LCRZO_ERR_PATOOLOW :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PATOOLOW_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PATOOLOW_ustxt);
      break;
    case LCRZO_ERR_PATOOBIG :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PATOOBIG_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PATOOBIG_ustxt);
      break;
    case LCRZO_ERR_PAINFTOOLOW :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PAINFTOOLOW_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PAINFTOOLOW_ustxt);
      break;
    case LCRZO_ERR_PAINFTOOBIG :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PAINFTOOBIG_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PAINFTOOBIG_ustxt);
      break;
    case LCRZO_ERR_PASUPTOOLOW :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PASUPTOOLOW_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PASUPTOOLOW_ustxt);
      break;
    case LCRZO_ERR_PASUPTOOBIG :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PASUPTOOBIG_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PASUPTOOBIG_ustxt);
      break;
    case LCRZO_ERR_PAINFHIGHERSUP :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PAINFHIGHERSUP_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PAINFHIGHERSUP_ustxt);
      break;
    case LCRZO_ERR_PAOVERFLOW :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PAOVERFLOW_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PAOVERFLOW_ustxt);
      break;
    case LCRZO_ERR_PADEFAULTNOTINRANGE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PADEFAULTNOTINRANGE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PADEFAULTNOTINRANGE_ustxt);
      break;
    case LCRZO_ERR_PANULLPTR :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PANULLPTR_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PANULLPTR_ustxt);
      break;
    case LCRZO_ERR_PABOOLNOT01 :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PABOOLNOT01_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PABOOLNOT01_ustxt);
      break;
    case LCRZO_ERR_PADATACURSUPMAX :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_PADATACURSUPMAX_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_PADATACURSUPMAX_ustxt);
      break;

    /*erreurs de parametres specifiques a lcrzo*/
    case LCRZO_ERR_SPOPTNOTX4 :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_SPOPTNOTX4_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_SPOPTNOTX4_ustxt);
      break;
    case LCRZO_ERR_SPOPTMAX10 :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_SPOPTMAX10_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_SPOPTMAX10_ustxt);
      break;
    case LCRZO_ERR_SPTOOBIGFORHDRL :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_SPTOOBIGFORHDRL_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_SPTOOBIGFORHDRL_ustxt);
      break;
    case LCRZO_ERR_SPBOTHPTR :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_SPBOTHPTR_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_SPBOTHPTR_ustxt);
      break;
    case LCRZO_ERR_SPNULLPTR :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_SPNULLPTR_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_SPNULLPTR_ustxt);
      break;
    case LCRZO_ERR_SPFILESECURITY :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_SPFILESECURITY_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_SPFILESECURITY_ustxt);
      break;
    case LCRZO_ERR_SPUNKNOWNTYPE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_SPUNKNOWNTYPE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_SPUNKNOWNTYPE_ustxt);
      break;
    case LCRZO_ERR_SPNULLPTRSIZE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_SPNULLPTRSIZE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_SPNULLPTRSIZE_ustxt);
      break;
    case LCRZO_ERR_SPUNKNOWNDEVICE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_SPUNKNOWNDEVICE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_SPUNKNOWNDEVICE_ustxt);
      break;

    /*erreurs d'emploi de la bibliotheque*/
    case LCRZO_ERR_BUIPCUNWANTEDTYPE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_BUIPCUNWANTEDTYPE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_BUIPCUNWANTEDTYPE_ustxt);
      break;
    case LCRZO_ERR_BUWORKONBADFILETYPE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_BUWORKONBADFILETYPE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_BUWORKONBADFILETYPE_ustxt);
      break;
    case LCRZO_ERR_BUUDPSERMULTINOWRITE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_BUUDPSERMULTINOWRITE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_BUUDPSERMULTINOWRITE_ustxt);
      break;
    case LCRZO_ERR_BUUDPSERREADBEFWRITE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_BUUDPSERREADBEFWRITE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_BUUDPSERREADBEFWRITE_ustxt);
      break;
    case LCRZO_ERR_BULCRZOEXBADUSAGE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_BULCRZOEXBADUSAGE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_BULCRZOEXBADUSAGE_ustxt);
      break;
    case LCRZO_ERR_BURECORDPRINTTYPE :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
	fprintf(pf, "%s\n", LCRZO_ERR_BURECORDPRINTTYPE_frtxt);
      else                         
	fprintf(pf, "%s\n", LCRZO_ERR_BURECORDPRINTTYPE_ustxt);
      break;

    /*erreur inconnue*/
    default :
      if (lcrzo_global.language==LCRZO_GLOBAL_FRLANG)
        fprintf(pf, "Code d'erreur inconnu.\n");
      else
	fprintf(pf, "Unknown error code.\n");
      break;
    }

  if (strlen(lcrzo_global.errmsglcrzo))
  { fprintf(pf, " `--> %s\n", lcrzo_global.errmsglcrzo);
    lcrzo_global.errmsglcrzo[0]='\0';
  }
  if (strlen(lcrzo_global.errmsgsys))
  { fprintf(pf, " `--> %s\n", lcrzo_global.errmsgsys);
    lcrzo_global.errmsgsys[0]='\0';
  }
  if(errno)
  { fprintf(pf, " `--> errno %d : %s\n", errno, strerror(errno));
    errno=0;
  }
  if(h_errno) 
  {
#if LCRZODEF_HAVEFONC_ETHER_HSTRERROR==1
    fprintf(pf, " `--> h_errno %d : %s\n", h_errno, hstrerror(h_errno));
#else
    fprintf(pf, " `--> h_errno %d\n", h_errno);
#endif
    h_errno=0;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_err_purge(void)
{
  lcrzo_global.errmsglcrzo[0]='\0';
  lcrzo_global.errmsgsys[0]='\0';
  errno=0;
  h_errno=0;
  
  return(LCRZO_ERR_OK);
}


