/*us    Laurent Constantin's network library (lcrzo)
                 lcrzo_error module

  Functions herein allow to deal with errors.
*/
/*fr   Bibliotheque reseau de Laurent Constantin (lcrzo)
                 Module lcrzo_error

  Les fonctions presentes dans ce module gerent les codes d'erreur
retournes par les fonctions.
*/

/*us normal returns */
/*fr retours normaux */
#define LCRZO_ERR_OK 0
#define LCRZO_ERR_OK_ustxt "ok"
#define LCRZO_ERR_OK_frtxt "ok"
#define LCRZO_ERR_OKFINISHLOOP 1
#define LCRZO_ERR_OKFINISHLOOP_ustxt "want to finish the loop"
#define LCRZO_ERR_OKFINISHLOOP_frtxt "fin de la boucle demandee"
#define LCRZO_ERR_OKDATAEND 2
#define LCRZO_ERR_OKDATAEND_ustxt "end of data"
#define LCRZO_ERR_OKDATAEND_frtxt "fin des donnees"
#define LCRZO_ERR_OKTEMPDATAEND 3
#define LCRZO_ERR_OKTEMPDATAEND_ustxt "no more data for the moment"
#define LCRZO_ERR_OKTEMPDATAEND_frtxt "pour le moment, il n'y a pas de donnees a lire"
#define LCRZO_ERR_OKSEARCHNOTFOUND 4
#define LCRZO_ERR_OKSEARCHNOTFOUND_ustxt "the seached element wasn't found"
#define LCRZO_ERR_OKSEARCHNOTFOUND_frtxt "la recherche a echouee"
#define LCRZO_ERR_OKNOTDECODED 5
#define LCRZO_ERR_OKNOTDECODED_ustxt "the packet cannot be decoded"
#define LCRZO_ERR_OKNOTDECODED_frtxt "le paquet ne peut pas etre decode"
#define LCRZO_ERR_OKUNRESOLVED 6
#define LCRZO_ERR_OKUNRESOLVED_ustxt "unresolved address"
#define LCRZO_ERR_OKUNRESOLVED_frtxt "l'adresse n'a pas pu etre resolue"
#define LCRZO_ERR_OKDATATRUNCATED 7
#define LCRZO_ERR_OKDATATRUNCATED_ustxt "the data was truncated"
#define LCRZO_ERR_OKDATATRUNCATED_frtxt "les donnees ont ete tronquees"
#define LCRZO_ERR_OKROUTELOCALDEV 8
#define LCRZO_ERR_OKROUTELOCALDEV_ustxt "the destination is a local device"
#define LCRZO_ERR_OKROUTELOCALDEV_frtxt "la destination est un device local"
#define LCRZO_ERR_OKROUTEHOSTUNREACH 9
#define LCRZO_ERR_OKROUTEHOSTUNREACH_ustxt "destination is on LAN, but is unreachable"
#define LCRZO_ERR_OKROUTEHOSTUNREACH_frtxt "la destination est sur le LAN, mais n'est pas joignable"
#define LCRZO_ERR_OKROUTEGWUNREACH 10
#define LCRZO_ERR_OKROUTEGWUNREACH_ustxt "destination is through a router, but the router is unreachable"
#define LCRZO_ERR_OKROUTEGWUNREACH_frtxt "la destination est vers un routeur, mais il n'est pas joignable"
#define LCRZO_ERR_OKROUTENOTFOUND 11
#define LCRZO_ERR_OKROUTENOTFOUND_ustxt "no route found to destination"
#define LCRZO_ERR_OKROUTENOTFOUND_frtxt "pas de route trouvee pour la destination"

/*us internal errors */
/*fr erreurs internes */
#define LCRZO_ERR_IEUNIMPLEMENTED 100
#define LCRZO_ERR_IEUNIMPLEMENTED_ustxt "unimplemented function or parameter"
#define LCRZO_ERR_IEUNIMPLEMENTED_frtxt "fonction ou type d'appel non implemente"
#define LCRZO_ERR_IEINTERNALERROR 101
#define LCRZO_ERR_IEINTERNALERROR_ustxt "internal error : contact Laurent"
#define LCRZO_ERR_IEINTERNALERROR_frtxt "erreur interne : contacter Laurent"
#define LCRZO_ERR_IEBADENDIAN 102
#define LCRZO_ERR_IEBADENDIAN_ustxt "endianess error"
#define LCRZO_ERR_IEBADENDIAN_frtxt "erreur d'endianess"
#define LCRZO_ERR_IEBADSIZEOF 103
#define LCRZO_ERR_IEBADSIZEOF_ustxt "incorrect sizeof for lcrzo_... type"
#define LCRZO_ERR_IEBADSIZEOF_frtxt "le sizeof des types lcrzo_... est incorrect"
#define LCRZO_ERR_IEOKKO 104
#define LCRZO_ERR_IEOKKO_ustxt "LCRZO_ERR_OK is returned by the function, but this should not append"
#define LCRZO_ERR_IEOKKO_frtxt "la fonction a retourne LCRZO_ERR_OK, mais ce n'etait pas attendu"
#define LCRZO_ERR_IEIPCBADELEMSIZE 105
#define LCRZO_ERR_IEIPCBADELEMSIZE_ustxt "the size of the elem in the IPC is not coherent with its type"
#define LCRZO_ERR_IEIPCBADELEMSIZE_frtxt "la taille des donnees dans l'ipc est incoherente avec son type"
#define LCRZO_ERR_IETIMEHIGHER 106
#define LCRZO_ERR_IETIMEHIGHER_ustxt "to do a diff, the saved time must be lower than the actual time"
#define LCRZO_ERR_IETIMEHIGHER_frtxt "l'heure du lcrzo_time est superieure a l'heure courante pour la difference"
#define LCRZO_ERR_IELISTFULL 124
#define LCRZO_ERR_IELISTFULL_ustxt "the list cannot have more than 0x7FFFFFFF elements"
#define LCRZO_ERR_IELISTFULL_frtxt "la liste est pleine : maxi 0x7FFFFFF elements"

/*us system functions errors*/
/*fr erreurs de fonctions systeme */
#define LCRZO_ERR_FUSOCKET 200
#define LCRZO_ERR_FUSOCKET_ustxt "error in socket()"
#define LCRZO_ERR_FUSOCKET_frtxt "erreur lors de l'appel a socket()"
#define LCRZO_ERR_FUSENDTO 201
#define LCRZO_ERR_FUSENDTO_ustxt "error in sendto()"
#define LCRZO_ERR_FUSENDTO_frtxt "erreur lors de l'appel a sendto()"
#define LCRZO_ERR_FUPCAPOPEN 202
#define LCRZO_ERR_FUPCAPOPEN_ustxt "error in pcap_open_live()"
#define LCRZO_ERR_FUPCAPOPEN_frtxt "erreur lors de l'appel pcap_open_live()"
#define LCRZO_ERR_FUCONNECT 203
#define LCRZO_ERR_FUCONNECT_ustxt "error in connect()"
#define LCRZO_ERR_FUCONNECT_frtxt "erreur lors de l'appel a connect()"
#define LCRZO_ERR_FUREAD 204
#define LCRZO_ERR_FUREAD_ustxt "error in read()"
#define LCRZO_ERR_FUREAD_frtxt "erreur lors de l'appel a read()"
#define LCRZO_ERR_FUWRITE 205
#define LCRZO_ERR_FUWRITE_ustxt "error in write()"
#define LCRZO_ERR_FUWRITE_frtxt "erreur lors de l'appel a write()"
#define LCRZO_ERR_FUREGCOMP 206
#define LCRZO_ERR_FUREGCOMP_ustxt "error in regcomp()"
#define LCRZO_ERR_FUREGCOMP_frtxt "erreur lors de l'appel regcomp()"
#define LCRZO_ERR_FUCLOSE 207
#define LCRZO_ERR_FUCLOSE_ustxt "error in close()"
#define LCRZO_ERR_FUCLOSE_frtxt "erreur lors de l'appel a close()"
#define LCRZO_ERR_FULISTEN 208
#define LCRZO_ERR_FULISTEN_ustxt "error in listen()"
#define LCRZO_ERR_FULISTEN_frtxt "erreur lors de l'appel a listen()"
#define LCRZO_ERR_FUACCEPT 209
#define LCRZO_ERR_FUACCEPT_ustxt "error in accept()"
#define LCRZO_ERR_FUACCEPT_frtxt "erreur lors de l'appel a accept()"
#define LCRZO_ERR_FUPCAPLOOKUPDEV 210
#define LCRZO_ERR_FUPCAPLOOKUPDEV_ustxt "error in pcap_lookupdev()"
#define LCRZO_ERR_FUPCAPLOOKUPDEV_frtxt "erreur lors de l'appel pcap_lookupdev()"
#define LCRZO_ERR_FUPCAPLOOKUPNET 211
#define LCRZO_ERR_FUPCAPLOOKUPNET_ustxt "error in pcap_lookupnet()"
#define LCRZO_ERR_FUPCAPLOOKUPNET_frtxt "erreur lors de l'appel pcap_lookupnet()"
#define LCRZO_ERR_FUPCAPCOMPILE 212
#define LCRZO_ERR_FUPCAPCOMPILE_ustxt "error in pcap_compile()"
#define LCRZO_ERR_FUPCAPCOMPILE_frtxt "erreur lors de l'appel pcap_compile()"
#define LCRZO_ERR_FUPCAPSETFILTER 213
#define LCRZO_ERR_FUPCAPSETFILTER_ustxt "error in pcap_setfilter()"
#define LCRZO_ERR_FUPCAPSETFILTER_frtxt "erreur lors de l'appel pcap_setfilter()"
#define LCRZO_ERR_FUFOPEN 214
#define LCRZO_ERR_FUFOPEN_ustxt "error in fopen()"
#define LCRZO_ERR_FUFOPEN_frtxt "erreur lors de l'appel fopen()"
#define LCRZO_ERR_FUFCLOSE 215
#define LCRZO_ERR_FUFCLOSE_ustxt "error in fclose()"
#define LCRZO_ERR_FUFCLOSE_frtxt "erreur lors de l'appel fclose()"
#define LCRZO_ERR_FUSYSCTL 216
#define LCRZO_ERR_FUSYSCTL_ustxt "error in sysctl()"
#define LCRZO_ERR_FUSYSCTL_frtxt "erreur lors de l'appel sysctl()"
#define LCRZO_ERR_FUMALLOC 217
#define LCRZO_ERR_FUMALLOC_ustxt "error in malloc()"
#define LCRZO_ERR_FUMALLOC_frtxt "erreur lors de l'appel malloc()"
#define LCRZO_ERR_FUTCGETATTR 218
#define LCRZO_ERR_FUTCGETATTR_ustxt "error in tcgetattr()"
#define LCRZO_ERR_FUTCGETATTR_frtxt "erreur lors de l'appel tcgetattr()"
#define LCRZO_ERR_FUTCSETATTR 219
#define LCRZO_ERR_FUTCSETATTR_ustxt "error in tcsetattr()"
#define LCRZO_ERR_FUTCSETATTR_frtxt "erreur lors de l'appel tcsetattr()"
#define LCRZO_ERR_FUFSEEK 220
#define LCRZO_ERR_FUFSEEK_ustxt "error in fseek()"
#define LCRZO_ERR_FUFSEEK_frtxt "erreur lors de l'appel fseek()"
#define LCRZO_ERR_FUIOCTL 221
#define LCRZO_ERR_FUIOCTL_ustxt "error in ioctl()"
#define LCRZO_ERR_FUIOCTL_frtxt "erreur lors de l'appel ioctl()"
#define LCRZO_ERR_FUGETHOSTNAME 222
#define LCRZO_ERR_FUGETHOSTNAME_ustxt "error in gethostname()"
#define LCRZO_ERR_FUGETHOSTNAME_frtxt "erreur lors de l'appel gethostname()"
#define LCRZO_ERR_FUKILL 223
#define LCRZO_ERR_FUKILL_ustxt "error in kill()"
#define LCRZO_ERR_FUKILL_frtxt "erreur lors de l'appel kill()"
#define LCRZO_ERR_FUWAITPID 224
#define LCRZO_ERR_FUWAITPID_ustxt "error in waitpid()"
#define LCRZO_ERR_FUWAITPID_frtxt "erreur lors de l'appel waitpid()"
#define LCRZO_ERR_FUPIPE 225
#define LCRZO_ERR_FUPIPE_ustxt "error in pipe()"
#define LCRZO_ERR_FUPIPE_frtxt "erreur lors de l'appel pipe()"
#define LCRZO_ERR_FUFORK 226
#define LCRZO_ERR_FUFORK_ustxt "error in fork()"
#define LCRZO_ERR_FUFORK_frtxt "erreur lors de l'appel fork()"
#define LCRZO_ERR_FUFCNTL 227
#define LCRZO_ERR_FUFCNTL_ustxt "error in fcntl()"
#define LCRZO_ERR_FUFCNTL_frtxt "erreur lors de l'appel fcntl()"
#define LCRZO_ERR_FUPUTMSG 228
#define LCRZO_ERR_FUPUTMSG_ustxt "error in putmsg()"
#define LCRZO_ERR_FUPUTMSG_frtxt "erreur lors de l'appel putmsg()"
#define LCRZO_ERR_FUGETMSG 229
#define LCRZO_ERR_FUGETMSG_ustxt "error in getmsg()"
#define LCRZO_ERR_FUGETMSG_frtxt "erreur lors de l'appel getmsg()"
#define LCRZO_ERR_FULIBNETOPENLINKINT 230
#define LCRZO_ERR_FULIBNETOPENLINKINT_ustxt "error in libnet_open_link_interfac()"
#define LCRZO_ERR_FULIBNETOPENLINKINT_frtxt "erreur lors de l'appel libnet_open_link_interfac()"
#define LCRZO_ERR_FULIBNETGETHWADDR 231
#define LCRZO_ERR_FULIBNETGETHWADDR_ustxt "error in libnet_get_hwaddr()"
#define LCRZO_ERR_FULIBNETGETHWADDR_frtxt "erreur lors de l'appel libnet_get_hwaddr()"
#define LCRZO_ERR_FULIBNETCLOSELINKINT 232
#define LCRZO_ERR_FULIBNETCLOSELINKINT_ustxt "error in libnet_close_link_interface()"
#define LCRZO_ERR_FULIBNETCLOSELINKINT_frtxt "erreur lors de l'appel libnet_close_link_interface()"
#define LCRZO_ERR_FULIBNETOPENRAWSOCK 233
#define LCRZO_ERR_FULIBNETOPENRAWSOCK_ustxt "error in libnet_open_raw_sock()"
#define LCRZO_ERR_FULIBNETOPENRAWSOCK_frtxt "erreur lors de l'appel libnet_open_raw_sock()"
#define LCRZO_ERR_FULIBNETWRITEIP 234
#define LCRZO_ERR_FULIBNETWRITEIP_ustxt "error in libnet_write_ip()"
#define LCRZO_ERR_FULIBNETWRITEIP_frtxt "erreur lors de l'appel libnet_write_ip()"
#define LCRZO_ERR_FULIBNETCLOSERAWSOCK 235
#define LCRZO_ERR_FULIBNETCLOSERAWSOCK_ustxt "error in libnet_close_raw_sock()"
#define LCRZO_ERR_FULIBNETCLOSERAWSOCK_frtxt "erreur lors de l'appel libnet_close_raw_sock()"
#define LCRZO_ERR_FULIBNETWRITELL 236
#define LCRZO_ERR_FULIBNETWRITELL_ustxt "error in libnet_write_link_layer()"
#define LCRZO_ERR_FULIBNETWRITELL_frtxt "erreur lors de l'appel libnet_write_link_layer()"
#define LCRZO_ERR_FUSETSOCKOPT 237
#define LCRZO_ERR_FUSETSOCKOPT_ustxt "error in setsockopt()"
#define LCRZO_ERR_FUSETSOCKOPT_frtxt "erreur lors de l'appel setsockopt()"
#define LCRZO_ERR_FUBIND 238
#define LCRZO_ERR_FUBIND_ustxt "error in bind()"
#define LCRZO_ERR_FUBIND_frtxt "erreur lors de l'appel bind()"
#define LCRZO_ERR_FUGETSOCKNAME 239
#define LCRZO_ERR_FUGETSOCKNAME_ustxt "error in getsockname()"
#define LCRZO_ERR_FUGETSOCKNAME_frtxt "erreur lors de l'appel getsockname()"
#define LCRZO_ERR_FUGETPEERNAME 240
#define LCRZO_ERR_FUGETPEERNAME_ustxt "error in getpeername()"
#define LCRZO_ERR_FUGETPEERNAME_frtxt "erreur lors de l'appel getpeername()"
#define LCRZO_ERR_FURECVFROM 241
#define LCRZO_ERR_FURECVFROM_ustxt "error in recvfrom()"
#define LCRZO_ERR_FURECVFROM_frtxt "erreur lors de l'appel recvfrom()"
#define LCRZO_ERR_FUGETTIMEOFDAY 242
#define LCRZO_ERR_FUGETTIMEOFDAY_ustxt "error in gettimeofday()"
#define LCRZO_ERR_FUGETTIMEOFDAY_frtxt "erreur lors de l'appel gettimeofday()"
#define LCRZO_ERR_FUOPEN 243
#define LCRZO_ERR_FUOPEN_ustxt "error in open()"
#define LCRZO_ERR_FUOPEN_frtxt "erreur lors de l'appel open()"
#define LCRZO_ERR_FULSTAT 244
#define LCRZO_ERR_FULSTAT_ustxt "error in lstat()"
#define LCRZO_ERR_FULSTAT_frtxt "erreur lors de l'appel lstat()"
#define LCRZO_ERR_FUFSTAT 245
#define LCRZO_ERR_FUFSTAT_ustxt "error in fstat()"
#define LCRZO_ERR_FUFSTAT_frtxt "erreur lors de l'appel fstat()"
#define LCRZO_ERR_FUSTAT 246
#define LCRZO_ERR_FUSTAT_ustxt "error in stat()"
#define LCRZO_ERR_FUSTAT_frtxt "erreur lors de l'appel stat()"
#define LCRZO_ERR_FUFTRUNCATE 247
#define LCRZO_ERR_FUFTRUNCATE_ustxt "error in ftruncate()"
#define LCRZO_ERR_FUFTRUNCATE_frtxt "erreur lors de l'appel ftruncate()"
#define LCRZO_ERR_FUSETEUID 248
#define LCRZO_ERR_FUSETEUID_ustxt "error in seteuid()"
#define LCRZO_ERR_FUSETEUID_frtxt "erreur lors de l'appel seteuid()"
#define LCRZO_ERR_FUSETEGID 249
#define LCRZO_ERR_FUSETEGID_ustxt "error in setguid()"
#define LCRZO_ERR_FUSETEGID_frtxt "erreur lors de l'appel setguid()"
#define LCRZO_ERR_FUFDOPEN 250
#define LCRZO_ERR_FUFDOPEN_ustxt "error in open()"
#define LCRZO_ERR_FUFDOPEN_frtxt "erreur lors de l'appel open()"
#define LCRZO_ERR_FUREALLOC 251
#define LCRZO_ERR_FUREALLOC_ustxt "error in realloc()"
#define LCRZO_ERR_FUREALLOC_frtxt "erreur lors de l'appel realloc()"
#define LCRZO_ERR_FUPOPEN 252
#define LCRZO_ERR_FUPOPEN_ustxt "error in popen()"
#define LCRZO_ERR_FUPOPEN_frtxt "erreur lors de l'appel popen()"
#define LCRZO_ERR_FUPCLOSE 253
#define LCRZO_ERR_FUPCLOSE_ustxt "error in pclose()"
#define LCRZO_ERR_FUPCLOSE_frtxt "erreur lors de l'appel pclose()"
#define LCRZO_ERR_FUUNLINK 254
#define LCRZO_ERR_FUUNLINK_ustxt "error in unlink()"
#define LCRZO_ERR_FUUNLINK_frtxt "erreur lors de l'appel unlink()"
#define LCRZO_ERR_FUFFLUSH 255
#define LCRZO_ERR_FUFFLUSH_ustxt "error in fflush()"
#define LCRZO_ERR_FUFFLUSH_frtxt "erreur lors de l'appel fflush()"
#define LCRZO_ERR_FULSEEK 256
#define LCRZO_ERR_FULSEEK_ustxt "error in lseek()"
#define LCRZO_ERR_FULSEEK_frtxt "erreur lors de l'appel lseek()"
#define LCRZO_ERR_FUFSYNC 257
#define LCRZO_ERR_FUFSYNC_ustxt "error in fsync()"
#define LCRZO_ERR_FUFSYNC_frtxt "erreur lors de l'appel fsync()"
#define LCRZO_ERR_FUFGETS 258
#define LCRZO_ERR_FUFGETS_ustxt "error in fgets()"
#define LCRZO_ERR_FUFGETS_frtxt "erreur lors de l'appel fgets()"
#define LCRZO_ERR_FUFCHMOD 259
#define LCRZO_ERR_FUFCHMOD_ustxt "error in fchmod()"
#define LCRZO_ERR_FUFCHMOD_frtxt "erreur lors de l'appel fchmod()"
#define LCRZO_ERR_FUFCHOWN 260
#define LCRZO_ERR_FUFCHOWN_ustxt "error in fchown()"
#define LCRZO_ERR_FUFCHOWN_frtxt "erreur lors de l'appel fchown()"
#define LCRZO_ERR_FUMKDIR 261
#define LCRZO_ERR_FUMKDIR_ustxt "error in mkdir()"
#define LCRZO_ERR_FUMKDIR_frtxt "erreur lors de l'appel mkdir()"
#define LCRZO_ERR_FURENAME 262
#define LCRZO_ERR_FURENAME_ustxt "error in rename()"
#define LCRZO_ERR_FURENAME_frtxt "erreur lors de l'appel rename()"
#define LCRZO_ERR_FURMDIR 263
#define LCRZO_ERR_FURMDIR_ustxt "error in rmdir()"
#define LCRZO_ERR_FURMDIR_frtxt "erreur lors de l'appel rmdir()"
#define LCRZO_ERR_FUOPENDIR 264
#define LCRZO_ERR_FUOPENDIR_ustxt "error in opendir()"
#define LCRZO_ERR_FUOPENDIR_frtxt "erreur lors de l'appel opendir()"

/*us format error */
/*fr erreur de formatage */
#define LCRZO_ERR_FMETH 300
#define LCRZO_ERR_FMETH_ustxt "the ethernet address hasn't the format 01:23:45:67:89:ab"
#define LCRZO_ERR_FMETH_frtxt "l'adresse Ethernet n'a pas le format 01:23:45:67:89:ab"
#define LCRZO_ERR_FMIP 301
#define LCRZO_ERR_FMIP_ustxt "the IP address hasn't the format 1.2.3.4"
#define LCRZO_ERR_FMIP_frtxt "l'adresse IP n'a pas le format 1.2.3.4"
#define LCRZO_ERR_FMETHRANGE 302
#define LCRZO_ERR_FMETHRANGE_ustxt "the ethernet range hasn't the format 'a:b:c:d:e:f-1:2:3:4:5:6', 'a:b:c:d:e:f/56', etc."
#define LCRZO_ERR_FMETHRANGE_frtxt "la plage ethernet n'a pas le format 'a:b:c:d:e:f-1:2:3:4:5:6', 'a:b:c:d:e:f/56', etc."
#define LCRZO_ERR_FMIPRANGE 303
#define LCRZO_ERR_FMIPRANGE_ustxt "the IP range hasn't the format '1.2.3.4-5.6.7.8', '1.2.3.0/24', '1.2.3/24', '1.2.3.0%24', '1.2.3%24', '1.2.3.0/255.255.255.0', etc."
#define LCRZO_ERR_FMIPRANGE_frtxt "la plage ip n'a pas le format '1.2.3.4-5.6.7.8', '1.2.3.0/24', '1.2.3/24', '1.2.3.0%24', '1.2.3%24', '1.2.3.0/255.255.255.0', etc."
#define LCRZO_ERR_FMPORTRANGE 304
#define LCRZO_ERR_FMPORTRANGE_ustxt "the port's range hasn't the format '[portinf]-[portsup]'"
#define LCRZO_ERR_FMPORTRANGE_frtxt "la plage de ports n'a pas le format '[portinf]-[portsup]'"
#define LCRZO_ERR_FMINTFMT 305
#define LCRZO_ERR_FMINTFMT_ustxt "the format for the integer isn't '%[0+-.]{0,1}[0-9]{0,2}[l]{0,1}[douxX]'"
#define LCRZO_ERR_FMINTFMT_frtxt "le format d'entier n'est pas '%[0+-.]{0,1}[0-9]{0,2}[l]{0,1}[douxX]'"
#define LCRZO_ERR_FMREGEXP 306
#define LCRZO_ERR_FMREGEXP_ustxt "only $1-$9 or $$ are allowed in a replacement string for a regular expression"
#define LCRZO_ERR_FMREGEXP_frtxt "seuls $1-$9 ou $$ sont autorises dans une chaine de remplacement d'expression reguliere"
#define LCRZO_ERR_FMMIXED 307
#define LCRZO_ERR_FMMIXED_ustxt "the mixed string doesn't finish by '"
#define LCRZO_ERR_FMMIXED_frtxt "la chaine mixte ne se termine pas par '"
#define LCRZO_ERR_FMHEXACHAR 308
#define LCRZO_ERR_FMHEXACHAR_ustxt "an hexa string must not contain a character different from A-Fa-f0-9"
#define LCRZO_ERR_FMHEXACHAR_frtxt "caractere autre que A-Fa-f0-9 trouve dans une chaine hexa"
#define LCRZO_ERR_FMHEXAODD 309
#define LCRZO_ERR_FMHEXAODD_ustxt "the byte number in the hexa string is odd"
#define LCRZO_ERR_FMHEXAODD_frtxt "le nombre de quartets de la chaine hexa est impair"
#define LCRZO_ERR_FMBASE64CHAR 310
#define LCRZO_ERR_FMBASE64CHAR_ustxt "all characters in a base64 must be in A-Za-z0-9+/="
#define LCRZO_ERR_FMBASE64CHAR_frtxt "un caractere n'est pas en base64 (A-Za-z0-9+/=)"
#define LCRZO_ERR_FMBASE64X4 311
#define LCRZO_ERR_FMBASE64X4_ustxt "with base64, the byte number must be a multiple of 4"
#define LCRZO_ERR_FMBASE64X4_frtxt "en base64, le nb de caracteres doit etre multiple de 4"

/*us position errors*/
/*fr erreurs de position */
#define LCRZO_ERR_POTOOLOW 400
#define LCRZO_ERR_POTOOLOW_ustxt "the position is too low"
#define LCRZO_ERR_POTOOLOW_frtxt "la position est trop petite"
#define LCRZO_ERR_POTOOBIG 401
#define LCRZO_ERR_POTOOBIG_ustxt "the position is too big"
#define LCRZO_ERR_POTOOBIG_frtxt "la position est trop grande"
#define LCRZO_ERR_PONOZERO 402
#define LCRZO_ERR_PONOZERO_ustxt "the position 0 is invalid"
#define LCRZO_ERR_PONOZERO_frtxt "la position zero n'est pas valide"
#define LCRZO_ERR_POINFTOOLOW 403
#define LCRZO_ERR_POINFTOOLOW_ustxt "the inferior position is too low"
#define LCRZO_ERR_POINFTOOLOW_frtxt "la position inferieure est trop petite"
#define LCRZO_ERR_POINFTOOBIG 404
#define LCRZO_ERR_POINFTOOBIG_ustxt "the inferior position is too big"
#define LCRZO_ERR_POINFTOOBIG_frtxt "la position inferieure est trop grande"
#define LCRZO_ERR_POSUPTOOLOW 405
#define LCRZO_ERR_POSUPTOOLOW_ustxt "the superior position is too low"
#define LCRZO_ERR_POSUPTOOLOW_frtxt "la position superieure est trop petite"
#define LCRZO_ERR_POSUPTOOBIG 406
#define LCRZO_ERR_POSUPTOOBIG_ustxt "the superior position is too big"
#define LCRZO_ERR_POSUPTOOBIG_frtxt "la position superieure est trop grande"
#define LCRZO_ERR_POINFHIGHERSUP 407
#define LCRZO_ERR_POINFHIGHERSUP_ustxt "the inferior position is higher than the superior position"
#define LCRZO_ERR_POINFHIGHERSUP_frtxt "la position inferieure est plus grande que la position superieure"

/*us parameters errors */
/*fr erreurs de parametres */
#define LCRZO_ERR_PATOOLOW 500
#define LCRZO_ERR_PATOOLOW_ustxt "the parameter is too low"
#define LCRZO_ERR_PATOOLOW_frtxt "le parametre est trop petit"
#define LCRZO_ERR_PATOOBIG 501
#define LCRZO_ERR_PATOOBIG_ustxt "the parameter is too big"
#define LCRZO_ERR_PATOOBIG_frtxt "le parametre est trop grand"
#define LCRZO_ERR_PAINFTOOLOW 503
#define LCRZO_ERR_PAINFTOOLOW_ustxt "the inferior parameter is too low"
#define LCRZO_ERR_PAINFTOOLOW_frtxt "le parametre inferieur est trop petit"
#define LCRZO_ERR_PAINFTOOBIG 504
#define LCRZO_ERR_PAINFTOOBIG_ustxt "the inferior parameter is too big"
#define LCRZO_ERR_PAINFTOOBIG_frtxt "le parametre inferieur est trop grand"
#define LCRZO_ERR_PASUPTOOLOW 505
#define LCRZO_ERR_PASUPTOOLOW_ustxt "the superior parameter is too low"
#define LCRZO_ERR_PASUPTOOLOW_frtxt "le parametre superieur est trop petit"
#define LCRZO_ERR_PASUPTOOBIG 506
#define LCRZO_ERR_PASUPTOOBIG_ustxt "the superior parameter is too big"
#define LCRZO_ERR_PASUPTOOBIG_frtxt "le parametre superieur est trop grand"
#define LCRZO_ERR_PAINFHIGHERSUP 507
#define LCRZO_ERR_PAINFHIGHERSUP_ustxt "the inferior parameter is higher than the superior parameter"
#define LCRZO_ERR_PAINFHIGHERSUP_frtxt "le parametre inferieur est plus grand que le parametre superieur"
#define LCRZO_ERR_PAOVERFLOW 508
#define LCRZO_ERR_PAOVERFLOW_ustxt "an overflow was detected"
#define LCRZO_ERR_PAOVERFLOW_frtxt "une tentative d'overflow a ete detectee"
#define LCRZO_ERR_PADEFAULTNOTINRANGE 509
#define LCRZO_ERR_PADEFAULTNOTINRANGE_ustxt "the default value is not in the range"
#define LCRZO_ERR_PADEFAULTNOTINRANGE_frtxt "la valeur par defaut est hors intervalle"
#define LCRZO_ERR_PANULLPTR 510
#define LCRZO_ERR_PANULLPTR_ustxt "a NULL pointer is not allowed"
#define LCRZO_ERR_PANULLPTR_frtxt "le pointeur ne doit pas etre NULL"
#define LCRZO_ERR_PABOOLNOT01 511
#define LCRZO_ERR_PABOOLNOT01_ustxt "a boolean must be 0 or 1"
#define LCRZO_ERR_PABOOLNOT01_frtxt "un booleen ne peut valoir que 0 ou 1"
#define LCRZO_ERR_PADATACURSUPMAX 512
#define LCRZO_ERR_PADATACURSUPMAX_ustxt "the current data size is greater than the max size"
#define LCRZO_ERR_PADATACURSUPMAX_frtxt "la taille courante des donnees est superieure a sa taille maximale"

/*us specific parameters errors */
/*fr erreurs de parametres specifiques a lcrzo */
#define LCRZO_ERR_SPOPTNOTX4 600
#define LCRZO_ERR_SPOPTNOTX4_ustxt "the option size is not a multiple of 4"
#define LCRZO_ERR_SPOPTNOTX4_frtxt "la taille des options n'est pas un multiple de 4"
#define LCRZO_ERR_SPOPTMAX10 601
#define LCRZO_ERR_SPOPTMAX10_ustxt "you cannot have more than 10 lines of options"
#define LCRZO_ERR_SPOPTMAX10_frtxt "il ne peut y avoir plus de 10 lignes options"
#define LCRZO_ERR_SPTOOBIGFORHDRL 602
#define LCRZO_ERR_SPTOOBIGFORHDRL_ustxt "a parameter in the logical header is to big to go in the physical header"
#define LCRZO_ERR_SPTOOBIGFORHDRL_frtxt "un parametre de l'entete logique est trop grand pour entrer dans l'entete physique"
#define LCRZO_ERR_SPBOTHPTR 603
#define LCRZO_ERR_SPBOTHPTR_ustxt "both pointers of {array,sizeofarray} should be NULL or valids"
#define LCRZO_ERR_SPBOTHPTR_frtxt "les pointeurs du couple {tableau,tailletableau} doivent etre tous les deux NULLs ou valides"
#define LCRZO_ERR_SPNULLPTR 604
#define LCRZO_ERR_SPNULLPTR_ustxt "pointers of {array,sizeofarray} cannot be NULL"
#define LCRZO_ERR_SPNULLPTR_frtxt "les pointeurs du couple {tableau,tailletableau} ne doivent pas etre NULL"
#define LCRZO_ERR_SPFILESECURITY 605
#define LCRZO_ERR_SPFILESECURITY_ustxt "security exception on file openning"
#define LCRZO_ERR_SPFILESECURITY_frtxt "erreur lors de l'ouverture du fichier"
#define LCRZO_ERR_SPUNKNOWNTYPE 606
#define LCRZO_ERR_SPUNKNOWNTYPE_ustxt "specified type is unknown"
#define LCRZO_ERR_SPUNKNOWNTYPE_frtxt "le type specifie est inconnu"
#define LCRZO_ERR_SPNULLPTRSIZE 607
#define LCRZO_ERR_SPNULLPTRSIZE_ustxt "pointer of array is NULL, but array'size isn't zero"
#define LCRZO_ERR_SPNULLPTRSIZE_frtxt "le pointeur du tableau est NULL, mais la taille du tableau n'est pas zero"
#define LCRZO_ERR_SPUNKNOWNDEVICE 608
#define LCRZO_ERR_SPUNKNOWNDEVICE_ustxt "unknown device"
#define LCRZO_ERR_SPUNKNOWNDEVICE_frtxt "device inconnu"

/*us bad usage of lcrzo*/
/*fr erreurs d'emploi de la bibliotheque*/
#define LCRZO_ERR_BUIPCUNWANTEDTYPE 700
#define LCRZO_ERR_BUIPCUNWANTEDTYPE_ustxt "the data type received in the IPC is not the one we want"
#define LCRZO_ERR_BUIPCUNWANTEDTYPE_frtxt "le type de donnee recu dans l'ipc n'est pas celui attendu"
#define LCRZO_ERR_BUWORKONBADFILETYPE 701
#define LCRZO_ERR_BUWORKONBADFILETYPE_ustxt "work on a bad file type"
#define LCRZO_ERR_BUWORKONBADFILETYPE_frtxt "tentative de travail sur un fichier ayant un type d'ouverture incorrect"
#define LCRZO_ERR_BUUDPSERMULTINOWRITE 702
#define LCRZO_ERR_BUUDPSERMULTINOWRITE_ustxt "it is not possible to write with an udp multiclient server"
#define LCRZO_ERR_BUUDPSERMULTINOWRITE_frtxt "les serveurs UDP multiclients ne permettent pas d'ecrire"
#define LCRZO_ERR_BUUDPSERREADBEFWRITE 703
#define LCRZO_ERR_BUUDPSERREADBEFWRITE_ustxt "it is not possible to write before reading on a udp server"
#define LCRZO_ERR_BUUDPSERREADBEFWRITE_frtxt "sur un serveur UDP, il faut lire avant de pouvoir ecrire"
#define LCRZO_ERR_BULCRZOEXBADUSAGE 704
#define LCRZO_ERR_BULCRZOEXBADUSAGE_ustxt "bad usage of the example"
#define LCRZO_ERR_BULCRZOEXBADUSAGE_frtxt "mauvaise utilisation de l'exemple"
#define LCRZO_ERR_BURECORDPRINTTYPE 705
#define LCRZO_ERR_BURECORDPRINTTYPE_ustxt "the lcrzo_printtype cannot be read by a record"
#define LCRZO_ERR_BURECORDPRINTTYPE_frtxt "le lcrzo_printtype ne peut pas etre relu par un record"


/*---------------------------------------------------------------*/
/*us Name : lcrzo_err_fprint
   Description :
     Print the text associated with an error code.
   Input parameter(s) :
     *pf : FILE where the function prints
     error : the text associated to this error is printed
   Input/output parameter(s) :
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_err_fprint
   Description :
     Ecrit le texte associe a un code d'erreur.
   Parametre(s) d'entree :
     *pf : FILE ou la fonction doit ecrire
     error : numero de l'erreur dont on doit ecrire le texte
   Parametre(s) d'entree-sortie :
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_err_fprint(LCRZOFILE *pf,
		     int error);

/*us idem, but on stdout */
/*fr idem, mais sur stdout */
#define lcrzo_err_print(a) lcrzo_err_fprint(stdout, a)

/*us this function can be used to purge error strings if you
   want to ignore an error. You should not need to use it. */
/*fr cette fonction purge le texte d'erreur, si vous desirez
   ignorer une erreur. Vous ne devriez pas en avoir besoin. */
int lcrzo_err_purge(void);

/*---------------------------------------------------------------*/
/*US*********************************************************
 * Note about these defines :                               *
 * These defines allow to easily test for return codes.     *
 * For example, instead of writting :                       *
 *    ret=function(...);                                    *
 *    if (ret!=LCRZO_ERR_OK)                                *
 *    { lcrzo_err_print(retour);                            *
 *      return(ret);                                        *
 *    }                                                     *
 * You only need to write :                                 *
 *    lcrzo_evr(function(...));                             *
 *                                                          *
 * In these defines :                                       *
 *   z is the variable containing the return code           *
 *   i is the variable containing the wanted return code    *
 *   f is the variable containing functions which can be    *
 *     called on exit                                       *
 ************************************************************/
/*FR*********************************************************
 * Note sur les defines qui suivent :                       *
 * Ces defines permettent de tester aisement des codes de   *
 * retour.                                                  *
 * Par exemple, au lieu d'ecrire :                          *
 *    ret=function(...);                                    *
 *    if (ret!=LCRZO_ERR_OK)                                *
 *    { lcrzo_err_print(retour);                            *
 *      return(ret);                                        *
 *    }                                                     *
 * Il suffit d'ecrire :                                     *
 *    lcrzo_evr(function(...));                             *
 *                                                          *
 * Dans ces defines :                                       *
 *   z est la variable contenant le code de retour          *
 *   i est la variable contenant le code de retour voulu    *
 *   f est la variable contenant les fonctions pouvant etre *
 *     appelees lors de la sortie                           *
 ************************************************************/

/*---------------------------------------------------------------*/
/* if (z!=LCRZO_ERR_OK) return(z) */
#define lcrzo_er(z) {int lcrzo_coderr=z;if(lcrzo_coderr!=LCRZO_ERR_OK)return(lcrzo_coderr);}
/* if (z!=LCRZO_ERR_OK) { f; return(z) } */
#define lcrzo_efr(z,f) {int lcrzo_coderr=z;if(lcrzo_coderr!=LCRZO_ERR_OK){f;return(lcrzo_coderr);}}

/* if (z!=LCRZO_ERR_OK) lcrzo_err_print(z) */
#define lcrzo_ep(z) {int lcrzo_coderr=z;if(lcrzo_coderr!=LCRZO_ERR_OK)lcrzo_err_print(lcrzo_coderr);}

/* if (z!=LCRZO_ERR_OK) { lcrzo_err_print(z); return(z) } */
#define lcrzo_epr(z) {int lcrzo_coderr=z;if(lcrzo_coderr!=LCRZO_ERR_OK){lcrzo_err_print(lcrzo_coderr);return(lcrzo_coderr);}}
/* if (z!=LCRZO_ERR_OK) { lcrzo_err_print(z); f; return(z) } */
#define lcrzo_epfr(z,f) {int lcrzo_coderr=z;if(lcrzo_coderr!=LCRZO_ERR_OK){lcrzo_err_print(lcrzo_coderr);f;return(lcrzo_coderr);}}

/* lcrzo_err_print(z); if (z!=LCRZO_ERR_OK) return(z) */
#define lcrzo_evr(z) {int lcrzo_coderr=z;lcrzo_err_print(lcrzo_coderr);if(lcrzo_coderr!=LCRZO_ERR_OK)return(lcrzo_coderr);}
/* lcrzo_err_print(z); if (z!=LCRZO_ERR_OK) { f; return(z) } */
#define lcrzo_evfr(z,f) {int lcrzo_coderr=z;lcrzo_err_print(lcrzo_coderr);if(lcrzo_coderr!=LCRZO_ERR_OK){f;return(lcrzo_coderr);}}

/*---------------------------------------------------------------*/
/* if (z!=i) lcrzo_err_print(z) */
#define lcrzo_eip(z,i) {int lcrzo_coderr=z;if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK)lcrzo_err_print(LCRZO_ERR_IEOKKO);lcrzo_err_print(lcrzo_coderr);}}

/* if (z!=i) return(z) */
#define lcrzo_eir(z,i) {int lcrzo_coderr=z;if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK)return(LCRZO_ERR_IEOKKO);return(lcrzo_coderr);}}
/* if (z!=i) { f; return(z) } */
#define lcrzo_eifr(z,i,f) {int lcrzo_coderr=z;if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK)return(LCRZO_ERR_IEOKKO);f;return(lcrzo_coderr);}}

/* if (z!=i) { lcrzo_err_print(z); return(z) } */
#define lcrzo_eipr(z,i) {int lcrzo_coderr=z;if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK){lcrzo_err_print(LCRZO_ERR_IEOKKO);return(LCRZO_ERR_IEOKKO);}lcrzo_err_print(lcrzo_coderr);return(lcrzo_coderr);}}
/* if (z!=i) { lcrzo_err_print(z); f; return(z) } */
#define lcrzo_eipfr(z,i,f) {int lcrzo_coderr=z;if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK){lcrzo_err_print(LCRZO_ERR_IEOKKO);f;return(LCRZO_ERR_IEOKKO);}lcrzo_err_print(lcrzo_coderr);f;return(lcrzo_coderr);}}

/* lcrzo_err_print(z); if (z!=i) return(z) */
#define lcrzo_eivr(z,i) {int lcrzo_coderr=z;lcrzo_err_print(lcrzo_coderr);if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK)return(LCRZO_ERR_IEOKKO);return(lcrzo_coderr);}}
/* lcrzo_err_print(z); if (z!=i) { f; return(z) } */
#define lcrzo_eivfr(z,i,f) {int lcrzo_coderr=z;lcrzo_err_print(lcrzo_coderr);if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK){f;return(LCRZO_ERR_IEOKKO);}f;return(lcrzo_coderr);}}





