/*
		                  LCRZO
                             Network library
             Copyright(c) 1999,2000,2001, Laurent Constantin
                                  -----

  Main server    : http://www.laurentconstantin.com/
  Backup servers : http://go.to/laurentconstantin/
                   http://laurentconstantin.est-la.com/
  [my current email address is on the web servers]

                                  -----
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details (http://www.gnu.org).

------------------------------------------------------------------------
*/

/* -- Note about comments and variable names --
   In versions 1.00 up to 2.08, lcrzo was only written in French (my
   mother tongue). Since version 3.00, lcrzo is written in English, but
   most of comments and variable names are still in French.
   In future versions, I'll try to translate everything into English,
   but as you may guess, that's a quite big work...
   So, for the moment, here are some word translation, if you want to
   be able to understand what's going on in the functions :
     afficher - print     ;  ajouter - add         ;  copie - copy
     dernier - last       ;  donnee - data         ;  ecrire - write
     entete - header      ;  envoye - sent         ;  ferme - close
     fichier - file       ;  lire - read           ;  masque - mask 
     nboct - byte number  ;  ouvre, ouvrir - open  ;  paq, paquet - packet
     plage - range        ;  premier - first       ;  recu - received
     reseau - network     ;  retour - return       ;  taille - size
     tunnel - pipe

*/

#include "lcrzo_priv.h"
#ifdef LCRZODEF_SYSTEM_Linux
 #include <stdlib.h>
#elif defined LCRZODEF_SYSTEM_FreeBSD
 #include <stdlib.h>
#elif defined LCRZODEF_SYSTEM_Solaris
 #include <stdlib.h>
#else
 #error "Traiter le cas de LCRZODEF_SYSTEM"
#endif


lcrzo_globalvars lcrzo_global={
  /*    char errmsglcrzo[LCRZO_GLOERRMSG_MAXBYTES+1]; */
  "",
  /*    char errmsgsys[LCRZO_GLOERRMSG_MAXBYTES+1]; */
  "",
  /*    int language; */
  ((LCRZODEF_LANG==1)?LCRZO_GLOBAL_USLANG:LCRZO_GLOBAL_FRLANG),
  /*    lcrzo_uint8 sock_tcpser_backlog; */
  5,
  /*    lcrzo_uint32 time_sleep_threshold1; */
  1000,
  /*    lcrzo_uint32 time_sleep_threshold2; */
  100000,
  /*    lcrzo_uint32 time_sleep_threshold3; */
  10000000,
  /*    lcrzo_bool record_open_mustbeanexistentfile; */
  LCRZO_FALSE,
  /*    lcrzo_bool record_open_mustbeanewfile; */
  LCRZO_FALSE,
  /*    lcrzo_bool hdr_compfields; */
  LCRZO_TRUE,
  /*    lcrzo_bool hdr_compfield_ethtype; */
  LCRZO_TRUE,
  /*    lcrzo_bool hdr_compfield_iptotlen; */
  LCRZO_TRUE,
  /*    lcrzo_bool hdr_compfield_ipihl; */
  LCRZO_TRUE,
  /*    lcrzo_bool hdr_compfield_ipcheck; */
  LCRZO_TRUE,
  /*    lcrzo_bool hdr_compfield_ipprotocol; */
  LCRZO_TRUE,
  /*    lcrzo_bool hdr_compfield_udplen; */
  LCRZO_TRUE,
  /*    lcrzo_bool hdr_compfield_udpcheck; */
  LCRZO_TRUE,
  /*    lcrzo_bool hdr_compfield_tcpdoff; */
  LCRZO_TRUE,
  /*    lcrzo_bool hdr_compfield_tcpcheck; */
  LCRZO_TRUE,
  /*    lcrzo_bool hdr_compfield_icmpcheck; */
  LCRZO_TRUE,
  /*    lcrzo_uint8 intspoof_eth_type; */
  LCRZO_INTSPOOF_TYPE_COMP,
  /*    lcrzo_etha  intspoof_eth_address; */
  "12345",
  /*    lcrzo_uint8 intspoof_ip_type; */
  LCRZO_INTSPOOF_TYPE_COMP,
  /*    lcrzo_ipa   intspoof_ip_address; */
  "123",
  /*    lcrzo_uint8 resolver_timeout; */
  4,
  /*    lcrzo_uint16 sniff_ipreastimeout1; */
  30,
  /*    lcrzo_uint16 sniff_ipreastimeout2; */
  5,
  /*    lcrzo_uint16 sniff_tcpreortimeout1; */
  30,
  /*    lcrzo_uint16 sniff_tcpreortimeout2; */
  5,
  /*    lcrzo_uint16 spoof_fragoctosize; */
  8192,
  /*    lcrzo_bool spoof_printbeforesending; */
  LCRZO_FALSE,
  /*    lcrzo_printprofile spoof_printprofile; */
  {LCRZO_PRINTTYPE_ARRAY, LCRZO_PRINTTYPE_ARRAY, LCRZO_PRINTTYPE_ARRAY,
   LCRZO_PRINTTYPE_ARRAY, LCRZO_PRINTTYPE_ARRAY, LCRZO_PRINTTYPE_ARRAY,
   LCRZO_PRINTTYPE_ARRAY,
   LCRZO_PRINTTYPE_DUMP, LCRZO_PRINTTYPE_DUMP, LCRZO_PRINTTYPE_DUMP,
   LCRZO_PRINTTYPE_DUMP, LCRZO_PRINTTYPE_DUMP, LCRZO_PRINTTYPE_DUMP,
   LCRZO_PRINTTYPE_START},
  /*    lcrzo_bool spoof_useethforip; */
  LCRZO_FALSE,
  /*    lcrzo_bool cliser_virt_answeralive; */
  LCRZO_TRUE
};


/*-------------------------------------------------------------*/
int lcrzo_global_set_language(int language)
{
  if ( language!=LCRZO_GLOBAL_USLANG && language!=LCRZO_GLOBAL_FRLANG )
    return(LCRZO_ERR_SPUNKNOWNTYPE);

  lcrzo_global.language=language;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_sock_tcpser_backlog(lcrzo_uint8 backlog)
{
  if (backlog==0) return(LCRZO_ERR_PATOOLOW);

  lcrzo_global.sock_tcpser_backlog=backlog;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_time_sleep_1threshold(lcrzo_uint32 threshold)
{ lcrzo_global.time_sleep_threshold1=threshold;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_time_sleep_2threshold(lcrzo_uint32 threshold)
{ lcrzo_global.time_sleep_threshold2=threshold;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_time_sleep_3threshold(lcrzo_uint32 threshold)
{ lcrzo_global.time_sleep_threshold3=threshold;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_record_open_existentfile(lcrzo_bool yesitmustbe)
{ lcrzo_bool_verifbof(yesitmustbe);
  lcrzo_global.record_open_mustbeanexistentfile=yesitmustbe;
  if (yesitmustbe)
    lcrzo_global.record_open_mustbeanewfile=0;
  else
    lcrzo_global.record_open_mustbeanewfile=1;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_record_open_newfile(lcrzo_bool yesitmustbe)
{ lcrzo_bool_verifbof(yesitmustbe);
  lcrzo_global.record_open_mustbeanewfile=yesitmustbe;
  if (yesitmustbe)
    lcrzo_global.record_open_mustbeanexistentfile=0;
  else
    lcrzo_global.record_open_mustbeanexistentfile=1;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_hdr_compfields(lcrzo_bool yes)
{ lcrzo_bool_verifbof(yes);
  lcrzo_global.hdr_compfields=yes;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_hdr_cf_ethtype(lcrzo_bool yes)
{ lcrzo_bool_verifbof(yes);
  lcrzo_global.hdr_compfield_ethtype=yes;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_hdr_cf_iptotlen(lcrzo_bool yes)
{ lcrzo_bool_verifbof(yes);
  lcrzo_global.hdr_compfield_iptotlen=yes;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_hdr_cf_ipihl(lcrzo_bool yes)
{ lcrzo_bool_verifbof(yes);
  lcrzo_global.hdr_compfield_ipihl=yes;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_hdr_cf_ipcheck(lcrzo_bool yes)
{ lcrzo_bool_verifbof(yes);
  lcrzo_global.hdr_compfield_ipcheck=yes;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_hdr_cf_ipprotocol(lcrzo_bool yes)
{ lcrzo_bool_verifbof(yes);
  lcrzo_global.hdr_compfield_ipprotocol=yes;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_hdr_cf_udplen(lcrzo_bool yes)
{ lcrzo_bool_verifbof(yes);
  lcrzo_global.hdr_compfield_udplen=yes;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_hdr_cf_udpcheck(lcrzo_bool yes)
{ lcrzo_bool_verifbof(yes);
  lcrzo_global.hdr_compfield_udpcheck=yes;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_hdr_cf_tcpdoff(lcrzo_bool yes)
{ lcrzo_bool_verifbof(yes);
  lcrzo_global.hdr_compfield_tcpdoff=yes;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_hdr_cf_tcpcheck(lcrzo_bool yes)
{ lcrzo_bool_verifbof(yes);
  lcrzo_global.hdr_compfield_tcpcheck=yes;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_hdr_cf_icmpcheck(lcrzo_bool yes)
{ lcrzo_bool_verifbof(yes);
  lcrzo_global.hdr_compfield_icmpcheck=yes;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_intspoof_eth_type(lcrzo_uint8 intspoof_eth_type)
{ 
  switch(intspoof_eth_type)
  { case LCRZO_INTSPOOF_TYPE_RAND:
    case LCRZO_INTSPOOF_TYPE_RANDCONST:
    case LCRZO_INTSPOOF_TYPE_USER:
    case LCRZO_INTSPOOF_TYPE_COMP:
    case LCRZO_INTSPOOF_TYPE_COMPCONST:
      break;
    default:
      return(LCRZO_ERR_SPUNKNOWNTYPE);
      break;
  }
  lcrzo_global.intspoof_eth_type=intspoof_eth_type;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_intspoof_eth_type(lcrzo_uint8 *pintspoof_eth_type)
{ if (pintspoof_eth_type!=NULL)
  { *pintspoof_eth_type=lcrzo_global.intspoof_eth_type;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_intspoof_eth_address(const lcrzo_etha intspoof_eth_address)
{ memcpy(lcrzo_global.intspoof_eth_address, intspoof_eth_address, 
	 LCRZO_ETHA_MAXBYTES);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_intspoof_eth_address(lcrzo_etha intspoof_eth_address)
{ if (intspoof_eth_address!=NULL)
  { memcpy(intspoof_eth_address, lcrzo_global.intspoof_eth_address, 
	   LCRZO_ETHA_MAXBYTES);
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_intspoof_ip_type(lcrzo_uint8 intspoof_ip_type)
{ 
  switch(intspoof_ip_type)
  { case LCRZO_INTSPOOF_TYPE_RAND:
    case LCRZO_INTSPOOF_TYPE_RANDCONST:
    case LCRZO_INTSPOOF_TYPE_USER:
    case LCRZO_INTSPOOF_TYPE_COMP:
    case LCRZO_INTSPOOF_TYPE_COMPCONST:
      break;
    default:
      return(LCRZO_ERR_SPUNKNOWNTYPE);
      break;
  }
  lcrzo_global.intspoof_ip_type=intspoof_ip_type;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_intspoof_ip_type(lcrzo_uint8 *pintspoof_ip_type)
{ if (pintspoof_ip_type!=NULL)
  { *pintspoof_ip_type=lcrzo_global.intspoof_ip_type;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_intspoof_ip_address(const lcrzo_ipa intspoof_ip_address)
{ memcpy(lcrzo_global.intspoof_ip_address, intspoof_ip_address, 
	 LCRZO_IPA_MAXBYTES);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_intspoof_ip_address(lcrzo_ipa intspoof_ip_address)
{ if (intspoof_ip_address!=NULL)
  { memcpy(intspoof_ip_address, lcrzo_global.intspoof_ip_address, 
	   LCRZO_IPA_MAXBYTES);
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_priv_global_get_intspoof_eth(const lcrzo_etha ethaforcomp,
				       lcrzo_etha etha);
int lcrzo_priv_global_get_intspoof_eth(const lcrzo_etha ethaforcomp,
				       lcrzo_etha etha)
{ static lcrzo_bool randconstdone=0, compconstdone;
  static lcrzo_etha savedetha;
  int i;

  if (etha==NULL) return(LCRZO_ERR_OK);

  /* if we change the type, we have to redo the randconst */
  if (lcrzo_global.intspoof_eth_type!=LCRZO_INTSPOOF_TYPE_RANDCONST)
  { randconstdone=0;
  }
  if (lcrzo_global.intspoof_eth_type!=LCRZO_INTSPOOF_TYPE_COMPCONST)
  { compconstdone=0;
  }

  switch(lcrzo_global.intspoof_eth_type)
  { case LCRZO_INTSPOOF_TYPE_RAND:
      for ( i=0 ; i<LCRZO_ETHA_MAXBYTES ; i++ )
      { lcrzo_er(lcrzo_uint8_rand(1, 0xFE, &(etha[i])));
      }
      break;
    case LCRZO_INTSPOOF_TYPE_RANDCONST:
      if (!randconstdone)
      { for ( i=0 ; i<LCRZO_ETHA_MAXBYTES ; i++ )
        { lcrzo_er(lcrzo_uint8_rand(1, 0xFE,
				    &savedetha[i]));
        }
        randconstdone=1;
      }
      memcpy(etha, savedetha, LCRZO_ETHA_MAXBYTES);
      break;
    case LCRZO_INTSPOOF_TYPE_USER:
      memcpy(etha, lcrzo_global.intspoof_eth_address, LCRZO_ETHA_MAXBYTES);
      break;
    case LCRZO_INTSPOOF_TYPE_COMP:
      if (ethaforcomp==NULL) return(LCRZO_ERR_PANULLPTR);
      etha[0]=ethaforcomp[0];
      etha[1]=ethaforcomp[1];
      for ( i=2 ; i<LCRZO_ETHA_MAXBYTES ; i++ )
      { lcrzo_er(lcrzo_uint8_rand(1, 0xFE, &(etha[i])));
      }
      break;
    case LCRZO_INTSPOOF_TYPE_COMPCONST:
      if (ethaforcomp==NULL) return(LCRZO_ERR_PANULLPTR);
      if (!compconstdone)
      { savedetha[0]=ethaforcomp[0];
        savedetha[1]=ethaforcomp[1];
        for ( i=2 ; i<LCRZO_ETHA_MAXBYTES ; i++ )
        { lcrzo_er(lcrzo_uint8_rand(1, 0xFE, &(savedetha[i])));
        }
        compconstdone=1;
      }
      memcpy(etha, savedetha, LCRZO_ETHA_MAXBYTES);
      break;
    default:
      return(LCRZO_ERR_SPUNKNOWNTYPE);
      break;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_priv_global_get_intspoof_ip(const lcrzo_ipa ipaforcomp,
                                      lcrzo_ipa ipa);
int lcrzo_priv_global_get_intspoof_ip(const lcrzo_ipa ipaforcomp,
                                      lcrzo_ipa ipa)
{ static lcrzo_bool randconstdone=0, compconstdone;
  static lcrzo_ipa savedipa;
  int i;
  lcrzo_uint8 sixbits, twobits;

  if (ipa==NULL) return(LCRZO_ERR_OK);

  /* if we change the type, we have to redo the randconst */
  if (lcrzo_global.intspoof_ip_type!=LCRZO_INTSPOOF_TYPE_RANDCONST)
  { randconstdone=0;
  }
  if (lcrzo_global.intspoof_ip_type!=LCRZO_INTSPOOF_TYPE_COMPCONST)
  { compconstdone=0;
  }

  switch(lcrzo_global.intspoof_ip_type)
  { case LCRZO_INTSPOOF_TYPE_RAND:
      for ( i=0 ; i<LCRZO_IPA_MAXBYTES ; i++ )
      { lcrzo_er(lcrzo_uint8_rand(1, 0xFE, &(ipa[i])));
      }
      break;
    case LCRZO_INTSPOOF_TYPE_RANDCONST:
      if (!randconstdone)
      { for ( i=0 ; i<LCRZO_IPA_MAXBYTES ; i++ )
        { lcrzo_er(lcrzo_uint8_rand(1, 0xFE,
				    &savedipa[i]));
        }
        randconstdone=1;
      }
      memcpy(ipa, savedipa, LCRZO_IPA_MAXBYTES);
      break;
    case LCRZO_INTSPOOF_TYPE_USER:
      memcpy(ipa, lcrzo_global.intspoof_ip_address, LCRZO_IPA_MAXBYTES);
      break;
    case LCRZO_INTSPOOF_TYPE_COMP:
      if (ipaforcomp==NULL) return(LCRZO_ERR_PANULLPTR);
      memcpy(ipa, ipaforcomp, LCRZO_IPA_MAXBYTES);
      sixbits=ipa[3]&252;
      twobits=ipa[3]&3;
      switch(twobits)
      { case 0: twobits=1; break;
        case 1: twobits=2; break;
        case 2: twobits=1; break;
        case 3: twobits=2; break;
      }
      ipa[3]= sixbits | twobits ; 
      break;
    case LCRZO_INTSPOOF_TYPE_COMPCONST:
      if (ipaforcomp==NULL) return(LCRZO_ERR_PANULLPTR);
      if (!compconstdone)
      { memcpy(savedipa, ipaforcomp, LCRZO_IPA_MAXBYTES);
        sixbits=ipaforcomp[3]&252;
        twobits=ipaforcomp[3]&3;
        switch(twobits)
        { case 0: twobits=1; break;
          case 1: twobits=2; break;
          case 2: twobits=1; break;
          case 3: twobits=2; break;
	}
	savedipa[3]= sixbits | twobits ; 
        compconstdone=1;
      }
      memcpy(ipa, savedipa, LCRZO_IPA_MAXBYTES);
      break;
    default:
      return(LCRZO_ERR_SPUNKNOWNTYPE);
      break;
  }
  return(LCRZO_ERR_OK);
}





/*-------------------------------------------------------------*/
int lcrzo_global_get_language(int *planguage)
{ if (planguage!=NULL) *planguage=lcrzo_global.language;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_sock_tcpser_backlog(lcrzo_uint8 *pbacklog)
{ if (pbacklog!=NULL) *pbacklog=lcrzo_global.sock_tcpser_backlog;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_time_sleep_1threshold(lcrzo_uint32 *pthreshold)
{ if (pthreshold!=NULL) *pthreshold=lcrzo_global.time_sleep_threshold1;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_time_sleep_2threshold(lcrzo_uint32 *pthreshold)
{ if (pthreshold!=NULL) *pthreshold=lcrzo_global.time_sleep_threshold2;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_time_sleep_3threshold(lcrzo_uint32 *pthreshold)
{ if (pthreshold!=NULL) *pthreshold=lcrzo_global.time_sleep_threshold3;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_record_open_existentfile(lcrzo_bool *pyesitmustbe)
{ if (pyesitmustbe!=NULL)
  { *pyesitmustbe=lcrzo_global.record_open_mustbeanexistentfile;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_record_open_newfile(lcrzo_bool *pyesitmustbe)
{ if (pyesitmustbe!=NULL)
  { *pyesitmustbe=lcrzo_global.record_open_mustbeanewfile;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_hdr_compfields(lcrzo_bool *pyes)
{ if (pyes!=NULL)
  { *pyes=lcrzo_global.hdr_compfields;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_hdr_cf_ethtype(lcrzo_bool *pyes)
{ if (pyes!=NULL)
  { *pyes=lcrzo_global.hdr_compfield_ethtype;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_hdr_cf_iptotlen(lcrzo_bool *pyes)
{ if (pyes!=NULL)
  { *pyes=lcrzo_global.hdr_compfield_iptotlen;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_hdr_cf_ipihl(lcrzo_bool *pyes)
{ if (pyes!=NULL)
  { *pyes=lcrzo_global.hdr_compfield_ipihl;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_hdr_cf_ipcheck(lcrzo_bool *pyes)
{ if (pyes!=NULL)
  { *pyes=lcrzo_global.hdr_compfield_ipcheck;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_hdr_cf_ipprotocol(lcrzo_bool *pyes)
{ if (pyes!=NULL)
  { *pyes=lcrzo_global.hdr_compfield_ipprotocol;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_hdr_cf_udplen(lcrzo_bool *pyes)
{ if (pyes!=NULL)
  { *pyes=lcrzo_global.hdr_compfield_udplen;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_hdr_cf_udpcheck(lcrzo_bool *pyes)
{ if (pyes!=NULL)
  { *pyes=lcrzo_global.hdr_compfield_udpcheck;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_hdr_cf_tcpdoff(lcrzo_bool *pyes)
{ if (pyes!=NULL)
  { *pyes=lcrzo_global.hdr_compfield_tcpdoff;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_hdr_cf_tcpcheck(lcrzo_bool *pyes)
{ if (pyes!=NULL)
  { *pyes=lcrzo_global.hdr_compfield_tcpcheck;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_hdr_cf_icmpcheck(lcrzo_bool *pyes)
{ if (pyes!=NULL)
  { *pyes=lcrzo_global.hdr_compfield_icmpcheck;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_resolver_timeout(lcrzo_uint8 timeout)
{ lcrzo_global.resolver_timeout=timeout;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_resolver_timeout(lcrzo_uint8 *ptimeout)
{ if (ptimeout!=NULL) *ptimeout=lcrzo_global.resolver_timeout;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_cliser_virt_answeralive(lcrzo_bool answeralive)
{ lcrzo_bool_verifbof(answeralive);
  lcrzo_global.cliser_virt_answeralive=answeralive;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_cliser_virt_answeralive(lcrzo_bool *pansweralive)
{ if (pansweralive!=NULL) 
  { *pansweralive=lcrzo_global.cliser_virt_answeralive;
  }
  return(LCRZO_ERR_OK);
}


/*************/

/*-------------------------------------------------------------*/
int lcrzo_global_set_sniff_ipreas1timeout(lcrzo_uint16 timeout)
{ lcrzo_global.sniff_ipreastimeout1=timeout;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_sniff_ipreas2timeout(lcrzo_uint16 timeout)
{ lcrzo_global.sniff_ipreastimeout2=timeout;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_sniff_tcpreor1timeout(lcrzo_uint16 timeout)
{ lcrzo_global.sniff_tcpreortimeout1=timeout;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_sniff_tcpreor2timeout(lcrzo_uint16 timeout)
{ lcrzo_global.sniff_tcpreortimeout2=timeout;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_spoof_fragoctosize(lcrzo_uint16 fragoctosize)
{ if (fragoctosize==0) return(LCRZO_ERR_PATOOLOW);
  if (fragoctosize>8192) return(LCRZO_ERR_PATOOBIG);

  lcrzo_global.spoof_fragoctosize=fragoctosize;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_spoof_printbeforesending(lcrzo_bool printbeforesending)
{ lcrzo_bool_verifbof(printbeforesending);
  lcrzo_global.spoof_printbeforesending=printbeforesending;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_spoof_printprofile(lcrzo_printprofile printprofile)
{ lcrzo_global.spoof_printprofile=printprofile;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_set_spoof_useethforip(lcrzo_bool useethforip)
{ lcrzo_bool_verifbof(useethforip);
  lcrzo_global.spoof_useethforip=useethforip;
  return(LCRZO_ERR_OK);
}


/*-------------------------------------------------------------*/
int lcrzo_global_get_sniff_ipreas1timeout(lcrzo_uint16 *ptimeout)
{ if (ptimeout!=NULL) *ptimeout=lcrzo_global.sniff_ipreastimeout1;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_sniff_ipreas2timeout(lcrzo_uint16 *ptimeout)
{ if (ptimeout!=NULL) *ptimeout=lcrzo_global.sniff_ipreastimeout2;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_sniff_tcpreor1timeout(lcrzo_uint16 *ptimeout)
{ if (ptimeout!=NULL) *ptimeout=lcrzo_global.sniff_tcpreortimeout1;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_sniff_tcpreor2timeout(lcrzo_uint16 *ptimeout)
{ if (ptimeout!=NULL) *ptimeout=lcrzo_global.sniff_tcpreortimeout2;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_spoof_fragoctosize(lcrzo_uint16 *pfragoctosize)
{ if (pfragoctosize!=NULL) *pfragoctosize=lcrzo_global.spoof_fragoctosize;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_spoof_printbeforesending(lcrzo_bool *pprintbeforesending)
{ if (pprintbeforesending!=NULL) 
  { *pprintbeforesending=lcrzo_global.spoof_printbeforesending;
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_spoof_printprofile(lcrzo_printprofile *pprintprofile)
{ if (pprintprofile!=NULL) *pprintprofile=lcrzo_global.spoof_printprofile;
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_global_get_spoof_useethforip(lcrzo_bool *puseethforip)
{ if (puseethforip!=NULL) 
  { *puseethforip=lcrzo_global.spoof_useethforip;
  }
  return(LCRZO_ERR_OK);
}

