/*us    Laurent Constantin's network library (lcrzo)
                 lcrzo_priv module

  Functions herein are private.
*/
/*fr    Bibliotheque reseau de Laurent Constantin (lcrzo)
                 Module lcrzo_priv

  Les fonctions presentes dans ce module sont privees a la bibliotheque.
*/


#include "lcrzo.h"

/*-------------------------------------------------------------*/
#define LCRZO_PRIV_PRINTTYPE_COUNT    35
#define LCRZO_PRIV_PRINTPROFILE_COUNT  8

/*---------------------------------------------------------------*/
int lcrzo_priv_etha_and(lcrzo_etha a, lcrzo_etha b, lcrzo_etha result);
int lcrzo_priv_etha_or(lcrzo_etha a, lcrzo_etha b, lcrzo_etha result);
int lcrzo_priv_etha_xor(lcrzo_etha a, lcrzo_etha b, lcrzo_etha result);
int lcrzo_priv_etha_not(lcrzo_etha a, lcrzo_etha result);
int lcrzo_priv_etha_inc(lcrzo_etha a, lcrzo_etha result);
int lcrzo_priv_etha_dec(lcrzo_etha a, lcrzo_etha result);
int lcrzo_priv_etha_shl(lcrzo_etha a, lcrzo_etha result);
int lcrzo_priv_etha_shr(lcrzo_etha a, lcrzo_etha result);

/*-------------------------------------------------------------*/
int lcrzo_priv_hdrleth_equal_addr(lcrzo_hdrleth hdrleth,
				  const lcrzo_etha ethasrc,
				  const lcrzo_etha ethadst);
int lcrzo_priv_hdrlip_equal_addr(lcrzo_hdrlip hdrlip,
				 const lcrzo_ipl iplsrc,
				 const lcrzo_ipl ipldst);
int lcrzo_priv_hdrludp_equal_port(lcrzo_hdrludp hdrludp,
				  lcrzo_uint16 portsrc,
				  lcrzo_uint16 portdst);
int lcrzo_priv_hdrltcp_equal_port(lcrzo_hdrltcp hdrltcp,
				  lcrzo_uint16 portsrc,
				  lcrzo_uint16 portdst);

/*-------------------------------------------------------------*/
int lcrzo_priv_stdin(lcrzo_string *puserstring,
		     lcrzo_int32 *puserstringsize);
int lcrzo_priv_passwd(lcrzo_string *puserstring,
		      lcrzo_int32 *puserstringsize);


/*---------------------------------------------------------------*/
#define LCRZO_PRIV_INCREASE 1
#define LCRZO_PRIV_DECREASE 2

/*-------------------------------------------------------------*/
int lcrzo_priv_manageelempos(lcrzo_int32 elemcount,
			     lcrzo_int32 position,
			     lcrzo_bool wanttoinsertelem,
			     lcrzo_int32 *pposnegative,
			     lcrzo_int32 *ppospositive,
			     int *pdirection, 
			     lcrzo_int32 *pdistance);
int lcrzo_priv_manageelemrange(lcrzo_int32 elemcount,
			       lcrzo_int32 infposition,
			       lcrzo_int32 supposition,
			       lcrzo_int32 *pinfposnegative,
			       lcrzo_int32 *pinfpospositive,
			       lcrzo_int32 *psupposnegative,
			       lcrzo_int32 *psuppospositive,
			       int *pinfdirection, 
			       lcrzo_int32 *pinfdistance,
			       int *pinfsupdirection, 
			       lcrzo_int32 *pinfsupdistance);
int lcrzo_priv_manageelemrangefast(lcrzo_int32 elemcount,
				   lcrzo_int32 infposition,
				   lcrzo_int32 supposition,
				   lcrzo_int32 *pinfposnegative,
				   lcrzo_int32 *pinfpospositive,
				   lcrzo_int32 *psupposnegative,
				   lcrzo_int32 *psuppospositive,
				   int *pinfdirection, 
				   lcrzo_int32 *pinfdistance,
				   int *pinfsupdirection, 
				   lcrzo_int32 *pinfsupdistance);

/*-------------------------------------------------------------*/
int lcrzo_priv_managedataposneg(lcrzo_int32 datasize,
				lcrzo_int32 negative,
				lcrzo_int32 *pnegative,
				lcrzo_int32 *ppositive);
int lcrzo_priv_managedatapospos(lcrzo_int32 datasize,
				lcrzo_int32 positive,
				lcrzo_int32 *pnegative,
				lcrzo_int32 *ppositive);
int lcrzo_priv_managedatarange(lcrzo_int32 datasize,
			       lcrzo_int32 infposition,
			       lcrzo_int32 supposition,
			       lcrzo_int32 *pinfposnegative,
			       lcrzo_int32 *pinfpospositive,
			       lcrzo_int32 *psupposnegative,
			       lcrzo_int32 *psuppospositive,
			       int *pinfdirection, 
			       lcrzo_int32 *pinfdistance,
			       int *pinfsupdirection, 
			       lcrzo_int32 *pinfsupdistance);


/*-------------------------------------------------------------*/
int lcrzo_priv_data_u16_init_data(lcrzo_constdata datain,
				  lcrzo_uint16 datainsize,
				  lcrzo_uint16 dataoutmaxsize,
				  lcrzo_data dataout,
				  lcrzo_uint16 *pdataoutsize);
int lcrzo_priv_data_u16_initm_data(lcrzo_constdata datain,
				   lcrzo_uint16 datainsize,
				   lcrzo_data *pdataout,
				   lcrzo_uint16 *pdataoutsize);
int lcrzo_priv_data_u16_append_data(lcrzo_constdata datain,
				    lcrzo_uint16 datainsize,
				    lcrzo_uint16 dataoutcurrentsize,
				    lcrzo_uint16 dataoutmaxsize,
				    lcrzo_data dataout,
				    lcrzo_uint16 *pdataoutsize);
int lcrzo_priv_data_u16_appendm_data(lcrzo_constdata datain,
				     lcrzo_uint16 datainsize,
				     lcrzo_uint16 dataoutcurrentsize,
				     lcrzo_data *pdataout,
				     lcrzo_uint16 *pdataoutsize);

/*-------------------------------------------------------------*/
/*us system dependant functions */
/*fr fonctions dependant du systeme */
#include "lcrzo_sysdep.h"
