/*
		                  LCRZO
                             Network library
             Copyright(c) 1999,2000,2001, Laurent Constantin
                                  -----

  Main server    : http://www.laurentconstantin.com/
  Backup servers : http://go.to/laurentconstantin/
                   http://laurentconstantin.est-la.com/
  [my current email address is on the web servers]

                                  -----
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details (http://www.gnu.org).

------------------------------------------------------------------------
*/

/* -- Note about comments and variable names --
   In versions 1.00 up to 2.08, lcrzo was only written in French (my
   mother tongue). Since version 3.00, lcrzo is written in English, but
   most of comments and variable names are still in French.
   In future versions, I'll try to translate everything into English,
   but as you may guess, that's a quite big work...
   So, for the moment, here are some word translation, if you want to
   be able to understand what's going on in the functions :
     afficher - print     ;  ajouter - add         ;  copie - copy
     dernier - last       ;  donnee - data         ;  ecrire - write
     entete - header      ;  envoye - sent         ;  ferme - close
     fichier - file       ;  lire - read           ;  masque - mask 
     nboct - byte number  ;  ouvre, ouvrir - open  ;  paq, paquet - packet
     plage - range        ;  premier - first       ;  recu - received
     reseau - network     ;  retour - return       ;  taille - size
     tunnel - pipe

*/

#include "lcrzo_priv.h"
#ifdef LCRZODEF_SYSTEM_Linux
 #include <stdlib.h>
#elif defined LCRZODEF_SYSTEM_FreeBSD
 #include <stdlib.h>
#elif defined LCRZODEF_SYSTEM_Solaris
 #include <stdlib.h>
#else
 #error "Traiter le cas de LCRZODEF_SYSTEM"
#endif

/*-------------------------------------------------------------*/
int lcrzo_string_alloc(lcrzo_int32 allocsize, lcrzo_string *pptr)
{ return(lcrzo_data_alloc(allocsize, (lcrzo_data*)pptr));
}

/*-------------------------------------------------------------*/
int lcrzo_string_realloc(lcrzo_int32 newallocsize, lcrzo_string *pptr)
{ return(lcrzo_data_realloc(newallocsize, (lcrzo_data*)pptr));
}

/*-------------------------------------------------------------*/
int lcrzo_string_free(lcrzo_string ptr)
{ return(lcrzo_data_free(ptr));
}


/*-------------------------------------------------------------*/
int lcrzo_string_init_data(lcrzo_constdata datain,
			   lcrzo_int32 datainsize,
			   lcrzo_int32 stringoutmaxsize,
			   char* stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_data(datain, datainsize, 0,
			     stringoutmaxsize, (lcrzo_data)stringout,
			     &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_data(lcrzo_constdata datain,
			    lcrzo_int32 datainsize,
			    char* *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_data(datain, datainsize, 0,
				   &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_data(lcrzo_constdata datain,
			     lcrzo_int32 datainsize,
			     lcrzo_int32 stringoutmaxsize,
			     char* stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_data(datain, datainsize, strlen(stringout),
			     stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  stringout[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_data(lcrzo_constdata datain,
			      lcrzo_int32 datainsize,
			      char* *pstringout)
{ char * ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_data(datain, datainsize, strlen(*pstringout),
				   (lcrzo_data *)pstringout, &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_range(lcrzo_conststring stringin,
			    lcrzo_int32 stringinstartpos,
			    lcrzo_int32 stringinendpos,
			    lcrzo_int32 stringoutmaxsize,
			    lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_range((lcrzo_constdata)stringin, strlen(stringin),
			      stringinstartpos, stringinendpos, 0,
			      stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_range(lcrzo_conststring stringin,
			     lcrzo_int32 stringinstartpos,
			     lcrzo_int32 stringinendpos,
			     lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_range((lcrzo_constdata)stringin, strlen(stringin),
				    stringinstartpos, stringinendpos, 0,
				    &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_range(lcrzo_conststring stringin,
			      lcrzo_int32 stringinstartpos,
			      lcrzo_int32 stringinendpos,
			      lcrzo_int32 stringoutmaxsize,
			      lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_range((lcrzo_constdata)stringin, strlen(stringin),
			      stringinstartpos, stringinendpos,
			      strlen(stringout),
			      stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_range(lcrzo_conststring stringin,
			       lcrzo_int32 stringinstartpos,
			       lcrzo_int32 stringinendpos,
			       lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_range((lcrzo_constdata)stringin, strlen(stringin),
				    stringinstartpos, stringinendpos,
				    strlen(*pstringout), 
				    (lcrzo_data *)pstringout, &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_fill(lcrzo_conststring stringin,
			   lcrzo_int32 fillingsize,
			   lcrzo_int32 stringoutmaxsize,
			   lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_fill((lcrzo_constdata)stringin, strlen(stringin),
			     fillingsize, 0,
			     stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_fill(lcrzo_conststring stringin,
			    lcrzo_int32 fillingsize,
			    lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_fill((lcrzo_constdata)stringin, strlen(stringin),
				   fillingsize, 0,
				   &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_fill(lcrzo_conststring stringin,
			     lcrzo_int32 fillingsize,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_fill((lcrzo_constdata)stringin, strlen(stringin),
			     fillingsize,
			     strlen(stringout),
			     stringoutmaxsize, 
			     (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_fill(lcrzo_conststring stringin,
			      lcrzo_int32 fillingsize,
			      lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_fill((lcrzo_constdata)stringin, strlen(stringin),
				   fillingsize,
				   strlen(*pstringout), 
				   (lcrzo_data *)pstringout, &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_char(lcrzo_uint8 c,
			   lcrzo_int32 fillingsize,
			   lcrzo_int32 stringoutmaxsize,
			   lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_char(c, fillingsize, 0,
			     stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_char(lcrzo_uint8 c,
			    lcrzo_int32 fillingsize,
			    lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_char(c, fillingsize, 0,
				   &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_char(lcrzo_uint8 c,
			     lcrzo_int32 fillingsize,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_char(c, fillingsize,
			     strlen(stringout),
			     stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_char(lcrzo_uint8 c,
			      lcrzo_int32 fillingsize,
			      lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_char(c, fillingsize,
				   strlen(*pstringout), 
				   (lcrzo_data *)pstringout, &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_rand(lcrzo_uint8 minvalue,
			   lcrzo_uint8 maxvalue,
			   lcrzo_int32 fillingsize,
			   lcrzo_int32 stringoutmaxsize,
			   lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_rand(minvalue, maxvalue, fillingsize, 0,
			     stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_rand(lcrzo_uint8 minvalue,
			    lcrzo_uint8 maxvalue,
			    lcrzo_int32 fillingsize,
			    lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_rand(minvalue, maxvalue, fillingsize, 0,
				   &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_rand(lcrzo_uint8 minvalue,
			     lcrzo_uint8 maxvalue,
			     lcrzo_int32 fillingsize,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_rand(minvalue, maxvalue, fillingsize,
			     strlen(stringout),
			     stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_rand(lcrzo_uint8 minvalue,
			      lcrzo_uint8 maxvalue,
			      lcrzo_int32 fillingsize,
			      lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_rand(minvalue, maxvalue, fillingsize,
				   strlen(*pstringout), 
				   (lcrzo_data *)pstringout, &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_int(lcrzo_int32 integer,
			  const char * format,
			  lcrzo_int32 stringoutmaxsize,
			  lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_int(integer, format, 0,
			    stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_int(lcrzo_int32 integer,
			   const char * format,
			   lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_int(integer, format, 0,
				   &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_int(lcrzo_int32 integer,
			    const char * format,
			    lcrzo_int32 stringoutmaxsize,
			    lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_int(integer, format, strlen(stringout),
			     stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_int(lcrzo_int32 integer,
			     const char * format,
			     lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_int(integer, format, strlen(*pstringout), 
				  (lcrzo_data *)pstringout, &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_text(const char * text,
			   lcrzo_int32 stringoutmaxsize,
			   lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_text(text, 0,
			    stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_text(const char * text,
			    lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_text(text, 0,
				   &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_text(const char * text,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_text(text, strlen(stringout),
			     stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_text(const char * text,
			      lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_text(text, strlen(*pstringout), 
				   (lcrzo_data *)pstringout, &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_coretext(const char * text,
			       lcrzo_int32 stringoutmaxsize,
			       lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_coretext(text, 0,
				 stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_coretext(const char * text,
				lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_coretext(text, 0,
				       &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_coretext(const char * text,
				 lcrzo_int32 stringoutmaxsize,
				 lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_coretext(text, strlen(stringout),
				 stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_coretext(const char * text,
				  lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_coretext(text, strlen(*pstringout), 
				       (lcrzo_data *)pstringout,
				       &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_hexa(const char * hexa,
			   lcrzo_int32 stringoutmaxsize,
			   lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_hexa(hexa, 0,
			     stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_hexa(const char * hexa,
			    lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_hexa(hexa, 0, &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_hexa(const char * hexa,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_hexa(hexa, strlen(stringout),
			     stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_hexa(const char * hexa,
			      lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_hexa(hexa, strlen(*pstringout), 
				   (lcrzo_data *)pstringout,
				   &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_mixed(const char * mixed,
			    lcrzo_int32 stringoutmaxsize,
			    lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_mixed(mixed, 0,
			      stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_mixed(const char * mixed,
			     lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_mixed(mixed, 0, &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_mixed(const char * mixed,
			      lcrzo_int32 stringoutmaxsize,
			      lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_mixed(mixed, strlen(stringout),
			     stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_mixed(const char * mixed,
			       lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_mixed(mixed, strlen(*pstringout), 
				    (lcrzo_data *)pstringout,
				    &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_base64(const char * base64,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_base64(base64, 0,
			       stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_base64(const char * base64,
			      lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_base64(base64, 0, &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_base64(const char * base64,
			       lcrzo_int32 stringoutmaxsize,
			       lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_base64(base64, strlen(stringout),
			       stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_base64(const char * base64,
				lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_base64(base64, strlen(*pstringout), 
				     (lcrzo_data *)pstringout,
				     &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_text_stdin(const char * message,
				 const char * defaulttext,
				 lcrzo_int32 stringoutmaxsize,
				 lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_text_stdin(message, defaulttext, 0,
				   stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_text_stdin(const char * message,
				  const char * defaulttext,
				  lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_text_stdin(message, defaulttext, 
					 0, &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_text_stdin(const char * message,
				   const char * defaulttext,
				   lcrzo_int32 stringoutmaxsize,
				   lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_text_stdin(message, defaulttext, strlen(stringout),
				   stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_text_stdin(const char * message,
				    const char * defaulttext,
				    lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_text_stdin(message, defaulttext,
					 strlen(*pstringout), 
					 (lcrzo_data *)pstringout,
					 &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_coretext_stdin(const char * message,
				     const char * defaultcoretext,
				     lcrzo_int32 stringoutmaxsize,
				     lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_coretext_stdin(message, defaultcoretext, 0,
				       stringoutmaxsize, (lcrzo_data)stringout,
				       &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_coretext_stdin(const char * message,
				      const char * defaultcoretext,
				      lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_coretext_stdin(message, defaultcoretext, 
					     0, &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_coretext_stdin(const char * message,
				       const char * defaultcoretext,
				       lcrzo_int32 stringoutmaxsize,
				       lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_coretext_stdin(message, defaultcoretext,
				       strlen(stringout), stringoutmaxsize, 
				       (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_coretext_stdin(const char * message,
					const char * defaultcoretext,
					lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_coretext_stdin(message, defaultcoretext,
					     strlen(*pstringout), 
					     (lcrzo_data *)pstringout,
					     &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_text_passwd(const char * message,
				  const char * defaulttext,
				  lcrzo_int32 stringoutmaxsize,
				  lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_text_passwd(message, defaulttext, 0,
				    stringoutmaxsize, (lcrzo_data)stringout,
				    &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_text_passwd(const char * message,
				   const char * defaulttext,
				   lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_text_passwd(message, defaulttext, 
					  0, &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_text_passwd(const char * message,
				    const char * defaulttext,
				    lcrzo_int32 stringoutmaxsize,
				    lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_text_passwd(message, defaulttext, strlen(stringout),
				    stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_text_passwd(const char * message,
				     const char * defaulttext,
				     lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_text_passwd(message, defaulttext,
					  strlen(*pstringout), 
					  (lcrzo_data *)pstringout,
					  &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_coretext_passwd(const char * message,
				      const char * defaultcoretext,
				      lcrzo_int32 stringoutmaxsize,
				      lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_coretext_passwd(message, defaultcoretext, 0,
					stringoutmaxsize,
					(lcrzo_data)stringout,
					&dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_coretext_passwd(const char * message,
				       const char * defaultcoretext,
				       lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_coretext_passwd(message, defaultcoretext, 
					      0, &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_coretext_passwd(const char * message,
					const char * defaultcoretext,
					lcrzo_int32 stringoutmaxsize,
					lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_coretext_passwd(message, defaultcoretext,
					strlen(stringout), stringoutmaxsize, 
					(lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_coretext_passwd(const char * message,
					 const char * defaultcoretext,
					 lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_coretext_passwd(message, defaultcoretext,
					      strlen(*pstringout), 
					      (lcrzo_data *)pstringout,
					      &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_hexa_stdin(const char * message,
				 const char * defaulthexa,
				 lcrzo_int32 stringoutmaxsize,
				 lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_hexa_stdin(message, defaulthexa, 0,
				   stringoutmaxsize, (lcrzo_data)stringout,
				   &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_hexa_stdin(const char * message,
				  const char * defaulthexa,
				  lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_hexa_stdin(message, defaulthexa, 
					 0, &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_hexa_stdin(const char * message,
				   const char * defaulthexa,
				   lcrzo_int32 stringoutmaxsize,
				   lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_hexa_stdin(message, defaulthexa, strlen(stringout),
				   stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_hexa_stdin(const char * message,
				    const char * defaulthexa,
				    lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_hexa_stdin(message, defaulthexa,
					 strlen(*pstringout), 
					 (lcrzo_data *)pstringout,
					 &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_mixed_stdin(const char * message,
				  const char * defaultmixed,
				  lcrzo_int32 stringoutmaxsize,
				  lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_mixed_stdin(message, defaultmixed, 0,
				    stringoutmaxsize, (lcrzo_data)stringout, 
				    &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_mixed_stdin(const char * message,
				   const char * defaultmixed,
				   lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_mixed_stdin(message, defaultmixed, 
					 0, &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_mixed_stdin(const char * message,
				    const char * defaultmixed,
				    lcrzo_int32 stringoutmaxsize,
				    lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_mixed_stdin(message, defaultmixed, strlen(stringout),
				    stringoutmaxsize, (lcrzo_data)stringout, 
				    &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_mixed_stdin(const char * message,
				     const char * defaultmixed,
				     lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_mixed_stdin(message, defaultmixed,
					  strlen(*pstringout), 
					  (lcrzo_data *)pstringout,
					  &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_init_base64_stdin(const char * message,
				   const char * defaultbase64,
				   lcrzo_int32 stringoutmaxsize,
				   lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  ret=lcrzo_data_append_base64_stdin(message, defaultbase64, 0,
				     stringoutmaxsize, (lcrzo_data)stringout,
				     &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_initm_base64_stdin(const char * message,
				    const char * defaultbase64,
				    lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  ptr=NULL;
  lcrzo_er(lcrzo_data_appendm_base64_stdin(message, defaultbase64, 
					 0, &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_append_base64_stdin(const char * message,
				     const char * defaultbase64,
				     lcrzo_int32 stringoutmaxsize,
				     lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;
  int ret;

  if (stringout==NULL) return(LCRZO_ERR_PANULLPTR);
  ret=lcrzo_data_append_base64_stdin(message, defaultbase64, strlen(stringout),
				   stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize);
  if ( ret!=LCRZO_ERR_OK && ret!=LCRZO_ERR_OKDATATRUNCATED ) return(ret);
  stringout[dataoutsize]='\0';

  return(ret);
}

/*-------------------------------------------------------------*/
int lcrzo_string_appendm_base64_stdin(const char * message,
				      const char * defaultbase64,
				      lcrzo_string *pstringout)
{ lcrzo_string ptr;
  lcrzo_int32 dataoutsize;
  
  if (pstringout==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_appendm_base64_stdin(message, defaultbase64,
					 strlen(*pstringout), 
					 (lcrzo_data *)pstringout,
					 &dataoutsize));
  ptr=*pstringout;
  ptr[dataoutsize]='\0';
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_search_char(lcrzo_conststring stringin,
			     lcrzo_bool searchcomplement, 
			     lcrzo_int32 stringinstartpos,
			     lcrzo_int32 stringinendpos,
			     lcrzo_uint8 c,
			     lcrzo_int32 *pfoundposition_negative,
			     lcrzo_int32 *pfoundposition_positive)
{
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_data_search_char((lcrzo_constdata)stringin, strlen(stringin),
				searchcomplement, 
				stringinstartpos, stringinendpos,
				c,
				pfoundposition_negative,
				pfoundposition_positive));
}

/*-------------------------------------------------------------*/
int lcrzo_string_search_nchar(lcrzo_conststring stringin,
			      lcrzo_bool searchcomplement, 
			      lcrzo_int32 stringinstartpos,
			      lcrzo_int32 stringinendpos,
			      lcrzo_conststring searchlist,
			      lcrzo_int32 *pfoundposition_negative,
			      lcrzo_int32 *pfoundposition_positive)
{ 
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_data_search_nchar((lcrzo_constdata)stringin, strlen(stringin),
				 searchcomplement, 
				 stringinstartpos, stringinendpos,
				 (lcrzo_constdata)searchlist,
				 strlen(searchlist),
				 pfoundposition_negative,
				 pfoundposition_positive));
}

/*-------------------------------------------------------------*/
int lcrzo_string_search_text(lcrzo_conststring stringin,
			     lcrzo_bool searchcomplement, 
			     lcrzo_int32 stringinstartpos,
			     lcrzo_int32 stringinendpos,
			     lcrzo_conststring searchedtext,
			     lcrzo_int32 *pstartfoundposition_negative,
			     lcrzo_int32 *pstartfoundposition_positive,
			     lcrzo_int32 *pendfoundposition_negative,
			     lcrzo_int32 *pendfoundposition_positive)
{
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_data_search_text((lcrzo_constdata)stringin, strlen(stringin),
				searchcomplement, 
				stringinstartpos, stringinendpos,
				searchedtext,
				pstartfoundposition_negative,
				pstartfoundposition_positive,
				pendfoundposition_negative,
				pendfoundposition_positive));
}

/*-------------------------------------------------------------*/
int lcrzo_string_search_re(lcrzo_conststring stringin,
			   lcrzo_bool searchcomplement, 
			   lcrzo_int32 stringinstartpos,
			   lcrzo_int32 stringinendpos,
			   lcrzo_conststring regularexpression,
			   lcrzo_int32 *pstartfoundposition_negative,
			   lcrzo_int32 *pstartfoundposition_positive,
			   lcrzo_int32 *pendfoundposition_negative,
			   lcrzo_int32 *pendfoundposition_positive)
{
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_data_search_re((lcrzo_constdata)stringin, strlen(stringin),
			      searchcomplement, 
			      stringinstartpos, stringinendpos,
			      regularexpression,
			      pstartfoundposition_negative,
			      pstartfoundposition_positive,
			      pendfoundposition_negative,
			      pendfoundposition_positive));
}


/*-------------------------------------------------------------*/
int lcrzo_string_search_regexp(lcrzo_conststring stringin,
			       lcrzo_bool searchcomplement, 
			       lcrzo_int32 stringinstartpos,
			       lcrzo_int32 stringinendpos,
			       lcrzo_conststring regularexpression,
			       lcrzo_regexp arrayfoundpos)
{
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_data_search_regexp((lcrzo_constdata)stringin, strlen(stringin),
			      searchcomplement, 
			      stringinstartpos, stringinendpos,
			      regularexpression, arrayfoundpos));
}

/*-------------------------------------------------------------*/
int lcrzo_string_token_char(lcrzo_conststring stringin,
			    lcrzo_bool searchcomplement, 
			    lcrzo_int32 stringinstartpos,
			    lcrzo_int32 stringinendpos,
			    lcrzo_uint8 c,
			    lcrzo_int32 *ppositionindicator,
			    lcrzo_int32 *pstartfoundposition_negative,
			    lcrzo_int32 *pstartfoundposition_positive,
			    lcrzo_int32 *pendfoundposition_negative,
			    lcrzo_int32 *pendfoundposition_positive)
{
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_data_token_char((lcrzo_constdata)stringin, strlen(stringin),
			       searchcomplement, 
			       stringinstartpos, stringinendpos,
			       c,
			       ppositionindicator,
			       pstartfoundposition_negative,
			       pstartfoundposition_positive,
			       pendfoundposition_negative,
			       pendfoundposition_positive));
}

/*-------------------------------------------------------------*/
int lcrzo_string_token_nchar(lcrzo_conststring stringin,
			     lcrzo_bool searchcomplement, 
			     lcrzo_int32 stringinstartpos,
			     lcrzo_int32 stringinendpos,
			     lcrzo_conststring searchlist,
			     lcrzo_int32 *ppositionindicator,
			     lcrzo_int32 *pstartfoundposition_negative,
			     lcrzo_int32 *pstartfoundposition_positive,
			     lcrzo_int32 *pendfoundposition_negative,
			     lcrzo_int32 *pendfoundposition_positive)
{
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (searchlist==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_data_token_nchar((lcrzo_constdata)stringin, strlen(stringin),
			       searchcomplement, 
			       stringinstartpos, stringinendpos,
			       (lcrzo_constdata)searchlist, strlen(searchlist),
			       ppositionindicator,
			       pstartfoundposition_negative,
			       pstartfoundposition_positive,
			       pendfoundposition_negative,
			       pendfoundposition_positive));
}

/*-------------------------------------------------------------*/
int lcrzo_string_token_text(lcrzo_conststring stringin,
			    lcrzo_bool searchcomplement, 
			    lcrzo_int32 stringinstartpos,
			    lcrzo_int32 stringinendpos,
			    lcrzo_conststring searchedtext,
			    lcrzo_int32 *ppositionindicator,
			    lcrzo_int32 *pstartfoundposition_negative,
			    lcrzo_int32 *pstartfoundposition_positive,
			    lcrzo_int32 *pendfoundposition_negative,
			    lcrzo_int32 *pendfoundposition_positive)
{
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_data_token_text((lcrzo_constdata)stringin, strlen(stringin),
			       searchcomplement, 
			       stringinstartpos, stringinendpos,
			       searchedtext,
			       ppositionindicator,
			       pstartfoundposition_negative,
			       pstartfoundposition_positive,
			       pendfoundposition_negative,
			       pendfoundposition_positive));
}

/*-------------------------------------------------------------*/
int lcrzo_string_token_re(lcrzo_conststring stringin,
			  lcrzo_bool searchcomplement, 
			  lcrzo_int32 stringinstartpos,
			  lcrzo_int32 stringinendpos,
			  lcrzo_conststring regularexpression,
			  lcrzo_int32 *ppositionindicator,
			  lcrzo_int32 *pstartfoundposition_negative,
			  lcrzo_int32 *pstartfoundposition_positive,
			  lcrzo_int32 *pendfoundposition_negative,
			  lcrzo_int32 *pendfoundposition_positive)
{
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_data_token_re((lcrzo_constdata)stringin, strlen(stringin),
			     searchcomplement, 
			     stringinstartpos, stringinendpos,
			     regularexpression,
			     ppositionindicator,
			     pstartfoundposition_negative,
			     pstartfoundposition_positive,
			     pendfoundposition_negative,
			     pendfoundposition_positive));
}


/*-------------------------------------------------------------*/
int lcrzo_string_replace_char(lcrzo_conststring stringin,
			      lcrzo_bool searchcomplement, 
			      lcrzo_int32 stringinstartpos,
			      lcrzo_int32 stringinendpos,
			      lcrzo_int32 maxnumberofreplacement,
			      lcrzo_uint8 c_toreplace,
			      lcrzo_conststring string_replacing,
			      lcrzo_int32 stringoutmaxsize,
			      lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;

  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (string_replacing==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_replace_char((lcrzo_constdata)stringin, strlen(stringin),
				   searchcomplement, 
				   stringinstartpos, stringinendpos,
				   maxnumberofreplacement,
				   c_toreplace,
				   (lcrzo_constdata)string_replacing, strlen(string_replacing),
				   stringoutmaxsize, (lcrzo_data)stringout, &dataoutsize));

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_replacem_char(lcrzo_conststring stringin,
			       lcrzo_bool searchcomplement, 
			       lcrzo_int32 stringinstartpos,
			       lcrzo_int32 stringinendpos,
			       lcrzo_int32 maxnumberofreplacement,
			       lcrzo_uint8 c_toreplace,
			       lcrzo_conststring string_replacing,
			       lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (string_replacing==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_replacem_char((lcrzo_constdata)stringin, strlen(stringin),
				    searchcomplement, 
				    stringinstartpos, stringinendpos,
				    maxnumberofreplacement,
				    c_toreplace,
				    (lcrzo_constdata)string_replacing, strlen(string_replacing),
				    &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_replace_nchar(lcrzo_conststring stringin,
			       lcrzo_bool searchcomplement, 
			       lcrzo_int32 stringinstartpos,
			       lcrzo_int32 stringinendpos,
			       lcrzo_int32 maxnumberofreplacement,
			       lcrzo_conststring searchlist,
			       lcrzo_conststring string_replacing,
			       lcrzo_int32 stringoutmaxsize,
			       lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;

  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (searchlist==NULL) return(LCRZO_ERR_PANULLPTR);
  if (string_replacing==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_replace_nchar((lcrzo_constdata)stringin,
				    strlen(stringin),
				    searchcomplement, 
				    stringinstartpos, stringinendpos,
				    maxnumberofreplacement,
				    (lcrzo_constdata)searchlist, 
				    strlen(searchlist),
				    (lcrzo_constdata)string_replacing,
				    strlen(string_replacing),
				    stringoutmaxsize, 
				    (lcrzo_data)stringout, &dataoutsize));

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_replacem_nchar(lcrzo_conststring stringin,
				lcrzo_bool searchcomplement, 
				lcrzo_int32 stringinstartpos,
				lcrzo_int32 stringinendpos,
				lcrzo_int32 maxnumberofreplacement,
				lcrzo_conststring searchlist,
				lcrzo_conststring string_replacing,
				lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (searchlist==NULL) return(LCRZO_ERR_PANULLPTR);
  if (string_replacing==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_replacem_nchar((lcrzo_constdata)stringin,
				     strlen(stringin),
				     searchcomplement, 
				     stringinstartpos, stringinendpos,
				     maxnumberofreplacement,
				     (lcrzo_constdata)searchlist,
				     strlen(searchlist),
				     (lcrzo_constdata)string_replacing, 
				     strlen(string_replacing),
				     &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_replace_text(lcrzo_conststring stringin,
			      lcrzo_bool searchcomplement, 
			      lcrzo_int32 stringinstartpos,
			      lcrzo_int32 stringinendpos,
			      lcrzo_int32 maxnumberofreplacement,
			      lcrzo_conststring searchedtext,
			      lcrzo_conststring string_replacing,
			      lcrzo_int32 stringoutmaxsize,
			      lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;

  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (string_replacing==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_replace_text((lcrzo_constdata)stringin, strlen(stringin),
				   searchcomplement, 
				   stringinstartpos, stringinendpos,
				   maxnumberofreplacement,
				   searchedtext,
				   (lcrzo_constdata)string_replacing, strlen(string_replacing),
				   stringoutmaxsize, 
				   (lcrzo_data)stringout, &dataoutsize));

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_replacem_text(lcrzo_conststring stringin,
			       lcrzo_bool searchcomplement, 
			       lcrzo_int32 stringinstartpos,
			       lcrzo_int32 stringinendpos,
			       lcrzo_int32 maxnumberofreplacement,
			       lcrzo_conststring searchedtext,
			       lcrzo_conststring string_replacing,
			       lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (string_replacing==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_replacem_text((lcrzo_constdata)stringin, strlen(stringin),
				    searchcomplement, 
				    stringinstartpos, stringinendpos,
				    maxnumberofreplacement,
				    searchedtext,
				    (lcrzo_constdata)string_replacing, strlen(string_replacing),
				    &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_replace_re(lcrzo_conststring stringin,
			    lcrzo_bool searchcomplement, 
			    lcrzo_int32 stringinstartpos,
			    lcrzo_int32 stringinendpos,
			    lcrzo_int32 maxnumberofreplacement,
			    lcrzo_conststring regularexpression,
			    lcrzo_conststring string_replacing,
			    lcrzo_int32 stringoutmaxsize,
			    lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;

  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (string_replacing==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_replace_re((lcrzo_constdata)stringin, strlen(stringin),
				   searchcomplement, 
				   stringinstartpos, stringinendpos,
				   maxnumberofreplacement,
				   regularexpression,
				   (lcrzo_constdata)string_replacing, strlen(string_replacing),
				   stringoutmaxsize, 
				 (lcrzo_data)stringout, &dataoutsize));

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_replacem_re(lcrzo_conststring stringin,
			     lcrzo_bool searchcomplement, 
			     lcrzo_int32 stringinstartpos,
			     lcrzo_int32 stringinendpos,
			     lcrzo_int32 maxnumberofreplacement,
			     lcrzo_conststring regularexpression,
			     lcrzo_conststring string_replacing,
			     lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (string_replacing==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_replacem_re((lcrzo_constdata)stringin, strlen(stringin),
				    searchcomplement, 
				    stringinstartpos, stringinendpos,
				    maxnumberofreplacement,
				    regularexpression,
				    (lcrzo_constdata)string_replacing, strlen(string_replacing),
				    &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_replace_regexp(lcrzo_conststring stringin,
				lcrzo_bool searchcomplement, 
				lcrzo_int32 stringinstartpos,
				lcrzo_int32 stringinendpos,
				lcrzo_int32 maxnumberofreplacement,
				lcrzo_conststring regularexpression,
				lcrzo_conststring string_replacing,
				lcrzo_int32 stringoutmaxsize,
				lcrzo_string stringout)
{ lcrzo_int32 dataoutsize;

  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (string_replacing==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_replace_regexp((lcrzo_constdata)stringin, strlen(stringin),
				   searchcomplement, 
				   stringinstartpos, stringinendpos,
				   maxnumberofreplacement,
				   regularexpression,
				   (lcrzo_constdata)string_replacing, strlen(string_replacing),
				   stringoutmaxsize, 
				   (lcrzo_data)stringout, &dataoutsize));

  if (stringout!=NULL)
  { stringout[dataoutsize]='\0';
  }
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_string_replacem_regexp(lcrzo_conststring stringin,
				 lcrzo_bool searchcomplement, 
				 lcrzo_int32 stringinstartpos,
				 lcrzo_int32 stringinendpos,
				 lcrzo_int32 maxnumberofreplacement,
				 lcrzo_conststring regularexpression,
				 lcrzo_conststring string_replacing,
				 lcrzo_string *pstringout)
{ lcrzo_data ptr;
  lcrzo_int32 dataoutsize;
  
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  if (string_replacing==NULL) return(LCRZO_ERR_PANULLPTR);
  lcrzo_er(lcrzo_data_replacem_re((lcrzo_constdata)stringin, strlen(stringin),
				    searchcomplement, 
				    stringinstartpos, stringinendpos,
				    maxnumberofreplacement,
				    regularexpression,
				    (lcrzo_constdata)string_replacing, strlen(string_replacing),
				    &ptr, &dataoutsize));

  if (pstringout!=NULL) 
  { ptr[dataoutsize]='\0';
    *pstringout=(lcrzo_string)ptr;
  }
  else lcrzo_data_free(ptr);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzo_hexa_init_string(lcrzo_conststring stringin,
			   lcrzo_int32 hexaoutmaxsize,
			   lcrzo_string hexaout)
{ 
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_hexa_init_data((lcrzo_constdata)stringin, strlen(stringin),
			      hexaoutmaxsize, hexaout));
}

/*-------------------------------------------------------------*/
int lcrzo_hexa_initm_string(lcrzo_conststring stringin,
			    lcrzo_string *phexaout)
{ 
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_hexa_initm_data((lcrzo_constdata)stringin, strlen(stringin), phexaout));
}

/*-------------------------------------------------------------*/
int lcrzo_mixed_init_string(lcrzo_conststring stringin,
			    lcrzo_int32 mixedoutmaxsize,
			    lcrzo_string mixedout)
{ 
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_mixed_init_data((lcrzo_constdata)stringin, strlen(stringin),
			       mixedoutmaxsize, mixedout));
}

/*-------------------------------------------------------------*/
int lcrzo_mixed_initm_string(lcrzo_conststring stringin,
			     lcrzo_string *pmixedout)
{ 
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_mixed_initm_data((lcrzo_constdata)stringin, strlen(stringin), pmixedout));
}

/*-------------------------------------------------------------*/
int lcrzo_base64_init_string(lcrzo_conststring stringin,
			     lcrzo_int32 base64outmaxsize,
			     lcrzo_string base64out)
{ 
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_base64_init_data((lcrzo_constdata)stringin, strlen(stringin),
				base64outmaxsize, base64out));
}

/*-------------------------------------------------------------*/
int lcrzo_base64_initm_string(lcrzo_conststring stringin,
			      lcrzo_string *pbase64out)
{ 
  if (stringin==NULL) return(LCRZO_ERR_PANULLPTR);
  return(lcrzo_base64_initm_data((lcrzo_constdata)stringin, strlen(stringin), pbase64out));
}
