/*us    Laurent Constantin's network library (lcrzo)
                 lcrzo_string module

  Functions herein allow to work on strings.
*/
/*fr    Bibliotheque reseau de Laurent Constantin (lcrzo)
                 Module lcrzo_string

  Les fonctions presentes dans ce module gerent le traitement
de chaines de caracteres.
*/

/*-------------------------------------------------------------*/
/*US*******************************************
 * Note about sizes :                         *
 *   sizes are always in bytes                *
 **********************************************/
/*FR*******************************************
 * Note sur les tailles :                     *
 *   les tailles sont toujours en octet       *
 **********************************************/

/*-------------------------------------------------------------*/
int lcrzo_string_alloc(lcrzo_int32 allocsize, lcrzo_string *pptr);
int lcrzo_string_realloc(lcrzo_int32 newallocsize, lcrzo_string *pptr);
int lcrzo_string_free(lcrzo_string ptr);

/*-------------------------------------------------------------*/
/*US*******************************************
 * Note about indexes :                       *
 * Indexes permit to access range of data.    *
 * For example, if we have a 4 bytes data,    *
 * containing 'ABCD', we can represent it     *
 * like this :                                *
 *       +---+---+---+---+---+                * 
 *       | A | B | C | D | \0|                *
 *       +---+---+---+---+---+                *
 * The indexes are associated with the        *
 * corners :                                  *
 *       1   2   3   4   5                    *
 *      -5  -4  -3  -2  -1                    *
 * So :                                       *
 *   range [1,5]   is 'ABCD'                  * 
 *   range [2,3]   is 'B'                     *
 *   range [3,3]   is ''     (empty array)    *
 *   range [1,-1]  is 'ABCD'                  *
 *   range [2,-3]  is 'B'                     *
 *   range [3,1]   is 'BA'                    *
 *   range [-1,1]  is 'DCBA'                  *
 *   range [-2,-3] is 'C'                     *
 *   etc.                                     *
 * Note : 0 (zero) is an invalid index        *
 **********************************************/
/*FR*******************************************
 * Note sur les indices :                     *
 * Les indices permettent d'acceder a des     *
 * intervalles de donnees.                    *
 * Par exemple, si on a 4 octets de donnees   *
 * contenant 'ABCD', on peut les representer  *
 * ainsi :                                    *
 *       +---+---+---+---+---+                * 
 *       | A | B | C | D | \0|                *
 *       +---+---+---+---+---+                *
 * Les indices sont associes avec les         *
 * angles :                                   *
 *       1   2   3   4   5                    *
 *      -5  -4  -3  -2  -1                    *
 * Donc :                                     *
 *   intervalle [1,5]   est 'ABCD'            * 
 *   intervalle [2,3]   est 'B'               *
 *   intervalle [3,3]   est '' (tableau vide) *
 *   intervalle [1,-1]  est 'ABCD'            *
 *   intervalle [2,-3]  est 'B'               *
 *   intervalle [3,1]   est 'BA'              *
 *   intervalle [-1,1]  est 'DCBA'            *
 *   intervalle [-2,-3] est 'C'               *
 *   etc.                                     *
 * Note : l'indice 0 (zero) est invalide      *
 **********************************************/

/*---------------------------------------------------------------*/
/*us functions in this module have the same meaning
   than those in the lcrzo_data module (except they work
   on strings).
   In a next version of lcrzo, I'll take time to comment this
   Module.
*/
/*fr les fonctions de ce module ont le meme comportement
   que celles du module lcrzo_data (excepte qu'elles 
   travaillent sur des chaines de caracteres).
   Dans une prochaine version de lcrzo, je prendrai le temps
   de commenter ce module.
*/

/*---------------------------------------------------------------*/
int lcrzo_string_init_data(lcrzo_constdata datain,
			   lcrzo_int32 datainsize,
			   lcrzo_int32 stringoutmaxsize,
			   lcrzo_string stringout);
int lcrzo_string_initm_data(lcrzo_constdata datain,
			    lcrzo_int32 datainsize,
			    lcrzo_string *pstringout);
int lcrzo_string_append_data(lcrzo_constdata datain,
			     lcrzo_int32 datainsize,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout);
int lcrzo_string_appendm_data(lcrzo_constdata datain,
			      lcrzo_int32 datainsize,
			      lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_range(lcrzo_conststring stringin,
			    lcrzo_int32 stringinstartpos,
			    lcrzo_int32 stringinendpos,
			    lcrzo_int32 stringoutmaxsize,
			    lcrzo_string stringout);
int lcrzo_string_initm_range(lcrzo_conststring stringin,
			     lcrzo_int32 stringinstartpos,
			     lcrzo_int32 stringinendpos,
			     lcrzo_string *pstringout);
int lcrzo_string_append_range(lcrzo_conststring stringin,
			      lcrzo_int32 stringinstartpos,
			      lcrzo_int32 stringinendpos,
			      lcrzo_int32 stringoutmaxsize,
			      lcrzo_string stringout);
int lcrzo_string_appendm_range(lcrzo_conststring stringin,
			       lcrzo_int32 stringinstartpos,
			       lcrzo_int32 stringinendpos,
			       lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_fill(lcrzo_conststring stringin,
			   lcrzo_int32 fillingsize,
			   lcrzo_int32 stringoutmaxsize,
			   lcrzo_string stringout);
int lcrzo_string_initm_fill(lcrzo_conststring stringin,
			    lcrzo_int32 fillingsize,
			    lcrzo_string *pstringout);
int lcrzo_string_append_fill(lcrzo_conststring stringin,
			     lcrzo_int32 fillingsize,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout);
int lcrzo_string_appendm_fill(lcrzo_conststring stringin,
			      lcrzo_int32 fillingsize,
			      lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_char(lcrzo_uint8 c,
			   lcrzo_int32 fillingsize,
			   lcrzo_int32 stringoutmaxsize,
			   lcrzo_string stringout);
int lcrzo_string_initm_char(lcrzo_uint8 c,
			    lcrzo_int32 fillingsize,
			    lcrzo_string *pstringout);
int lcrzo_string_append_char(lcrzo_uint8 c,
			     lcrzo_int32 fillingsize,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout);
int lcrzo_string_appendm_char(lcrzo_uint8 c,
			      lcrzo_int32 fillingsize,
			      lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_rand(lcrzo_uint8 minvalue,
			   lcrzo_uint8 maxvalue,
			   lcrzo_int32 fillingsize,
			   lcrzo_int32 stringoutmaxsize,
			   lcrzo_string stringout);
int lcrzo_string_initm_rand(lcrzo_uint8 minvalue,
			    lcrzo_uint8 maxvalue,
			    lcrzo_int32 fillingsize,
			    lcrzo_string *pstringout);
int lcrzo_string_append_rand(lcrzo_uint8 minvalue,
			     lcrzo_uint8 maxvalue,
			     lcrzo_int32 fillingsize,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout);
int lcrzo_string_appendm_rand(lcrzo_uint8 minvalue,
			      lcrzo_uint8 maxvalue,
			      lcrzo_int32 fillingsize,
			      lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_int(lcrzo_int32 integer,
			  const char * format,
			  lcrzo_int32 stringoutmaxsize,
			  lcrzo_string stringout);
int lcrzo_string_initm_int(lcrzo_int32 integer,
			   const char * format,
			   lcrzo_string *pstringout);
int lcrzo_string_append_int(lcrzo_int32 integer,
			    const char * format,
			    lcrzo_int32 stringoutmaxsize,
			    lcrzo_string stringout);
int lcrzo_string_appendm_int(lcrzo_int32 integer,
			     const char * format,
			     lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_text(const char * text,
			   lcrzo_int32 stringoutmaxsize,
			   lcrzo_string stringout);
int lcrzo_string_initm_text(const char * text,
			    lcrzo_string *pstringout);
int lcrzo_string_append_text(const char * text,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout);
int lcrzo_string_appendm_text(const char * text,
			      lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_coretext(const char * text,
			       lcrzo_int32 stringoutmaxsize,
			       lcrzo_string stringout);
int lcrzo_string_initm_coretext(const char * text,
				lcrzo_string *pstringout);
int lcrzo_string_append_coretext(const char * text,
				 lcrzo_int32 stringoutmaxsize,
				 lcrzo_string stringout);
int lcrzo_string_appendm_coretext(const char * text,
				  lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_hexa(const char * hexa,
			   lcrzo_int32 stringoutmaxsize,
			   lcrzo_string stringout);
int lcrzo_string_initm_hexa(const char * hexa,
			    lcrzo_string *pstringout);
int lcrzo_string_append_hexa(const char * hexa,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout);
int lcrzo_string_appendm_hexa(const char * hexa,
			      lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_mixed(const char * mixed,
			    lcrzo_int32 stringoutmaxsize,
			    lcrzo_string stringout);
int lcrzo_string_initm_mixed(const char * mixed,
			     lcrzo_string *pstringout);
int lcrzo_string_append_mixed(const char * mixed,
			      lcrzo_int32 stringoutmaxsize,
			      lcrzo_string stringout);
int lcrzo_string_appendm_mixed(const char * mixed,
			       lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_base64(const char * base64,
			     lcrzo_int32 stringoutmaxsize,
			     lcrzo_string stringout);
int lcrzo_string_initm_base64(const char * base64,
			      lcrzo_string *pstringout);
int lcrzo_string_append_base64(const char * base64,
			       lcrzo_int32 stringoutmaxsize,
			       lcrzo_string stringout);
int lcrzo_string_appendm_base64(const char * base64,
				lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_text_stdin(const char * message,
				 const char * defaulttext,
				 lcrzo_int32 stringoutmaxsize,
				 lcrzo_string stringout);
int lcrzo_string_initm_text_stdin(const char * message,
				  const char * defaulttext,
				  lcrzo_string *pstringout);
int lcrzo_string_append_text_stdin(const char * message,
				   const char * defaulttext,
				   lcrzo_int32 stringoutmaxsize,
				   lcrzo_string stringout);
int lcrzo_string_appendm_text_stdin(const char * message,
				    const char * defaulttext,
				    lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_coretext_stdin(const char * message,
				     const char * defaultcoretext,
				     lcrzo_int32 stringoutmaxsize,
				     lcrzo_string stringout);
int lcrzo_string_initm_coretext_stdin(const char * message,
				      const char * defaultcoretext,
				      lcrzo_string *pstringout);
int lcrzo_string_append_coretext_stdin(const char * message,
				       const char * defaultcoretext,
				       lcrzo_int32 stringoutmaxsize,
				       lcrzo_string stringout);
int lcrzo_string_appendm_coretext_stdin(const char * message,
					const char * defaultcoretext,
					lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_text_passwd(const char * message,
				  const char * defaulttext,
				  lcrzo_int32 stringoutmaxsize,
				  lcrzo_string stringout);
int lcrzo_string_initm_text_passwd(const char * message,
				   const char * defaulttext,
				   lcrzo_string *pstringout);
int lcrzo_string_append_text_passwd(const char * message,
				    const char * defaulttext,
				    lcrzo_int32 stringoutmaxsize,
				    lcrzo_string stringout);
int lcrzo_string_appendm_text_passwd(const char * message,
				     const char * defaulttext,
				     lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_coretext_passwd(const char * message,
				      const char * defaultcoretext,
				      lcrzo_int32 stringoutmaxsize,
				      lcrzo_string stringout);
int lcrzo_string_initm_coretext_passwd(const char * message,
				       const char * defaultcoretext,
				       lcrzo_string *pstringout);
int lcrzo_string_append_coretext_passwd(const char * message,
					const char * defaultcoretext,
					lcrzo_int32 stringoutmaxsize,
					lcrzo_string stringout);
int lcrzo_string_appendm_coretext_passwd(const char * message,
					 const char * defaultcoretext,
					 lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_hexa_stdin(const char * message,
				 const char * defaulthexa,
				 lcrzo_int32 stringoutmaxsize,
				 lcrzo_string stringout);
int lcrzo_string_initm_hexa_stdin(const char * message,
				  const char * defaulthexa,
				  lcrzo_string *pstringout);
int lcrzo_string_append_hexa_stdin(const char * message,
				   const char * defaulthexa,
				   lcrzo_int32 stringoutmaxsize,
				   lcrzo_string stringout);
int lcrzo_string_appendm_hexa_stdin(const char * message,
				    const char * defaulthexa,
				    lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_mixed_stdin(const char * message,
				  const char * defaultmixed,
				  lcrzo_int32 stringoutmaxsize,
				  lcrzo_string stringout);
int lcrzo_string_initm_mixed_stdin(const char * message,
				   const char * defaultmixed,
				   lcrzo_string *pstringout);
int lcrzo_string_append_mixed_stdin(const char * message,
				    const char * defaultmixed,
				    lcrzo_int32 stringoutmaxsize,
				    lcrzo_string stringout);
int lcrzo_string_appendm_mixed_stdin(const char * message,
				     const char * defaultmixed,
				     lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_init_base64_stdin(const char * message,
				   const char * defaultbase64,
				   lcrzo_int32 stringoutmaxsize,
				   lcrzo_string stringout);
int lcrzo_string_initm_base64_stdin(const char * message,
				    const char * defaultbase64,
				    lcrzo_string *pstringout);
int lcrzo_string_append_base64_stdin(const char * message,
				     const char * defaultbase64,
				     lcrzo_int32 stringoutmaxsize,
				     lcrzo_string stringout);
int lcrzo_string_appendm_base64_stdin(const char * message,
				      const char * defaultbase64,
				      lcrzo_string *pstringout);

/*-------------------------------------------------------------*/
int lcrzo_string_search_char(lcrzo_conststring stringin,
			     lcrzo_bool searchcomplement, 
			     lcrzo_int32 stringinstartpos,
			     lcrzo_int32 stringinendpos,
			     lcrzo_uint8 c,
			     lcrzo_int32 *pfoundposition_negative,
			     lcrzo_int32 *pfoundposition_positive);
int lcrzo_string_search_nchar(lcrzo_conststring stringin,
			      lcrzo_bool searchcomplement, 
			      lcrzo_int32 stringinstartpos,
			      lcrzo_int32 stringinendpos,
			      lcrzo_conststring searchlist,
			      lcrzo_int32 *pfoundposition_negative,
			      lcrzo_int32 *pfoundposition_positive);
int lcrzo_string_search_text(lcrzo_conststring stringin,
			     lcrzo_bool searchcomplement, 
			     lcrzo_int32 stringinstartpos,
			     lcrzo_int32 stringinendpos,
			     lcrzo_conststring searchedtext,
			     lcrzo_int32 *pstartfoundposition_negative,
			     lcrzo_int32 *pstartfoundposition_positive,
			     lcrzo_int32 *pendfoundposition_negative,
			     lcrzo_int32 *pendfoundposition_positive);
int lcrzo_string_search_re(lcrzo_conststring stringin,
			   lcrzo_bool searchcomplement, 
			   lcrzo_int32 stringinstartpos,
			   lcrzo_int32 stringinendpos,
			   lcrzo_conststring regularexpression,
			   lcrzo_int32 *pstartfoundposition_negative,
			   lcrzo_int32 *pstartfoundposition_positive,
			   lcrzo_int32 *pendfoundposition_negative,
			   lcrzo_int32 *pendfoundposition_positive);
int lcrzo_string_search_regexp(lcrzo_conststring stringin,
			       lcrzo_bool searchcomplement, 
			       lcrzo_int32 stringinstartpos,
			       lcrzo_int32 stringinendpos,
			       lcrzo_conststring regularexpression,
			       lcrzo_regexp arrayfoundpos);

/*-------------------------------------------------------------*/
int lcrzo_string_token_char(lcrzo_conststring stringin,
			    lcrzo_bool searchcomplement, 
			    lcrzo_int32 stringinstartpos,
			    lcrzo_int32 stringinendpos,
			    lcrzo_uint8 c,
			    lcrzo_int32 *ppositionindicator,
			    lcrzo_int32 *pstartfoundposition_negative,
			    lcrzo_int32 *pstartfoundposition_positive,
			    lcrzo_int32 *pendfoundposition_negative,
			    lcrzo_int32 *pendfoundposition_positive);
int lcrzo_string_token_nchar(lcrzo_conststring stringin,
			     lcrzo_bool searchcomplement, 
			     lcrzo_int32 stringinstartpos,
			     lcrzo_int32 stringinendpos,
			     lcrzo_conststring searchlist,
			     lcrzo_int32 *ppositionindicator,
			     lcrzo_int32 *pstartfoundposition_negative,
			     lcrzo_int32 *pstartfoundposition_positive,
			     lcrzo_int32 *pendfoundposition_negative,
			     lcrzo_int32 *pendfoundposition_positive);
int lcrzo_string_token_text(lcrzo_conststring stringin,
			    lcrzo_bool searchcomplement, 
			    lcrzo_int32 stringinstartpos,
			    lcrzo_int32 stringinendpos,
			    lcrzo_conststring searchedtext,
			    lcrzo_int32 *ppositionindicator,
			    lcrzo_int32 *pstartfoundposition_negative,
			    lcrzo_int32 *pstartfoundposition_positive,
			    lcrzo_int32 *pendfoundposition_negative,
			    lcrzo_int32 *pendfoundposition_positive);
int lcrzo_string_token_re(lcrzo_conststring stringin,
			  lcrzo_bool searchcomplement, 
			  lcrzo_int32 stringinstartpos,
			  lcrzo_int32 stringinendpos,
			  lcrzo_conststring regularexpression,
			  lcrzo_int32 *ppositionindicator,
			  lcrzo_int32 *pstartfoundposition_negative,
			  lcrzo_int32 *pstartfoundposition_positive,
			  lcrzo_int32 *pendfoundposition_negative,
			  lcrzo_int32 *pendfoundposition_positive);

/*-------------------------------------------------------------*/
int lcrzo_string_replace_char(lcrzo_conststring stringin,
			      lcrzo_bool searchcomplement, 
			      lcrzo_int32 stringinstartpos,
			      lcrzo_int32 stringinendpos,
			      lcrzo_int32 maxnumberofreplacement,
			      lcrzo_uint8 c_toreplace,
			      lcrzo_conststring string_replacing,
			      lcrzo_int32 stringoutmaxsize,
			      lcrzo_string stringout);
int lcrzo_string_replacem_char(lcrzo_conststring stringin,
			       lcrzo_bool searchcomplement, 
			       lcrzo_int32 stringinstartpos,
			       lcrzo_int32 stringinendpos,
			       lcrzo_int32 maxnumberofreplacement,
			       lcrzo_uint8 c_toreplace,
			       lcrzo_conststring string_replacing,
			       lcrzo_string *pstringout);

int lcrzo_string_replace_nchar(lcrzo_conststring stringin,
			       lcrzo_bool searchcomplement, 
			       lcrzo_int32 stringinstartpos,
			       lcrzo_int32 stringinendpos,
			       lcrzo_int32 maxnumberofreplacement,
			       lcrzo_conststring searchlist,
			       lcrzo_conststring string_replacing,
			       lcrzo_int32 stringoutmaxsize,
			       lcrzo_string stringout);
int lcrzo_string_replacem_nchar(lcrzo_conststring stringin,
				lcrzo_bool searchcomplement, 
				lcrzo_int32 stringinstartpos,
				lcrzo_int32 stringinendpos,
				lcrzo_int32 maxnumberofreplacement,
				lcrzo_conststring searchlist,
				lcrzo_conststring string_replacing,
				lcrzo_string *pstringout);

int lcrzo_string_replace_text(lcrzo_conststring stringin,
			      lcrzo_bool searchcomplement, 
			      lcrzo_int32 stringinstartpos,
			      lcrzo_int32 stringinendpos,
			      lcrzo_int32 maxnumberofreplacement,
			      lcrzo_conststring searchedtext,
			      lcrzo_conststring string_replacing,
			      lcrzo_int32 stringoutmaxsize,
			      lcrzo_string stringout);
int lcrzo_string_replacem_text(lcrzo_conststring stringin,
			       lcrzo_bool searchcomplement, 
			       lcrzo_int32 stringinstartpos,
			       lcrzo_int32 stringinendpos,
			       lcrzo_int32 maxnumberofreplacement,
			       lcrzo_conststring searchedtext,
			       lcrzo_conststring string_replacing,
			       lcrzo_string *pstringout);

int lcrzo_string_replace_re(lcrzo_conststring stringin,
			    lcrzo_bool searchcomplement, 
			    lcrzo_int32 stringinstartpos,
			    lcrzo_int32 stringinendpos,
			    lcrzo_int32 maxnumberofreplacement,
			    lcrzo_conststring regularexpression,
			    lcrzo_conststring string_replacing,
			    lcrzo_int32 stringoutmaxsize,
			    lcrzo_string stringout);
int lcrzo_string_replacem_re(lcrzo_conststring stringin,
			     lcrzo_bool searchcomplement, 
			     lcrzo_int32 stringinstartpos,
			     lcrzo_int32 stringinendpos,
			     lcrzo_int32 maxnumberofreplacement,
			     lcrzo_conststring regularexpression,
			     lcrzo_conststring string_replacing,
			     lcrzo_string *pstringout);

int lcrzo_string_replace_regexp(lcrzo_conststring stringin,
				lcrzo_bool searchcomplement, 
				lcrzo_int32 stringinstartpos,
				lcrzo_int32 stringinendpos,
				lcrzo_int32 maxnumberofreplacement,
				lcrzo_conststring regularexpression,
				lcrzo_conststring string_replacing,
				lcrzo_int32 stringoutmaxsize,
				lcrzo_string stringout);
int lcrzo_string_replacem_regexp(lcrzo_conststring stringin,
				 lcrzo_bool searchcomplement, 
				 lcrzo_int32 stringinstartpos,
				 lcrzo_int32 stringinendpos,
				 lcrzo_int32 maxnumberofreplacement,
				 lcrzo_conststring regularexpression,
				 lcrzo_conststring string_replacing,
				 lcrzo_string *pstringout);

/*---------------------------------------------------------------*/
int lcrzo_hexa_init_string(lcrzo_conststring stringin,
			   lcrzo_int32 hexaoutmaxsize,
			   lcrzo_string hexaout);
int lcrzo_hexa_initm_string(lcrzo_conststring stringin,
			    lcrzo_string *phexaout);

int lcrzo_mixed_init_string(lcrzo_conststring stringin,
			    lcrzo_int32 mixedoutmaxsize,
			    lcrzo_string mixedout);
int lcrzo_mixed_initm_string(lcrzo_conststring stringin,
			     lcrzo_string *pmixedout);

int lcrzo_base64_init_string(lcrzo_conststring stringin,
			     lcrzo_int32 base64outmaxsize,
			     lcrzo_string base64out);
int lcrzo_base64_initm_string(lcrzo_conststring stringin,
			      lcrzo_string *pbase64out);
