/*us    Laurent Constantin's network library (lcrzo)
                 lcrzo_sysdep module

  Functions herein contains system dependant functions.
*/
/*fr    Bibliotheque reseau de Laurent Constantin (lcrzo)
                 Module lcrzo_sysdep

  Les fonctions presentes dans ce module contiennent les fonctions
dependantes du systeme.
*/


/*-------------------------------------------------------------*/
int lcrzo_sysdep_conf_init_dev(void);
int lcrzo_sysdep_conf_init_arpcache(void);
int lcrzo_sysdep_conf_init_rarpcache(void);
int lcrzo_sysdep_conf_init_routes(void);

/*-------------------------------------------------------------*/
int lcrzo_sysdep_etha_init_ipa_ioctlarp(const lcrzo_ipa ipa, 
					lcrzo_etha etha);
int lcrzo_sysdep_etha_init_ipa_etcethers(const lcrzo_ipa ipa, 
					 lcrzo_etha etha);
int lcrzo_sysdep_ipa_init_etha_ioctlrarp(const lcrzo_etha etha, 
					 lcrzo_ipa ipa);
int lcrzo_sysdep_ipa_init_etha_etcethers(const lcrzo_etha etha, 
					 lcrzo_ipa ipa);


/*-------------------------------------------------------------*/
#define LCRZO_PRIV_SPOOF_TYPE_NONE 0
#define LCRZO_PRIV_SPOOF_TYPE_ETH  1
#define LCRZO_PRIV_SPOOF_TYPE_IP   2

int lcrzo_sysdep_spoof_init_eth(lcrzo_spoof *pspoof);
int lcrzo_sysdep_spoof_init_ip(lcrzo_spoof *pspoof);

int lcrzo_sysdep_spoof_close_eth(lcrzo_spoof *pspoof);
int lcrzo_sysdep_spoof_close_ip(lcrzo_spoof *pspoof);

int lcrzo_sysdep_spoof_eth(lcrzo_spoof *pspoof,
			   const lcrzo_device device, 
			   lcrzo_constdata packet, 
			   lcrzo_int32 nboctpacket);
int lcrzo_sysdep_spoof_ip(lcrzo_spoof *pspoof,
			  lcrzo_constdata packet,
			  lcrzo_int32 nboctpacket);

/*-------------------------------------------------------------*/
int lcrzo_sysdep_print_cpuall(void);
int lcrzo_sysdep_print_memall(void);
int lcrzo_sysdep_print_cpupid(int pid);
int lcrzo_sysdep_print_mempid(int pid);
int lcrzo_sysdep_print_mempidcurrent(void);
int lcrzo_sysdep_print_cpupidcurrent(void);
int lcrzo_sysdep_print_memcpuall(void);
int lcrzo_sysdep_print_memcpupid(int pid);
int lcrzo_sysdep_print_memcpupidcurrent(void);
int lcrzo_sysdep_print_memcpuallpid(int pid);
int lcrzo_sysdep_print_memcpuallpidcurrent(void);
