/*
		                  LCRZO
                             Network library
             Copyright(c) 1999,2000,2001, Laurent Constantin
                                  -----

  Main server    : http://www.laurentconstantin.com/
  Backup servers : http://go.to/laurentconstantin/
                   http://laurentconstantin.est-la.com/
  [my current email address is on the web servers]

                                  -----
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details (http://www.gnu.org).

------------------------------------------------------------------------
*/

/* -- Note about comments and variable names --
   In versions 1.00 up to 2.08, lcrzo was only written in French (my
   mother tongue). Since version 3.00, lcrzo is written in English, but
   most of comments and variable names are still in French.
   In future versions, I'll try to translate everything into English,
   but as you may guess, that's a quite big work...
   So, for the moment, here are some word translation, if you want to
   be able to understand what's going on in the functions :
     afficher - print     ;  ajouter - add         ;  copie - copy
     dernier - last       ;  donnee - data         ;  ecrire - write
     entete - header      ;  envoye - sent         ;  ferme - close
     fichier - file       ;  lire - read           ;  masque - mask 
     nboct - byte number  ;  ouvre, ouvrir - open  ;  paq, paquet - packet
     plage - range        ;  premier - first       ;  recu - received
     reseau - network     ;  retour - return       ;  taille - size
     tunnel - pipe

*/

#include "lcrzo_priv.h"
#ifdef LCRZODEF_SYSTEM_Linux
 #include <stdlib.h>
#elif defined LCRZODEF_SYSTEM_FreeBSD
 #include <stdlib.h>
#elif defined LCRZODEF_SYSTEM_Solaris
 #include <stdlib.h>
#else
 #error "Traiter le cas de LCRZODEF_SYSTEM"
#endif


/*---------------------------------------------------------------*/
int lcrzo_tcpopt_init_mixed(const char * mixed,
			    lcrzo_tcpopt tcpopt,
			    lcrzo_uint8 *ptcpoptsize)
{ lcrzo_int32 tcpoptsize;

  lcrzo_er(lcrzo_data_init_mixed(mixed, LCRZO_TCPOPT_MAXBYTES,
                                 tcpopt, &tcpoptsize));
  if (ptcpoptsize!=NULL) *ptcpoptsize=(lcrzo_uint8)tcpoptsize;
  return(LCRZO_ERR_OK);
}

/*---------------------------------------------------------------*/
int lcrzo_tcpopt_stdin(const char * message,
		       const char * defaultmixed,
		       lcrzo_tcpopt tcpopt,
		       lcrzo_uint8 *ptcpoptsize)
{ lcrzo_int32 n;

  n=1;
  while (n%4)
  { lcrzo_er(lcrzo_data_init_mixed_stdin(message, defaultmixed,
                                         LCRZO_TCPOPT_MAXBYTES, tcpopt, &n));
  }
  if (ptcpoptsize!=NULL) *ptcpoptsize=(lcrzo_uint8)n;

  return(LCRZO_ERR_OK);
}
