/*us    Laurent Constantin's network library (lcrzo)
                 lcrzo_time module

  Functions herein allow to measure time.
*/
/*fr    Bibliotheque reseau de Laurent Constantin (lcrzo)
                 Module lcrzo_time

  Les fonctions presentes dans ce module assurent la gestion
du temps.
*/

/*---------------------------------------------------------------*/
/*us the definition of a lcrzo_time has to be public
   (because the compiler needs to know its size), 
   but you should not use its fields directly. */
/*fr la definition d'un lcrzo_time doit etre publique
   (car le compilateur doit connaitre sa taille), mais vous
   ne devriez pas utiliser directement ses champs. */
typedef struct
{ lcrzo_uint32 sec;
  lcrzo_uint32 usec;
} lcrzo_time;

/*---------------------------------------------------------------*/
/*us Name : lcrzo_time_fprint
   Description :
     Print a lcrzo_time.
   Input parameter(s) :
     *pf : FILE where the function prints
     startstring : string to print before the lcrzo_time
     time : lcrzo_time to print
     endstring : string to print after the lcrzo_time
   Input/output parameter(s) :
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_time_fprint
   Description :
     Ecrit un lcrzo_time.
   Parametre(s) d'entree :
     *pf : FILE ou la fonction doit ecrire
     startstring : chaine a ecrire avant le lcrzo_time
     time : lcrzo_time a ecrire
     endstring : chaine a ecrire apres le lcrzo_time
   Parametre(s) d'entree-sortie :
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_time_fprint(LCRZOFILE *pf,
		      const char *startstring,
		      lcrzo_time time,
		      const char *endstring);

/*us idem, but on stdout */
/*fr idem, mais sur stdout */
#define lcrzo_time_print(d,h,f) lcrzo_time_fprint(stdout, d, h, f)

/*---------------------------------------------------------------*/
/*us Name : lcrzo_time_init
   Description :
     Initialize a lcrzo_time.
   Input parameter(s) :
   Input/output parameter(s) :
   Output parameter(s) :
     *ptime : lcrzo_time set to the current time
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_time_init
   Description :
     Initialise un lcrzo_time.
   Parametre(s) d'entree :
   Parametre(s) d'entree-sortie :
   Parametre(s) de sortie :
     *ptime : lcrzo_time affecte a l'heure courante
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_time_init(lcrzo_time *ptime);

/*us Name : lcrzo_time_initfprint
   Description :
     Initialize a lcrzo_time, and print it.
   Input parameter(s) :
     *pf : FILE where the function prints
     startstring : string to print before the lcrzo_time
     endstring : string to print after the lcrzo_time
   Input/output parameter(s) :
   Output parameter(s) :
     *ptime : lcrzo_time set to the current time
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_time_initfprint
   Description :
     Initialise un lcrzo_time et l'affiche.
   Parametre(s) d'entree :
     *pf : FILE ou la fonction doit ecrire
     startstring : chaine a ecrire avant le lcrzo_time
     endstring : chaine a ecrire apres le lcrzo_time
   Parametre(s) d'entree-sortie :
   Parametre(s) de sortie :
     *ptime : lcrzo_time affecte a l'heure courante
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_time_initfprint(LCRZOFILE *pf,
			  const char *startstring,
			  const char *endstring,
			  lcrzo_time *ptime);

/*us idem, but on stdout */
/*fr idem, mais sur stdout */
#define lcrzo_time_initprint(d,f,h) lcrzo_time_initfprint(stdout, d, f, h)

/*---------------------------------------------------------------*/
/*us Name : lcrzo_time_diff
   Description :
     Compare a lcrzo_time to the current time.
   Input parameter(s) :
     time : lcrzo_time to compare to the current time
   Input/output parameter(s) :
   Output parameter(s) :
     *psec : number of seconds between the two times
     *pusec : number of microseconds between the two times
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_time_diff
   Description :
     Compare un lcrzo_time a l'heure courante.
   Parametre(s) d'entree :
     time : lcrzo_time a comparer a l'heure courante
   Parametre(s) d'entree-sortie :
   Parametre(s) de sortie :
     *psec : nombre de secondes entre les deux heures
     *pusec : nombre de microsecondes entre les deux heures
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_time_diff(lcrzo_time time,
		    lcrzo_uint32 *psec,
		    lcrzo_uint32 *pusec);

/*us Name : lcrzo_time_diffprint
   Description :
     Compare a lcrzo_time to the current time, and print the 
     difference.
   Input parameter(s) :
     *pf : FILE where the function prints
     startstring : string to print before the lcrzo_time
     time : lcrzo_time to compare to the current time
     endstring : string to print after the lcrzo_time
   Input/output parameter(s) :
   Output parameter(s) :
     *psec : number of seconds between the two times
     *pusec : number of microseconds between the two times
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_time_difffprint
   Description :
     Compare un lcrzo_time a l'heure courante et affiche
     la difference.
   Parametre(s) d'entree :
     *pf : FILE ou la fonction doit ecrire
     startstring : chaine a ecrire avant le lcrzo_time
     time : lcrzo_time a comparer a l'heure courante
     endstring : chaine a ecrire apres le lcrzo_time
   Parametre(s) d'entree-sortie :
   Parametre(s) de sortie :
     *psec : nombre de secondes entre les deux heures
     *pusec : nombre de microsecondes entre les deux heures
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_time_difffprint(LCRZOFILE *pf,
			   const char *startstring,
			   lcrzo_time time,
			   const char *endstring,
			   lcrzo_uint32 *psec,
			   lcrzo_uint32 *pusec);

/*us idem, but on stdout */
/*fr idem, mais sur stdout */
#define lcrzo_time_diffprint(d,f,h,s,u) lcrzo_time_difffprint(stdout, d,f,h,s,u)

/*---------------------------------------------------------------*/
/*us Name : lcrzo_time_sleep
   Description :
     Wait for a number a microseconds.
   Input parameter(s) :
     usec : number of microseconds to wait
   Input/output parameter(s) :
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_time_sleep
   Description :
     Attend usec microsecondes
   Parametre(s) d'entree :
     usec : nombre de microsecondes a attendre
   Parametre(s) d'entree-sortie :
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_time_sleep(lcrzo_uint32 usec);

