
/* include the library headers */
#include <lcrzo.h>
#include <stdio.h>

/* set information about this example */
lcrzoex_infos lcrzoex_000002=
{ /*reference*/     "lcrzoex", 2, 
  /*version*/       1, 2, 
  /*title*/         "print informations about a hostname", 
  /*french title*/  "affiche les informations sur un nom de machine", 
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "computer_name",
  /*french usage*/  "nom_de_machine", 
  /*usage example*/ "www.example.com",
  /*fr. usage ex.*/ "www.exemple.com", 
  /*author*/        "Laurent"
};

/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000002_main(int argc, char *argv[]);
int lcrzoex_000002_main(int argc, char *argv[])
{ lcrzo_hs hs;
  lcrzo_ipl ipl;
  lcrzo_eths eths;
  lcrzo_bool knowipaddress, knowethaddress;
  int ret, language;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000002, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /*we have 3 seconds to resolv the hostname*/
  lcrzo_epr(lcrzo_global_set_resolver_timeout(3));

  /*all the following is equivalent to this function call
    lcrzo_epr(lcrzo_hs_print_infos(argv[1]));
  */

  /*verify if it's a correct hostname, and set hs*/
  lcrzo_epr(lcrzo_hs_init(argv[1], hs));
  
  /*by default, we don't know IP and Ethernet addresses*/
  knowipaddress=LCRZO_FALSE;
  knowethaddress=LCRZO_FALSE;

  /*get the IP address from the hostname*/
  ret=lcrzo_ipl_init_hs(hs, &ipl);
  if (ret==LCRZO_ERR_OK)
  { knowipaddress=LCRZO_TRUE;
    /*get the Ethernet address from the IP address*/
    ret=lcrzo_eths_init_ipl(ipl, eths);
    if (ret==LCRZO_ERR_OK) knowethaddress=LCRZO_TRUE;
  }

  /*get the language for printed messages*/
  lcrzo_epr(lcrzo_global_get_language(&language));
  if ( language==LCRZO_GLOBAL_FRLANG )
  { printf("nom de machine :    %s\n", hs);
    printf(" adresse ip :       ");
    if (knowipaddress)  lcrzo_ipl_print("", ipl, "\n");
    else                printf("%s\n", "non resolue");
    printf(" adresse ethernet : %s\n", knowethaddress?eths:"non resolue");
  }
  else
  { printf("computer name :     %s\n", hs);
    printf(" ip address :       ");
    if (knowipaddress)  lcrzo_ipl_print("", ipl, "\n");
    else                printf("%s\n", "unresolved");
    printf(" ethernet address : %s\n", knowethaddress?eths:"unresolved");
  }

  return(LCRZO_ERR_OK);
}
