
/* include the library headers */
#include <lcrzo.h>
#include <stdio.h>

/* set information about this example */
lcrzoex_infos lcrzoex_000003=
{ /*reference*/     "lcrzoex", 3, 
  /*version*/       1, 2, 
  /*title*/         "print informations about an IP address", 
  /*french title*/  "affiche les informations sur une adresse IP", 
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "IP_address",
  /*french usage*/  "adresse_ip", 
  /*usage example*/ "1.2.3.4",
  /*fr. usage ex.*/ "1.2.3.4", 
  /*author*/        "Laurent"
};

/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000003_main(int argc, char *argv[]);
int lcrzoex_000003_main(int argc, char *argv[])
{ lcrzo_hs hs;
  lcrzo_ipl ipl;
  lcrzo_eths eths;
  lcrzo_bool knowhostname, knowethaddress;
  int ret, language;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000003, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /*we have 3 seconds to resolv the hostname*/
  lcrzo_epr(lcrzo_global_set_resolver_timeout(3));

  /*all the following is equivalent to this function call
    lcrzo_epr(lcrzo_ips_print_infos(argv[1]));
  */

  /*verify if it's a correct IP address, and set ipl*/
  lcrzo_epr(lcrzo_ipl_init_ips(argv[1], &ipl));
  
  /*get the hostname from the IP address*/
  ret=lcrzo_hs_init_ipl(ipl, hs);
  if (ret==LCRZO_ERR_OK) knowhostname=LCRZO_TRUE;
  else knowhostname=LCRZO_FALSE;

  /*get the Ethernet address from the IP address*/
  ret=lcrzo_eths_init_ipl(ipl, eths);
  if (ret==LCRZO_ERR_OK) knowethaddress=LCRZO_TRUE;
  else knowethaddress=LCRZO_FALSE;

  /*get the language for printed messages*/
  lcrzo_epr(lcrzo_global_get_language(&language));
  if ( language==LCRZO_GLOBAL_FRLANG )
  { printf("adresse ip :        %s\n", argv[1]);
    printf(" nom de machine :   %s\n", knowhostname?hs:"non resolu");
    printf(" adresse ethernet : %s\n", knowethaddress?eths:"non resolue");
  }
  else
  { printf("ip address :        %s\n", argv[1]);
    printf(" computer name :    %s\n", knowhostname?hs:"unresolved");
    printf(" ethernet address : %s\n", knowethaddress?eths:"unresolved");
  }

  return(LCRZO_ERR_OK);
}







