
/* include the library headers */
#include <lcrzo.h>
#include <stdio.h>

/* set information about this example */
lcrzoex_infos lcrzoex_000004=
{ /*reference*/     "lcrzoex", 4, 
  /*version*/       1, 2, 
  /*title*/         "print informations about an Ethernet address", 
  /*french title*/  "affiche les informations sur une adresse Ethernet", 
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "ethernet_address",
  /*french usage*/  "adresse_ethernet",
  /*usage example*/ "aa:bb:cc:dd:ee:ff",
  /*fr. usage ex.*/ "aa:bb:cc:dd:ee:ff", 
  /*author*/        "Laurent"
};

/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000004_main(int argc, char *argv[]);
int lcrzoex_000004_main(int argc, char *argv[])
{ lcrzo_eths eths;
  lcrzo_ipl ipl;
  lcrzo_hs hs;
  lcrzo_bool knowipaddress, knowhostname;
  int ret, language;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000004, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /*we have 3 seconds to resolv the hostname*/
  lcrzo_epr(lcrzo_global_set_resolver_timeout(3));

  /*all the following is equivalent to this function call
    lcrzo_epr(lcrzo_eths_print_infos(argv[1]));
  */

  /*verify if it's a correct Ethernet address, and set eths*/
  lcrzo_epr(lcrzo_eths_init(argv[1], eths));

  /*by default, we don't know IP address and hostname*/
  knowipaddress=LCRZO_FALSE;
  knowhostname=LCRZO_FALSE;

  /*get the IP address from the Ethernet address*/
  ret=lcrzo_ipl_init_eths(eths, &ipl);
  if (ret==LCRZO_ERR_OK)
  { knowipaddress=LCRZO_TRUE;
    /*get the hostname from the IP address*/
    ret=lcrzo_hs_init_ipl(ipl, hs);
    if (ret==LCRZO_ERR_OK) knowhostname=LCRZO_TRUE;
  }

  /*get the language for printed messages*/
  lcrzo_epr(lcrzo_global_get_language(&language));
  if ( language==LCRZO_GLOBAL_FRLANG )
  { printf("adresse ethernet :  %s\n", eths);
    printf(" adresse ip :       ");
    if (knowipaddress)  lcrzo_ipl_print("", ipl, "\n");
    else                printf("%s\n", "non resolue");
    printf(" nom de machine :   %s\n", knowhostname?hs:"non resolu");
  }
  else
  { printf("ethernet address :  %s\n", eths);
    printf(" ip address :       ");
    if (knowipaddress)  lcrzo_ipl_print("", ipl, "\n");
    else                printf("%s\n", "unresolved");
    printf(" computer name :    %s\n", knowhostname?hs:"unresolved");
  }

  return(LCRZO_ERR_OK);
}
