
/* include the library headers */
#include <lcrzo.h>
#include <stdio.h>
#include <stdio.h>

/* set information about this example */
lcrzoex_infos lcrzoex_000005=
{ /*reference*/     "lcrzoex", 5, 
  /*version*/       1, 1, 
  /*title*/         "print informations about a device", 
  /*french title*/  "affiche les informations sur un device", 
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device",
  /*french usage*/  "device", 
  /*usage example*/ "eth0",
  /*fr. usage ex.*/ "eth0", 
  /*author*/        "Laurent"
};

/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000005_main(int argc, char *argv[]);
int lcrzoex_000005_main(int argc, char *argv[])
{ lcrzo_device dev;
  lcrzo_hs hs;
  lcrzo_ipl ipl, mask;
  lcrzo_etha etha;
  lcrzo_bool knowhostname, knowipaddress, knowethaddress;
  int ret, language;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000005, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /*we have 3 seconds to resolv the hostname*/
  lcrzo_epr(lcrzo_global_set_resolver_timeout(3));

  /*all the following is equivalent to this function call
    lcrzo_epr(lcrzo_device_print_infos(argv[1]));
  */

  /*verify if it's a correct device, and set dev*/
  lcrzo_epr(lcrzo_device_init(argv[1], dev));
  
  /*by default, we don't know hostname, IP and Ethernet addresses*/
  knowhostname=LCRZO_FALSE;
  knowipaddress=LCRZO_FALSE;
  knowethaddress=LCRZO_FALSE;

  /*get the hostname from the device*/
  ret=lcrzo_hs_init_device(dev, hs);
  if (ret==LCRZO_ERR_OK) knowhostname=LCRZO_TRUE;

  /*get the ip/mask from the device*/
  ret=lcrzo_ipl_init_device(dev, &ipl, &mask);
  if (ret==LCRZO_ERR_OK) knowipaddress=LCRZO_TRUE;

  /*get the Ethernet address from the device*/
  ret=lcrzo_etha_init_device(dev, etha);
  if (ret==LCRZO_ERR_OK) knowethaddress=LCRZO_TRUE;

  /*get the language for printed messages*/
  lcrzo_epr(lcrzo_global_get_language(&language));
  /*print device*/
  printf("device :            %s\n", dev);
  /*print Ethernet address*/
  printf(" %s : ", (language==LCRZO_GLOBAL_FRLANG)?
	 "adresse ethernet":"ethernet address");
  if (knowethaddress)
    lcrzo_etha_print("", etha, "\n");
  else
    printf("%s\n", (language==LCRZO_GLOBAL_FRLANG)?"non resolue":"unresolved");
  /*print IP address*/
  printf(" %s :       ", (language==LCRZO_GLOBAL_FRLANG)?
	 "adresse ip":"ip address");
  if (knowipaddress)
  { lcrzo_ipl_print("", ipl, "/");
    lcrzo_ipl_print("", mask, "\n");
  }
  else 
  { printf("%s\n", (language==LCRZO_GLOBAL_FRLANG)?"non resolue":"unresolved");
  }
  /*print hostname*/
  if ( language==LCRZO_GLOBAL_FRLANG )
  { printf(" nom de machine :   %s\n", knowhostname?hs:"non resolu");
  }
  else
  { printf(" computer name :    %s\n", knowhostname?hs:"unresolved");
  }

  return(LCRZO_ERR_OK);
}
