
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000007=
{ /*reference*/     "lcrzoex", 7,
  /*version*/       1, 0,
  /*title*/         "sniff packets and print them",
  /*french title*/  "sniffe des paquets et les affiche",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "[device [\"bpf_filter\"]]",
  /*french usage*/  "[device [\"filtre_bpf\"]]",
  /*usage example*/ "eth0 \"host 1.2.3.4 and port 25\"",
  /*fr. usage ex.*/ "eth0 \"host 1.2.3.4 and port 25\"", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declaration */
int lcrzoex_000007_main(int argc, char *argv[]);
int lcrzoex_000007shared_sniff_dump(int argc, char *argv[], int snifftype);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000007_main(int argc, char *argv[])
{
  lcrzo_epr(lcrzoex_000007shared_sniff_dump(argc, argv, 
					    LCRZO_SNIFF_TYPE_NORMAL));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000007shared_sniff_dump(int argc, char *argv[], int snifftype)
{ lcrzo_device device;
  lcrzo_uint32 mtu;
  lcrzo_sniff sniff;
  lcrzo_data sniffdata;
  lcrzo_int32 sniffdatasize;
  lcrzo_printprofile printprofile;
  int ret, language;
  
  /* init device and mtu */
  if (argc<=1)
  { lcrzo_epr(lcrzo_device_value_pos(LCRZO_DEVICE_TYPE_ONLYBOARDS, 1, device));
  }
  else
  { lcrzo_epr(lcrzo_device_init(argv[1], device));
  }
  lcrzo_epr(lcrzo_mtu_init_device(device, &mtu));

  /* get printprofile */
  lcrzo_epr(lcrzo_global_get_language(&language));
  lcrzo_printprofile_stdin((language==LCRZO_GLOBAL_FRLANG)?
			   "Choisissez le profil d'affichage":
			   "Choose the print profile",
			   LCRZO_PRINTPROFILE_ARRAYDUMP, &printprofile);

  /* init sniff */
  if (argc<=2)
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, "", &sniff));
  }
  else
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, argv[2], &sniff));
  }

  /* main loop */
  ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, snifftype, 
			&sniffdata, &sniffdatasize);
  while (ret==LCRZO_ERR_OK)
  { lcrzo_packet_print_eth(sniffdata, sniffdatasize, printprofile);
    lcrzo_data_free(sniffdata);
    if (printprofile.hdr!=LCRZO_PRINTTYPE_SYNTH) printf("\n");
    ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, snifftype,
			  &sniffdata, &sniffdatasize);
  }

  /* close everything */
  lcrzo_epr(lcrzo_sniff_close(&sniff));
  lcrzo_err_print(ret);
  return (ret);
}
