
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000010=
{ /*reference*/     "lcrzoex", 10,
  /*version*/       1, 0,
  /*title*/         "sniff packets and save them",
  /*french title*/  "sniffe des paquets et les sauve",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "file [device [\"bpf_filter\"]]",
  /*french usage*/  "fichier [device [\"filtre_bpf\"]]",
  /*usage example*/ "/tmp/file eth0 \"host 1.2.3.4 and port 25\"",
  /*fr. usage ex.*/ "/tmp/fichier eth0 \"host 1.2.3.4 and port 25\"", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declaration */
int lcrzoex_000010_main(int argc, char *argv[]);
int lcrzoex_000010shared_sniff_dumpsave(int argc, char *argv[], int snifftype);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000010_main(int argc, char *argv[])
{
  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000010, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzoex_000010shared_sniff_dumpsave(argc, argv, 
						LCRZO_SNIFF_TYPE_NORMAL));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
void lcrzoex_000010_sig_received(int i);
lcrzo_record lcrzoex_000010_record;
int lcrzoex_000010shared_sniff_dumpsave(int argc, char *argv[], int snifftype)
{ lcrzo_device device;
  lcrzo_uint32 mtu;
  lcrzo_sniff sniff;
  lcrzo_data sniffdata;
  lcrzo_int32 sniffdatasize;
  lcrzo_printprofile printprofile1, printprofile2;
  int ret, language;
  
  /* open the record */
  lcrzo_epr(lcrzo_record_open(&lcrzoex_000010_record, argv[1],
			      LCRZO_RECORD_OPEN_WRITE));

  /* prepare for Control-C */
  signal(SIGINT, lcrzoex_000010_sig_received);

  /* init device and mtu */
  if (argc<=2)
  { lcrzo_epr(lcrzo_device_value_pos(LCRZO_DEVICE_TYPE_ONLYBOARDS, 1, device));
  }
  else
  { lcrzo_epr(lcrzo_device_init(argv[2], device));
  }
  lcrzo_epr(lcrzo_mtu_init_device(device, &mtu));

  /* get print profile */
  lcrzo_epr(lcrzo_global_get_language(&language));
  lcrzo_printprofile_stdin((language==LCRZO_GLOBAL_FRLANG)?
			   "Choisissez le profil d'affichage pour l'ecran":
			   "Choose the screen print profile",
			   LCRZO_PRINTPROFILE_ARRAYDUMP, &printprofile1);
  lcrzo_printprofile_stdin_record((language==LCRZO_GLOBAL_FRLANG)?
			   "Choisissez le profil d'affichage pour le record":
			   "Choose the record print profile",
			   LCRZO_PRINTPROFILE_HEXANCHMS, &printprofile2);

  /* init sniff */
  if (argc<=3)
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, "", &sniff));
  }
  else
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, argv[3], &sniff));
  }

  /* main loop */
  ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, snifftype, 
			&sniffdata, &sniffdatasize);
  while (ret==LCRZO_ERR_OK)
  { lcrzo_packet_print_eth(sniffdata, sniffdatasize, printprofile1);
    if (printprofile1.hdr!=LCRZO_PRINTTYPE_SYNTH) printf("\n");
    lcrzo_epr(lcrzo_record_write_eth(&lcrzoex_000010_record,
				     sniffdata, sniffdatasize,
				     printprofile2));
    lcrzo_data_free(sniffdata);
    ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, snifftype, 
			  &sniffdata, &sniffdatasize);
  }

  /* close everything */
  lcrzo_epr(lcrzo_record_close(&lcrzoex_000010_record));
  lcrzo_epr(lcrzo_sniff_close(&sniff));
  lcrzo_err_print(ret);
  return (ret);
}

/*-------------------------------------------------------------*/
void lcrzoex_000010_sig_received(int i)
{ int language;

  /* close the record, and exit */
  lcrzo_global_get_language(&language);
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Fermeture du fichier (recu : SIG%d)\n", i);
  else
    printf("Closing file (received : SIG%d)\n", i);
  lcrzo_record_close(&lcrzoex_000010_record);
  raise(SIGTERM);
}
