
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000013=
{ /*reference*/     "lcrzoex", 13,
  /*version*/       1, 0,
  /*title*/         "sniff packets and save IP packets",
  /*french title*/  "sniffe des paquets et sauve les paquets IP",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "file [device [\"bpf_filter\"]]",
  /*french usage*/  "fichier [device [\"filtre_bpf\"]]",
  /*usage example*/ "/tmp/file eth0 \"host 1.2.3.4 and port 25\"",
  /*fr. usage ex.*/ "/tmp/fichier eth0 \"host 1.2.3.4 and port 25\"", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declaration */
int lcrzoex_000013_main(int argc, char *argv[]);
int lcrzoex_000013shared_sniff_dumpsave(int argc, char *argv[], int snifftype);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000013_main(int argc, char *argv[])
{
  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000013, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzoex_000013shared_sniff_dumpsave(argc, argv, 
						LCRZO_SNIFF_TYPE_NORMAL));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
void lcrzoex_000013_sig_received(int i);
lcrzo_record lcrzoex_000013_record;
int lcrzoex_000013shared_sniff_dumpsave(int argc, char *argv[], int snifftype)
{ lcrzo_device device;
  lcrzo_uint32 mtu;
  lcrzo_sniff sniff;
  lcrzo_data sniffdata, ipdata;
  lcrzo_int32 sniffdatasize;
  lcrzo_uint16 ipdatasize;
  lcrzo_ipopt ipopt;
  lcrzo_uint8 ipoptsize;
  lcrzo_printprofile printprofile1, printprofile2;
  lcrzo_hdrlip hdrlip;
  int ret, language;
  
  /* open the record */
  lcrzo_epr(lcrzo_record_open(&lcrzoex_000013_record, argv[1],
			      LCRZO_RECORD_OPEN_WRITE));

  /* prepare for Control-C */
  signal(SIGINT, lcrzoex_000013_sig_received);

  /* init device and mtu */
  if (argc<=2)
  { lcrzo_epr(lcrzo_device_value_pos(LCRZO_DEVICE_TYPE_ONLYBOARDS, 1, device));
  }
  else
  { lcrzo_epr(lcrzo_device_init(argv[2], device));
  }
  lcrzo_epr(lcrzo_mtu_init_device(device, &mtu));

  /* get print profile */
  lcrzo_epr(lcrzo_global_get_language(&language));
  lcrzo_printprofile_stdin((language==LCRZO_GLOBAL_FRLANG)?
			   "Choisissez le profil d'affichage pour l'ecran":
			   "Choose the screen print profile",
			   LCRZO_PRINTPROFILE_ARRAYDUMP, &printprofile1);
  lcrzo_printprofile_stdin_record((language==LCRZO_GLOBAL_FRLANG)?
			   "Choisissez le profil d'affichage pour le record":
			   "Choose the record print profile",
			   LCRZO_PRINTPROFILE_HEXANCHMS, &printprofile2);

  /* init sniff */
  if (argc<=3)
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, "", &sniff));
  }
  else
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, argv[3], &sniff));
  }

  /* main loop */
  ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, snifftype,
			&sniffdata, &sniffdatasize);
  while (ret==LCRZO_ERR_OK)
  { /* only print if it's IP */
    ret=lcrzo_packet_decodem_ethipoptdata(sniffdata, sniffdatasize,
					  NULL, &hdrlip,
					  ipopt, &ipoptsize,
					  &ipdata, &ipdatasize);
    lcrzo_data_free(sniffdata);
    if ( ret==LCRZO_ERR_OK )
    { /* reconstruct the packet to print */
      lcrzo_packet_initm_ipoptdata(hdrlip, ipopt, ipoptsize,
				   ipdata, ipdatasize,
				   &sniffdata, &sniffdatasize);
      lcrzo_data_free(ipdata);
      lcrzo_packet_print_ip(sniffdata, sniffdatasize, printprofile1);
      if (printprofile1.hdr!=LCRZO_PRINTTYPE_SYNTH) printf("\n");
      lcrzo_record_write_ip(&lcrzoex_000013_record,
			    sniffdata, sniffdatasize,
			    printprofile2);
      lcrzo_data_free(sniffdata);
    }
    ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, snifftype,
			  &sniffdata, &sniffdatasize);
  }

  /* close everything */
  lcrzo_epr(lcrzo_record_close(&lcrzoex_000013_record));
  lcrzo_epr(lcrzo_sniff_close(&sniff));
  lcrzo_err_print(ret);
  return (ret);
}

/*-------------------------------------------------------------*/
void lcrzoex_000013_sig_received(int i)
{ int language;

  /* close the record, and exit */
  lcrzo_global_get_language(&language);
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Fermeture du fichier (recu : SIG%d)\n", i);
  else
    printf("Closing file (received : SIG%d)\n", i);
  lcrzo_record_close(&lcrzoex_000013_record);
  raise(SIGTERM);
}
