
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000016=
{ /*reference*/     "lcrzoex", 16,
  /*version*/       1, 0,
  /*title*/         "sniff packets and verify checksum",
  /*french title*/  "sniffe des paquets et verifie les checksum",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "[device [\"bpf_filter\"]]",
  /*french usage*/  "[device [\"filtre_bpf\"]]",
  /*usage example*/ "eth0 \"host 1.2.3.4 and port 25\"",
  /*fr. usage ex.*/ "eth0 \"host 1.2.3.4 and port 25\"", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declaration */
int lcrzoex_000016_main(int argc, char *argv[]);
int lcrzoex_000016shared_sniff_check(int argc, char *argv[], int snifftype);
int lcrzoex_000016shared_verif_check(lcrzo_constdata packet,
				     lcrzo_int32 packetsize);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000016_main(int argc, char *argv[])
{
  lcrzo_epr(lcrzoex_000016shared_sniff_check(argc, argv, 
					     LCRZO_SNIFF_TYPE_NORMAL));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000016shared_sniff_check(int argc, char *argv[], int snifftype)
{ lcrzo_device device;
  lcrzo_uint32 mtu;
  lcrzo_sniff sniff;
  lcrzo_data sniffdata;
  lcrzo_int32 sniffdatasize;
  int ret;
  
  /* init device and mtu */
  if (argc<=1)
  { lcrzo_epr(lcrzo_device_value_pos(LCRZO_DEVICE_TYPE_ONLYBOARDS, 1, device));
  }
  else
  { lcrzo_epr(lcrzo_device_init(argv[1], device));
  }
  lcrzo_epr(lcrzo_mtu_init_device(device, &mtu));

  /* init sniff */
  if (argc<=2)
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, "", &sniff));
  }
  else
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, argv[2], &sniff));
  }

  /* main loop */
  ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, snifftype,
			&sniffdata, &sniffdatasize);
  while (ret==LCRZO_ERR_OK)
  { lcrzoex_000016shared_verif_check(sniffdata, sniffdatasize);
    lcrzo_data_free(sniffdata);
    ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, snifftype,
			  &sniffdata, &sniffdatasize);
  }

  /* close everything */
  lcrzo_epr(lcrzo_sniff_close(&sniff));
  lcrzo_err_print(ret);
  return (ret);
}

/*-------------------------------------------------------------*/
int lcrzoex_000016shared_verif_check(lcrzo_constdata packet,
				     lcrzo_int32 packetsize)
{ int ret;
  lcrzo_hdrleth hdrleth;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrludp hdrludp;
  lcrzo_hdrltcp hdrltcp;
  lcrzo_hdrlicmp hdrlicmp;
  lcrzo_array2k data, temp;
  lcrzo_int32 tempsize;
  lcrzo_ipopt ipopt;
  lcrzo_tcpopt tcpopt;
  lcrzo_uint8 ipoptsize, tcpoptsize;
  lcrzo_uint16 check1, check2, datasize;

  /* if it's IP+UDP */
  ret=lcrzo_packet_decode_ethipoptudpdata(packet, packetsize,
					  &hdrleth, 
					  &hdrlip, ipopt, &ipoptsize,
					  &hdrludp, LCRZO_ARRAY2K_MAXBYTES,
					  data, &datasize);
  if (ret==LCRZO_ERR_OK)
  { printf("IP %04X\tUDP %04X\t\t", hdrlip.check, hdrludp.check);
    /* we save network values to compare them */
    check1=hdrlip.check;
    check2=hdrludp.check;
    /* the function has to compute checksums */
    hdrlip.check=LCRZO_HDRLIP_CHECK_DEFVAL;
    hdrludp.check=LCRZO_HDRLUDP_CHECK_DEFVAL; 
    lcrzo_packet_init_ipoptudpdata(hdrlip, ipopt, ipoptsize,
				   hdrludp, data, datasize,
				   LCRZO_ARRAY2K_MAXBYTES,
				   temp, &tempsize);
    lcrzo_packet_decode_ipoptudpdata(temp, tempsize,
				     &hdrlip, NULL, NULL,
				     &hdrludp, LCRZO_ARRAY2K_MAXBYTES,
				     NULL, NULL);
    /* compare */
    if ( check1==hdrlip.check &&
	 ((check2==hdrludp.check)||(hdrlip.offsetfrag|hdrlip.morefrag)) )
    { printf("ok\n");
    }
    else
    { printf("IP %04X\tUDP %04X\n", hdrlip.check, hdrludp.check);
      lcrzo_packet_print_eth(packet, packetsize, LCRZO_PRINTPROFILE_ARRAYDUMP);
    }
    return (LCRZO_ERR_OK);
  }

  /* if it's IP+TCP */
  ret=lcrzo_packet_decode_ethipopttcpoptdata(packet, packetsize,
					     &hdrleth, 
					     &hdrlip, ipopt, &ipoptsize,
					     &hdrltcp, 
					     tcpopt, &tcpoptsize,
					     LCRZO_ARRAY2K_MAXBYTES,
					     data, &datasize);
  if (ret==LCRZO_ERR_OK)
  { printf("IP %04X\tTCP %04X\t\t", hdrlip.check, hdrltcp.check);
    check1=hdrlip.check;
    check2=hdrltcp.check;
    hdrlip.check=LCRZO_HDRLIP_CHECK_DEFVAL;
    hdrltcp.check=LCRZO_HDRLTCP_CHECK_DEFVAL; 
    lcrzo_packet_init_ipopttcpoptdata(hdrlip, ipopt, ipoptsize,
				      hdrltcp, tcpopt, tcpoptsize,
				      data, datasize, LCRZO_ARRAY2K_MAXBYTES,
				      temp, &tempsize);
    lcrzo_packet_decode_ipopttcpoptdata(temp, tempsize,
					&hdrlip, NULL, NULL,
					&hdrltcp, NULL, NULL, 
					LCRZO_ARRAY2K_MAXBYTES, NULL, NULL);
    if ( check1==hdrlip.check && 
	 ((check2==hdrltcp.check)||(hdrlip.offsetfrag|hdrlip.morefrag)) )
    { printf("ok\n");
    }
    else
    { printf("IP %04X\tTCP %04X\n", hdrlip.check, hdrltcp.check);
      lcrzo_packet_print_eth(packet, packetsize, LCRZO_PRINTPROFILE_ARRAYDUMP);
    }
    return (LCRZO_ERR_OK);
  }

  /* if it's IP+ICMP */
  ret=lcrzo_packet_decode_ethipopticmpdata(packet, packetsize,
					   &hdrleth, 
					   &hdrlip, ipopt, &ipoptsize,
					   &hdrlicmp, LCRZO_ARRAY2K_MAXBYTES,
					   data, &datasize);
  if (ret==LCRZO_ERR_OK)
  { printf("IP %04X\tICMP %04X\t\t", hdrlip.check, hdrlicmp.check);
    check1=hdrlip.check;
    check2=hdrlicmp.check;
    hdrlip.check=LCRZO_HDRLIP_CHECK_DEFVAL;
    hdrlicmp.check=LCRZO_HDRLICMP_CHECK_DEFVAL; 
    lcrzo_packet_init_ipopticmpdata(hdrlip, ipopt, ipoptsize,
				    hdrlicmp, data, datasize,
				    LCRZO_ARRAY2K_MAXBYTES,
				    temp, &tempsize);
    lcrzo_packet_decode_ipopticmpdata(temp, tempsize,
				      &hdrlip, NULL, NULL,
				      &hdrlicmp,
				      LCRZO_ARRAY2K_MAXBYTES,
				      NULL, NULL);
    if ( check1==hdrlip.check &&
	 ((check2==hdrlicmp.check)||(hdrlip.offsetfrag|hdrlip.morefrag)) )
    { printf("ok\n");
    }
    else
    { printf("IP %04X\tICMP %04X\n", hdrlip.check, hdrlicmp.check);
      lcrzo_packet_print_eth(packet, packetsize, LCRZO_PRINTPROFILE_ARRAYDUMP);
    }
    return (LCRZO_ERR_OK);
  }

  /* if it's IP only */
  ret=lcrzo_packet_decode_ethipoptdata(packet, packetsize,
				       &hdrleth, 
				       &hdrlip, ipopt, &ipoptsize,
				       LCRZO_ARRAY2K_MAXBYTES,
				       data, &datasize);
  if (ret==LCRZO_ERR_OK)
  { printf("IP %04X\t\t\t", hdrlip.check);
    check1=hdrlip.check;
    hdrlip.check=LCRZO_HDRLIP_CHECK_DEFVAL;
    lcrzo_packet_init_ipoptdata(hdrlip, ipopt, ipoptsize,
				data, datasize,
				LCRZO_ARRAY2K_MAXBYTES,
				temp, &tempsize);
    lcrzo_packet_decode_ipoptdata(temp, tempsize,
				  &hdrlip, NULL, NULL,
				  LCRZO_ARRAY2K_MAXBYTES,
				  NULL, NULL);
    if ( check1==hdrlip.check )
    { printf("ok\n");
    }
    else
    { printf("IP %04X\n", hdrlip.check);
      lcrzo_packet_print_eth(packet, packetsize, LCRZO_PRINTPROFILE_ARRAYDUMP);
    }
    return (LCRZO_ERR_OK);
  }

  return (LCRZO_ERR_OK);
}
