
/* include the library headers */
#include <lcrzo.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000019=
{ /*reference*/     "lcrzoex", 19,
  /*version*/       1, 0,
  /*title*/         "sniff packets and count them",
  /*french title*/  "sniffe des paquets et les compte",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "[device [\"bpf_filter\"]]",
  /*french usage*/  "[device [\"filtre_bpf\"]]",
  /*usage example*/ "eth0 \"host 1.2.3.4 and port 25\"",
  /*fr. usage ex.*/ "eth0 \"host 1.2.3.4 and port 25\"", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declaration */
int lcrzoex_000019_main(int argc, char *argv[]);
int lcrzoex_000019shared_sniff_count(int argc, char *argv[], int snifftype);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000019_main(int argc, char *argv[])
{
  lcrzo_epr(lcrzoex_000019shared_sniff_count(argc, argv, 
					     LCRZO_SNIFF_TYPE_NORMAL));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000019shared_sniff_count(int argc, char *argv[], int snifftype)
{ lcrzo_device device;
  lcrzo_uint32 mtu;
  lcrzo_sniff sniff;
  int ret, i, language;
  
  /* init device and mtu */
  if (argc<=1)
  { lcrzo_epr(lcrzo_device_value_pos(LCRZO_DEVICE_TYPE_ONLYBOARDS, 1, device));
  }
  else
  { lcrzo_epr(lcrzo_device_init(argv[1], device));
  }
  lcrzo_epr(lcrzo_mtu_init_device(device, &mtu));

  /* init sniff */
  if (argc<=2)
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, "", &sniff));
  }
  else
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, argv[2], &sniff));
  }

  lcrzo_epr(lcrzo_global_get_language(&language));

  /* main loop */
  ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, snifftype, NULL, NULL);
  i=0;
  while (ret==LCRZO_ERR_OK)
  { i++; 
    if (!(i%100))
    { printf((language==LCRZO_GLOBAL_FRLANG)?"Paquet %d\n":"Packet %d\n", i);
    }
    ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, snifftype, NULL, NULL);
  }

  /* close everything */
  lcrzo_epr(lcrzo_sniff_close(&sniff));
  lcrzo_err_print(ret);
  return (ret);
}
