
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000023=
{ /*reference*/     "lcrzoex", 23,
  /*version*/       1, 0,
  /*title*/         "spoof Ethernet packets saved in a record",
  /*french title*/  "spoofe les paquets Ethernet sauves dans record",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "file [device [startpacket [endpacket]]]",
  /*french usage*/  "nom_fichier [device [packet_debut [packet_fin]]]",
  /*usage example*/ "/tmp/file eth0 1 5",
  /*fr. usage ex.*/ "/tmp/fichier eth0 1 5", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declaration */
int lcrzoex_000023_main(int argc, char *argv[]);
int lcrzoex_000023shared_spoofethdata(lcrzo_constdata data,
				      lcrzo_int32 datasize,
				      const void *pinfos);

/*-------------------------------------------------------------*/
/* variable declaration */
lcrzo_device lcrzoex_000023device;

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000023_main(int argc, char *argv[])
{ lcrzo_int32 start, end;
  lcrzo_record record;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000023, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }
  if (argc>=4) start=atol(argv[3]); else start=+1;
  if (argc>=5) end=atol(argv[4]); else end=-1;

  /* init device */
  if (argc<=2)
  { lcrzo_epr(lcrzo_device_value_pos(LCRZO_DEVICE_TYPE_ONLYBOARDS, 1,
				     lcrzoex_000023device));
  }
  else
  { lcrzo_epr(lcrzo_device_init(argv[2], lcrzoex_000023device));
  }

  /* open the record */
  lcrzo_epr(lcrzo_record_open(&record, argv[1], LCRZO_RECORD_OPEN_READ));

  /* main loop */
  lcrzo_epr(lcrzo_record_loop_range(&record, start, end,
				    &lcrzoex_000023shared_spoofethdata, NULL));

  /* end */
  lcrzo_epr(lcrzo_record_close(&record));
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000023shared_spoofethdata(lcrzo_constdata data,
				      lcrzo_int32 datasize,
				      const void *pinfos)
{ lcrzo_spoof spoof;
  /*print*/
  lcrzo_epr(lcrzo_packet_print_eth(data, datasize,
				   LCRZO_PRINTPROFILE_ARRAYDUMP));
  /*spoof*/
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_eth(&spoof, lcrzoex_000023device, data, datasize));
  lcrzo_epr(lcrzo_spoof_close(&spoof));
  return (LCRZO_ERR_OK);
}

