
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000024=
{ /*reference*/     "lcrzoex", 24,
  /*version*/       1, 0,
  /*title*/         "Ethernet spoof specified by user",
  /*french title*/  "spoof Ethernet specifie par l'utilisateur",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "",
  /*french usage*/  "",
  /*usage example*/ "",
  /*fr. usage ex.*/ "", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000024_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000024_main(int argc, char *argv[])
{ lcrzo_hdrleth hdrleth;
  lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_device device;
  lcrzo_spoof spoof;
  int language;

  /* get language */
  lcrzo_epr(lcrzo_global_get_language(&language));

  /* initialize device */
  lcrzo_epr(lcrzo_device_value_pos(LCRZO_DEVICE_TYPE_ONLYBOARDS, 1,
				   device));
  lcrzo_epr(lcrzo_device_stdin((language==LCRZO_GLOBAL_FRLANG)?
			       "envoyer sur quel device":
			       "send on which device",
			       device, device));

  /* initialize Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&hdrleth));
  lcrzo_epr(lcrzo_etha_stdin((language==LCRZO_GLOBAL_FRLANG)?"adresse source":
			     "source address", "aa:bb:cc:dd:ee:ff", 
			     hdrleth.src));
  lcrzo_epr(lcrzo_etha_stdin((language==LCRZO_GLOBAL_FRLANG)?
			     "adresse destination":"destination address",
			     "ff:ff:ff:ff:ff:ff", 
			     hdrleth.dst));
  lcrzo_epr(lcrzo_uint16_stdin((language==LCRZO_GLOBAL_FRLANG)?
			       "type Ethernet":"Ethernet type", 
			       0, 0xFFFF, LCRZO_HDRLETH_TYPE_IP,
			       &(hdrleth.type)));

  /* initialize data*/
  lcrzo_epr(lcrzo_data_initm_mixed_stdin((language==LCRZO_GLOBAL_FRLANG)?
					 "donnees du paquet":"packet's data",
					 "'hello' 0D0A", &data, &datasize));

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_ethdata(&spoof, device, hdrleth, data, datasize));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  lcrzo_data_free(data);
  return(LCRZO_ERR_OK);
}
