
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000026=
{ /*reference*/     "lcrzoex", 26,
  /*version*/       1, 0,
  /*title*/         "Ethernet spoof specified by command line (constant data)",
  /*french title*/  "spoof Ethernet specifie sur la ligne de commande (donnees constantes)",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device source_eth_address dest_eth_address eth_type",
  /*french usage*/  "device adresse_eth_source adresse_eth_dest type_eth",
  /*usage example*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66 800",
  /*fr. usage ex.*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66 800", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000026_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000026_main(int argc, char *argv[])
{ lcrzo_hdrleth hdrleth;
  lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_device device;
  lcrzo_spoof spoof;

  if ( argc<5 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000026, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize device */
  lcrzo_epr(lcrzo_device_init(argv[1], device));

  /* initialize Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&hdrleth));
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], hdrleth.src));
  lcrzo_epr(lcrzo_etha_init_eths(argv[3], hdrleth.dst));
  hdrleth.type=(lcrzo_uint16)atoi(argv[4]);

  /* initialize data*/
  lcrzo_epr(lcrzo_data_initm_mixed("'hello' 0D0A", &data, &datasize));

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_ethdata(&spoof, device, hdrleth, data, datasize));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  lcrzo_data_free(data);
  return(LCRZO_ERR_OK);
}
