
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000028=
{ /*reference*/     "lcrzoex", 28,
  /*version*/       1, 0,
  /*title*/         "spoof IP packets saved in a record",
  /*french title*/  "spoofe les paquets IP sauves dans record",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "file [startpacket [endpacket]]",
  /*french usage*/  "nom_fichier [packet_debut [packet_fin]]",
  /*usage example*/ "/tmp/file 1 6",
  /*fr. usage ex.*/ "/tmp/fichier 1 6", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declaration */
int lcrzoex_000028_main(int argc, char *argv[]);
int lcrzoex_000028shared_spoofipdata(lcrzo_constdata data,
				     lcrzo_int32 datasize,
				     const void *pinfos);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000028_main(int argc, char *argv[])
{ lcrzo_int32 start, end;
  lcrzo_record record;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000028, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }
  if (argc>=3) start=atol(argv[2]); else start=+1;
  if (argc>=4) end=atol(argv[3]); else end=-1;

  /* open the record */
  lcrzo_epr(lcrzo_record_open(&record, argv[1], LCRZO_RECORD_OPEN_READ));

  /* main loop */
  lcrzo_epr(lcrzo_record_loop_range(&record, start, end,
				    &lcrzoex_000028shared_spoofipdata, NULL));

  /* end */
  lcrzo_epr(lcrzo_record_close(&record));
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000028shared_spoofipdata(lcrzo_constdata data,
				     lcrzo_int32 datasize,
				     const void *pinfos)
{ lcrzo_spoof spoof;
  /*print*/
  lcrzo_epr(lcrzo_packet_print_ip(data, datasize,
				  LCRZO_PRINTPROFILE_ARRAYDUMP));
  /*spoof*/
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_ip(&spoof, data, datasize));
  lcrzo_epr(lcrzo_spoof_close(&spoof));
  return (LCRZO_ERR_OK);
}

